// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InspectContainerHostConfig InspectContainerHostConfig holds information used when the container was
// created.
// It's very much a Docker-specific struct, retained (mostly) as-is for
// compatibility. We fill individual fields as best as we can, inferring as much
// as possible from the spec and container config.
// Some things cannot be inferred. These will be populated by spec annotations
// (if available).
// Field names are fixed for compatibility and cannot be changed.
// As such, silence lint warnings about them.
// nolint
//
// swagger:model InspectContainerHostConfig
type InspectContainerHostConfig struct {

	// AutoRemove is whether the container will be automatically removed on
	// exiting.
	// It is not handled directly within libpod and is stored in an
	// annotation.
	AutoRemove bool `json:"AutoRemove,omitempty"`

	// Binds contains an array of user-added mounts.
	// Both volume mounts and named volumes are included.
	// Tmpfs mounts are NOT included.
	// In 'docker inspect' this is separated into 'Binds' and 'Mounts' based
	// on how a mount was added. We do not make this distinction and do not
	// include a Mounts field in inspect.
	// Format: <src>:<destination>[:<comma-separated options>]
	Binds []string `json:"Binds"`

	// BlkioDeviceReadBps is an array of I/O throttle parameters for
	// individual device nodes.
	// This specifically sets read rate cap in bytes per second for device
	// nodes.
	// As with BlkioWeightDevice, we pull the path from /sys/dev, and we
	// don't guarantee the path will be identical to the original (though
	// the node will be).
	BlkioDeviceReadBps []*InspectBlkioThrottleDevice `json:"BlkioDeviceReadBps"`

	// BlkioDeviceReadIOps is an array of I/O throttle parameters for
	// individual device nodes.
	// This specifically sets the read rate cap in iops per second for
	// device nodes.
	// As with BlkioWeightDevice, we pull the path from /sys/dev, and we
	// don't guarantee the path will be identical to the original (though
	// the node will be).
	BlkioDeviceReadIOps []*InspectBlkioThrottleDevice `json:"BlkioDeviceReadIOps"`

	// BlkioDeviceWriteBps is an array of I/O throttle parameters for
	// individual device nodes.
	// this specifically sets write rate cap in bytes per second for device
	// nodes.
	// as with BlkioWeightDevice, we pull the path from /sys/dev, and we
	// don't guarantee the path will be identical to the original (though
	// the node will be).
	BlkioDeviceWriteBps []*InspectBlkioThrottleDevice `json:"BlkioDeviceWriteBps"`

	// BlkioDeviceWriteIOps is an array of I/O throttle parameters for
	// individual device nodes.
	// This specifically sets the write rate cap in iops per second for
	// device nodes.
	// As with BlkioWeightDevice, we pull the path from /sys/dev, and we
	// don't guarantee the path will be identical to the original (though
	// the node will be).
	BlkioDeviceWriteIOps []*InspectBlkioThrottleDevice `json:"BlkioDeviceWriteIOps"`

	// BlkioWeight indicates the I/O resources allocated to the container.
	// It is a relative weight in the scheduler for assigning I/O time
	// versus other Cgroups.
	BlkioWeight uint16 `json:"BlkioWeight,omitempty"`

	// BlkioWeightDevice is an array of I/O resource priorities for
	// individual device nodes.
	// Unfortunately, the spec only stores the device's Major/Minor numbers
	// and not the path, which is used here.
	// Fortunately, the kernel provides an interface for retrieving the path
	// of a given node by major:minor at /sys/dev/. However, the exact path
	// in use may not be what was used in the original CLI invocation -
	// though it is guaranteed that the device node will be the same, and
	// using the given path will be functionally identical.
	BlkioWeightDevice []*InspectBlkioWeightDevice `json:"BlkioWeightDevice"`

	// CapAdd is a list of capabilities added to the container.
	// It is not directly stored by Libpod, and instead computed from the
	// capabilities listed in the container's spec, compared against a set
	// of default capabilities.
	CapAdd []string `json:"CapAdd"`

	// CapDrop is a list of capabilities removed from the container.
	// It is not directly stored by libpod, and instead computed from the
	// capabilities listed in the container's spec, compared against a set
	// of default capabilities.
	CapDrop []string `json:"CapDrop"`

	// Cgroup contains the container's cgroup. It is presently not
	// populated.
	// TODO.
	Cgroup string `json:"Cgroup,omitempty"`

	// CgroupConf is the configuration for cgroup v2.
	CgroupConf map[string]string `json:"CgroupConf,omitempty"`

	// CgroupManager is the cgroup manager used by the container.
	// At present, allowed values are either "cgroupfs" or "systemd".
	CgroupManager string `json:"CgroupManager,omitempty"`

	// CgroupMode is the configuration of the container's cgroup namespace.
	// Populated as follows:
	// private - a cgroup namespace has been created
	// host - No cgroup namespace created
	// container:<id> - Using another container's cgroup namespace
	// ns:<path> - A path to a cgroup namespace has been specified
	CgroupMode string `json:"CgroupMode,omitempty"`

	// CgroupParent is the Cgroup parent of the container.
	// Only set if not default.
	CgroupParent string `json:"CgroupParent,omitempty"`

	// Cgroups contains the container's Cgroup mode.
	// Allowed values are "default" (container is creating Cgroups) and
	// "disabled" (container is not creating Cgroups).
	// This is Libpod-specific and not included in `docker inspect`.
	Cgroups string `json:"Cgroups,omitempty"`

	// ConsoleSize is an array of 2 integers showing the size of the
	// container's console.
	// It is only set if the container is creating a terminal.
	// TODO.
	ConsoleSize []uint64 `json:"ConsoleSize"`

	// ContainerIDFile is a file created during container creation to hold
	// the ID of the created container.
	// This is not handled within libpod and is stored in an annotation.
	ContainerIDFile string `json:"ContainerIDFile,omitempty"`

	// CpuCount is Windows-only and not presently implemented.
	CPUCount uint64 `json:"CpuCount,omitempty"`

	// CpuPercent is Windows-only and not presently implemented.
	CPUPercent uint64 `json:"CpuPercent,omitempty"`

	// CpuPeriod is the length of a CPU period in microseconds.
	// It relates directly to CpuQuota.
	CPUPeriod uint64 `json:"CpuPeriod,omitempty"`

	// CpuPeriod is the amount of time (in microseconds) that a container
	// can use the CPU in every CpuPeriod.
	CPUQuota int64 `json:"CpuQuota,omitempty"`

	// CpuRealtimePeriod is the length of time (in microseconds) of the CPU
	// realtime period. If set to 0, no time will be allocated to realtime
	// tasks.
	CPURealtimePeriod uint64 `json:"CpuRealtimePeriod,omitempty"`

	// CpuRealtimeRuntime is the length of time (in microseconds) allocated
	// for realtime tasks within every CpuRealtimePeriod.
	CPURealtimeRuntime int64 `json:"CpuRealtimeRuntime,omitempty"`

	// CpuShares indicates the CPU resources allocated to the container.
	// It is a relative weight in the scheduler for assigning CPU time
	// versus other Cgroups.
	CPUShares uint64 `json:"CpuShares,omitempty"`

	// CpusetCpus is the is the set of CPUs that the container will execute
	// on. Formatted as `0-3` or `0,2`. Default (if unset) is all CPUs.
	CpusetCpus string `json:"CpusetCpus,omitempty"`

	// CpusetMems is the set of memory nodes the container will use.
	// Formatted as `0-3` or `0,2`. Default (if unset) is all memory nodes.
	CpusetMems string `json:"CpusetMems,omitempty"`

	// Devices is a list of device nodes that will be added to the
	// container.
	// These are stored in the OCI spec only as type, major, minor while we
	// display the host path. We convert this with /sys/dev, but we cannot
	// guarantee that the host path will be identical - only that the actual
	// device will be.
	Devices []*InspectDevice `json:"Devices"`

	// DiskQuota is the maximum amount of disk space the container may use
	// (in bytes).
	// Presently not populated.
	// TODO.
	DiskQuota uint64 `json:"DiskQuota,omitempty"`

	// Dns is a list of DNS nameservers that will be added to the
	// container's resolv.conf
	DNS []string `json:"Dns"`

	// DnsOptions is a list of DNS options that will be set in the
	// container's resolv.conf
	DNSOptions []string `json:"DnsOptions"`

	// DnsSearch is a list of DNS search domains that will be set in the
	// container's resolv.conf
	DNSSearch []string `json:"DnsSearch"`

	// ExtraHosts contains hosts that will be added to the container's
	// etc/hosts.
	ExtraHosts []string `json:"ExtraHosts"`

	// GroupAdd contains groups that the user inside the container will be
	// added to.
	GroupAdd []string `json:"GroupAdd"`

	// ID mappings
	IDMappings *InspectIDMappings `json:"IDMappings,omitempty"`

	// IOMaximumBandwidth is Windows-only and not presently implemented.
	IOMaximumBandwidth uint64 `json:"IOMaximumBandwidth,omitempty"`

	// IOMaximumIOps is Windows-only and not presently implemented.
	IOMaximumIOps uint64 `json:"IOMaximumIOps,omitempty"`

	// Init indicates whether the container has an init mounted into it.
	Init bool `json:"Init,omitempty"`

	// IpcMode represents the configuration of the container's IPC
	// namespace.
	// Populated as follows:
	// "" (empty string) - Default, an IPC namespace will be created
	// host - No IPC namespace created
	// container:<id> - Using another container's IPC namespace
	// ns:<path> - A path to an IPC namespace has been specified
	IpcMode string `json:"IpcMode,omitempty"`

	// Isolation is presently unused and provided solely for Docker
	// compatibility.
	Isolation string `json:"Isolation,omitempty"`

	// KernelMemory is the maximum amount of memory the kernel will devote
	// to the container.
	KernelMemory int64 `json:"KernelMemory,omitempty"`

	// Links is unused, and provided purely for Docker compatibility.
	Links []string `json:"Links"`

	// log config
	LogConfig *InspectLogConfig `json:"LogConfig,omitempty"`

	// Memory indicates the memory resources allocated to the container.
	// This is the limit (in bytes) of RAM the container may use.
	Memory int64 `json:"Memory,omitempty"`

	// MemoryReservation is the reservation (soft limit) of memory available
	// to the container. Soft limits are warnings only and can be exceeded.
	MemoryReservation int64 `json:"MemoryReservation,omitempty"`

	// MemorySwap is the total limit for all memory available to the
	// container, including swap. 0 indicates that there is no limit to the
	// amount of memory available.
	MemorySwap int64 `json:"MemorySwap,omitempty"`

	// MemorySwappiness is the willingness of the kernel to page container
	// memory to swap. It is an integer from 0 to 100, with low numbers
	// being more likely to be put into swap.
	// 1, the default, will not set swappiness and use the system defaults.
	MemorySwappiness int64 `json:"MemorySwappiness,omitempty"`

	// NanoCpus indicates number of CPUs allocated to the container.
	// It is an integer where one full CPU is indicated by 1000000000 (one
	// billion).
	// Thus, 2.5 CPUs (fractional portions of CPUs are allowed) would be
	// 2500000000 (2.5 billion).
	// In 'docker inspect' this is set exclusively of two further options in
	// the output (CpuPeriod and CpuQuota) which are both used to implement
	// this functionality.
	// We can't distinguish here, so if CpuQuota is set to the default of
	// 100000, we will set both CpuQuota, CpuPeriod, and NanoCpus. If
	// CpuQuota is not the default, we will not set NanoCpus.
	NanoCpus int64 `json:"NanoCpus,omitempty"`

	// NetworkMode is the configuration of the container's network
	// namespace.
	// Populated as follows:
	// default - A network namespace is being created and configured via CNI
	// none - A network namespace is being created, not configured via CNI
	// host - No network namespace created
	// container:<id> - Using another container's network namespace
	// ns:<path> - A path to a network namespace has been specified
	NetworkMode string `json:"NetworkMode,omitempty"`

	// OomKillDisable indicates whether the kernel OOM killer is disabled
	// for the container.
	OomKillDisable bool `json:"OomKillDisable,omitempty"`

	// OOMScoreAdj is an adjustment that will be made to the container's OOM
	// score.
	OomScoreAdj int64 `json:"OomScoreAdj,omitempty"`

	// PidMode represents the configuration of the container's PID
	// namespace.
	// Populated as follows:
	// "" (empty string) - Default, a PID namespace will be created
	// host - No PID namespace created
	// container:<id> - Using another container's PID namespace
	// ns:<path> - A path to a PID namespace has been specified
	PidMode string `json:"PidMode,omitempty"`

	// PidsLimit is the maximum number of PIDs what may be created within
	// the container. 0, the default, indicates no limit.
	PidsLimit int64 `json:"PidsLimit,omitempty"`

	// PortBindings contains the container's port bindings.
	// It is formatted as map[string][]InspectHostPort.
	// The string key here is formatted as <integer port number>/<protocol>
	// and represents the container port. A single container port may be
	// bound to multiple host ports (on different IPs).
	PortBindings map[string][]InspectHostPort `json:"PortBindings,omitempty"`

	// Privileged indicates whether the container is running with elevated
	// privileges.
	// This has a very specific meaning in the Docker sense, so it's very
	// difficult to decode from the spec and config, and so is stored as an
	// annotation.
	Privileged bool `json:"Privileged,omitempty"`

	// PublishAllPorts indicates whether image ports are being published.
	// This is not directly stored in libpod and is saved as an annotation.
	PublishAllPorts bool `json:"PublishAllPorts,omitempty"`

	// ReadonlyRootfs is whether the container will be mounted read-only.
	ReadonlyRootfs bool `json:"ReadonlyRootfs,omitempty"`

	// restart policy
	RestartPolicy *InspectRestartPolicy `json:"RestartPolicy,omitempty"`

	// Runtime is provided purely for Docker compatibility.
	// It is set unconditionally to "oci" as Podman does not presently
	// support non-OCI runtimes.
	Runtime string `json:"Runtime,omitempty"`

	// SecurityOpt is a list of security-related options that are set in the
	// container.
	SecurityOpt []string `json:"SecurityOpt"`

	// shm size
	ShmSize int64 `json:"ShmSize,omitempty"`

	// Tmpfs is a list of tmpfs filesystems that will be mounted into the
	// container.
	// It is a map of destination path to options for the mount.
	Tmpfs map[string]string `json:"Tmpfs,omitempty"`

	// UTSMode represents the configuration of the container's UID
	// namespace.
	// Populated as follows:
	// "" (empty string) - Default, a UTS namespace will be created
	// host - no UTS namespace created
	// container:<id> - Using another container's UTS namespace
	// ns:<path> - A path to a UTS namespace has been specified
	UTSMode string `json:"UTSMode,omitempty"`

	// Ulimits is a set of ulimits that will be set within the container.
	Ulimits []*InspectUlimit `json:"Ulimits"`

	// UsernsMode represents the configuration of the container's user
	// namespace.
	// When running rootless, a user namespace is created outside of libpod
	// to allow some privileged operations. This will not be reflected here.
	// Populated as follows:
	// "" (empty string) - No user namespace will be created
	// private - The container will be run in a user namespace
	// container:<id> - Using another container's user namespace
	// ns:<path> - A path to a user namespace has been specified
	// TODO Rootless has an additional 'keep-id' option, presently not
	// reflected here.
	UsernsMode string `json:"UsernsMode,omitempty"`

	// VolumeDriver is presently unused and is retained for Docker
	// compatibility.
	VolumeDriver string `json:"VolumeDriver,omitempty"`

	// VolumesFrom is a list of containers which this container uses volumes
	// from. This is not handled directly within libpod and is stored in an
	// annotation.
	// It is formatted as an array of container names and IDs.
	VolumesFrom []string `json:"VolumesFrom"`
}

// Validate validates this inspect container host config
func (m *InspectContainerHostConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlkioDeviceReadBps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceReadIOps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceWriteBps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceWriteIOps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioWeightDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIDMappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortBindings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestartPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUlimits(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InspectContainerHostConfig) validateBlkioDeviceReadBps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceReadBps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceReadBps); i++ {
		if swag.IsZero(m.BlkioDeviceReadBps[i]) { // not required
			continue
		}

		if m.BlkioDeviceReadBps[i] != nil {
			if err := m.BlkioDeviceReadBps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateBlkioDeviceReadIOps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceReadIOps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceReadIOps); i++ {
		if swag.IsZero(m.BlkioDeviceReadIOps[i]) { // not required
			continue
		}

		if m.BlkioDeviceReadIOps[i] != nil {
			if err := m.BlkioDeviceReadIOps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateBlkioDeviceWriteBps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceWriteBps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceWriteBps); i++ {
		if swag.IsZero(m.BlkioDeviceWriteBps[i]) { // not required
			continue
		}

		if m.BlkioDeviceWriteBps[i] != nil {
			if err := m.BlkioDeviceWriteBps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateBlkioDeviceWriteIOps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceWriteIOps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceWriteIOps); i++ {
		if swag.IsZero(m.BlkioDeviceWriteIOps[i]) { // not required
			continue
		}

		if m.BlkioDeviceWriteIOps[i] != nil {
			if err := m.BlkioDeviceWriteIOps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateBlkioWeightDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioWeightDevice) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioWeightDevice); i++ {
		if swag.IsZero(m.BlkioWeightDevice[i]) { // not required
			continue
		}

		if m.BlkioWeightDevice[i] != nil {
			if err := m.BlkioWeightDevice[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateDevices(formats strfmt.Registry) error {
	if swag.IsZero(m.Devices) { // not required
		return nil
	}

	for i := 0; i < len(m.Devices); i++ {
		if swag.IsZero(m.Devices[i]) { // not required
			continue
		}

		if m.Devices[i] != nil {
			if err := m.Devices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateIDMappings(formats strfmt.Registry) error {
	if swag.IsZero(m.IDMappings) { // not required
		return nil
	}

	if m.IDMappings != nil {
		if err := m.IDMappings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IDMappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IDMappings")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) validateLogConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.LogConfig) { // not required
		return nil
	}

	if m.LogConfig != nil {
		if err := m.LogConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("LogConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("LogConfig")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) validatePortBindings(formats strfmt.Registry) error {
	if swag.IsZero(m.PortBindings) { // not required
		return nil
	}

	for k := range m.PortBindings {

		if err := validate.Required("PortBindings"+"."+k, "body", m.PortBindings[k]); err != nil {
			return err
		}

		for i := 0; i < len(m.PortBindings[k]); i++ {

			if err := m.PortBindings[k][i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("PortBindings" + "." + k + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("PortBindings" + "." + k + "." + strconv.Itoa(i))
				}
				return err
			}

		}

	}

	return nil
}

func (m *InspectContainerHostConfig) validateRestartPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.RestartPolicy) { // not required
		return nil
	}

	if m.RestartPolicy != nil {
		if err := m.RestartPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("RestartPolicy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("RestartPolicy")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) validateUlimits(formats strfmt.Registry) error {
	if swag.IsZero(m.Ulimits) { // not required
		return nil
	}

	for i := 0; i < len(m.Ulimits); i++ {
		if swag.IsZero(m.Ulimits[i]) { // not required
			continue
		}

		if m.Ulimits[i] != nil {
			if err := m.Ulimits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this inspect container host config based on the context it is used
func (m *InspectContainerHostConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlkioDeviceReadBps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceReadIOps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceWriteBps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceWriteIOps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioWeightDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIDMappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortBindings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestartPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUlimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InspectContainerHostConfig) contextValidateBlkioDeviceReadBps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceReadBps); i++ {

		if m.BlkioDeviceReadBps[i] != nil {
			if err := m.BlkioDeviceReadBps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateBlkioDeviceReadIOps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceReadIOps); i++ {

		if m.BlkioDeviceReadIOps[i] != nil {
			if err := m.BlkioDeviceReadIOps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateBlkioDeviceWriteBps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceWriteBps); i++ {

		if m.BlkioDeviceWriteBps[i] != nil {
			if err := m.BlkioDeviceWriteBps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateBlkioDeviceWriteIOps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceWriteIOps); i++ {

		if m.BlkioDeviceWriteIOps[i] != nil {
			if err := m.BlkioDeviceWriteIOps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateBlkioWeightDevice(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioWeightDevice); i++ {

		if m.BlkioWeightDevice[i] != nil {
			if err := m.BlkioWeightDevice[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateDevices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Devices); i++ {

		if m.Devices[i] != nil {
			if err := m.Devices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateIDMappings(ctx context.Context, formats strfmt.Registry) error {

	if m.IDMappings != nil {
		if err := m.IDMappings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IDMappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IDMappings")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateLogConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.LogConfig != nil {
		if err := m.LogConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("LogConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("LogConfig")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidatePortBindings(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.PortBindings {

		for i := 0; i < len(m.PortBindings[k]); i++ {

			if err := m.PortBindings[k][i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("PortBindings" + "." + k + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("PortBindings" + "." + k + "." + strconv.Itoa(i))
				}
				return err
			}

		}

	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateRestartPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.RestartPolicy != nil {
		if err := m.RestartPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("RestartPolicy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("RestartPolicy")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerHostConfig) contextValidateUlimits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Ulimits); i++ {

		if m.Ulimits[i] != nil {
			if err := m.Ulimits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *InspectContainerHostConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InspectContainerHostConfig) UnmarshalBinary(b []byte) error {
	var res InspectContainerHostConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
