// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NetworkCreateRequest NetworkCreateRequest is the request message sent to the server for network create call.
//
// swagger:model NetworkCreateRequest
type NetworkCreateRequest struct {

	// attachable
	Attachable bool `json:"Attachable,omitempty"`

	// Check for networks with duplicate names.
	// Network is primarily keyed based on a random ID and not on the name.
	// Network name is strictly a user-friendly alias to the network
	// which is uniquely identified using ID.
	// And there is no guaranteed way to check for duplicates.
	// Option CheckDuplicate is there to provide a best effort checking of any networks
	// which has the same name but it is not guaranteed to catch all name collisions.
	CheckDuplicate bool `json:"CheckDuplicate,omitempty"`

	// config from
	ConfigFrom *ConfigReference `json:"ConfigFrom,omitempty"`

	// config only
	ConfigOnly bool `json:"ConfigOnly,omitempty"`

	// driver
	Driver string `json:"Driver,omitempty"`

	// enable IPv6
	EnableIPV6 bool `json:"EnableIPv6,omitempty"`

	// IP a m
	IPAM *IPAM `json:"IPAM,omitempty"`

	// ingress
	Ingress bool `json:"Ingress,omitempty"`

	// internal
	Internal bool `json:"Internal,omitempty"`

	// labels
	Labels map[string]string `json:"Labels,omitempty"`

	// name
	Name string `json:"Name,omitempty"`

	// options
	Options map[string]string `json:"Options,omitempty"`

	// scope
	Scope string `json:"Scope,omitempty"`
}

// Validate validates this network create request
func (m *NetworkCreateRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfigFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAM(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkCreateRequest) validateConfigFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigFrom) { // not required
		return nil
	}

	if m.ConfigFrom != nil {
		if err := m.ConfigFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ConfigFrom")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ConfigFrom")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkCreateRequest) validateIPAM(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAM) { // not required
		return nil
	}

	if m.IPAM != nil {
		if err := m.IPAM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IPAM")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IPAM")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network create request based on the context it is used
func (m *NetworkCreateRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPAM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkCreateRequest) contextValidateConfigFrom(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfigFrom != nil {
		if err := m.ConfigFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ConfigFrom")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ConfigFrom")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkCreateRequest) contextValidateIPAM(ctx context.Context, formats strfmt.Registry) error {

	if m.IPAM != nil {
		if err := m.IPAM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IPAM")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IPAM")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetworkCreateRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetworkCreateRequest) UnmarshalBinary(b []byte) error {
	var res NetworkCreateRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
