// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NetworkSettings NetworkSettings exposes the network settings in the api
//
// swagger:model NetworkSettings
type NetworkSettings struct {

	// bridge
	Bridge string `json:"Bridge,omitempty"`

	// endpoint ID
	EndpointID string `json:"EndpointID,omitempty"`

	// gateway
	Gateway string `json:"Gateway,omitempty"`

	// global IPv6 address
	GlobalIPV6Address string `json:"GlobalIPv6Address,omitempty"`

	// global IPv6 prefix len
	GlobalIPV6PrefixLen int64 `json:"GlobalIPv6PrefixLen,omitempty"`

	// hairpin mode
	HairpinMode bool `json:"HairpinMode,omitempty"`

	// IP address
	IPAddress string `json:"IPAddress,omitempty"`

	// IP prefix len
	IPPrefixLen int64 `json:"IPPrefixLen,omitempty"`

	// IPv6 gateway
	IPV6Gateway string `json:"IPv6Gateway,omitempty"`

	// link local IPv6 address
	LinkLocalIPV6Address string `json:"LinkLocalIPv6Address,omitempty"`

	// link local IPv6 prefix len
	LinkLocalIPV6PrefixLen int64 `json:"LinkLocalIPv6PrefixLen,omitempty"`

	// mac address
	MacAddress string `json:"MacAddress,omitempty"`

	// networks
	Networks map[string]EndpointSettings `json:"Networks,omitempty"`

	// ports
	Ports PortMap `json:"Ports,omitempty"`

	// sandbox ID
	SandboxID string `json:"SandboxID,omitempty"`

	// sandbox key
	SandboxKey string `json:"SandboxKey,omitempty"`

	// secondary IP addresses
	SecondaryIPAddresses []*Address `json:"SecondaryIPAddresses"`

	// secondary IPv6 addresses
	SecondaryIPV6Addresses []*Address `json:"SecondaryIPv6Addresses"`
}

// Validate validates this network settings
func (m *NetworkSettings) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNetworks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecondaryIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecondaryIPV6Addresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkSettings) validateNetworks(formats strfmt.Registry) error {
	if swag.IsZero(m.Networks) { // not required
		return nil
	}

	for k := range m.Networks {

		if err := validate.Required("Networks"+"."+k, "body", m.Networks[k]); err != nil {
			return err
		}
		if val, ok := m.Networks[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Networks" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Networks" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkSettings) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	if m.Ports != nil {
		if err := m.Ports.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Ports")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Ports")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkSettings) validateSecondaryIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.SecondaryIPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.SecondaryIPAddresses); i++ {
		if swag.IsZero(m.SecondaryIPAddresses[i]) { // not required
			continue
		}

		if m.SecondaryIPAddresses[i] != nil {
			if err := m.SecondaryIPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("SecondaryIPAddresses" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("SecondaryIPAddresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkSettings) validateSecondaryIPV6Addresses(formats strfmt.Registry) error {
	if swag.IsZero(m.SecondaryIPV6Addresses) { // not required
		return nil
	}

	for i := 0; i < len(m.SecondaryIPV6Addresses); i++ {
		if swag.IsZero(m.SecondaryIPV6Addresses[i]) { // not required
			continue
		}

		if m.SecondaryIPV6Addresses[i] != nil {
			if err := m.SecondaryIPV6Addresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("SecondaryIPv6Addresses" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("SecondaryIPv6Addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this network settings based on the context it is used
func (m *NetworkSettings) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetworks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecondaryIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecondaryIPV6Addresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkSettings) contextValidateNetworks(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Networks {

		if val, ok := m.Networks[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *NetworkSettings) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Ports.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Ports")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Ports")
		}
		return err
	}

	return nil
}

func (m *NetworkSettings) contextValidateSecondaryIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SecondaryIPAddresses); i++ {

		if m.SecondaryIPAddresses[i] != nil {
			if err := m.SecondaryIPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("SecondaryIPAddresses" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("SecondaryIPAddresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkSettings) contextValidateSecondaryIPV6Addresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SecondaryIPV6Addresses); i++ {

		if m.SecondaryIPV6Addresses[i] != nil {
			if err := m.SecondaryIPV6Addresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("SecondaryIPv6Addresses" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("SecondaryIPv6Addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetworkSettings) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetworkSettings) UnmarshalBinary(b []byte) error {
	var res NetworkSettings
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
