/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSkupperClusterPolicies implements SkupperClusterPolicyInterface
type FakeSkupperClusterPolicies struct {
	Fake *FakeSkupperV1alpha1
}

var skupperclusterpoliciesResource = schema.GroupVersionResource{Group: "skupper.io", Version: "v1alpha1", Resource: "skupperclusterpolicies"}

var skupperclusterpoliciesKind = schema.GroupVersionKind{Group: "skupper.io", Version: "v1alpha1", Kind: "SkupperClusterPolicy"}

// Get takes name of the skupperClusterPolicy, and returns the corresponding skupperClusterPolicy object, and an error if there is any.
func (c *FakeSkupperClusterPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.SkupperClusterPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(skupperclusterpoliciesResource, name), &v1alpha1.SkupperClusterPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SkupperClusterPolicy), err
}

// List takes label and field selectors, and returns the list of SkupperClusterPolicies that match those selectors.
func (c *FakeSkupperClusterPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.SkupperClusterPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(skupperclusterpoliciesResource, skupperclusterpoliciesKind, opts), &v1alpha1.SkupperClusterPolicyList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.SkupperClusterPolicyList{ListMeta: obj.(*v1alpha1.SkupperClusterPolicyList).ListMeta}
	for _, item := range obj.(*v1alpha1.SkupperClusterPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested skupperClusterPolicies.
func (c *FakeSkupperClusterPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(skupperclusterpoliciesResource, opts))
}

// Create takes the representation of a skupperClusterPolicy and creates it.  Returns the server's representation of the skupperClusterPolicy, and an error, if there is any.
func (c *FakeSkupperClusterPolicies) Create(ctx context.Context, skupperClusterPolicy *v1alpha1.SkupperClusterPolicy, opts v1.CreateOptions) (result *v1alpha1.SkupperClusterPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(skupperclusterpoliciesResource, skupperClusterPolicy), &v1alpha1.SkupperClusterPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SkupperClusterPolicy), err
}

// Update takes the representation of a skupperClusterPolicy and updates it. Returns the server's representation of the skupperClusterPolicy, and an error, if there is any.
func (c *FakeSkupperClusterPolicies) Update(ctx context.Context, skupperClusterPolicy *v1alpha1.SkupperClusterPolicy, opts v1.UpdateOptions) (result *v1alpha1.SkupperClusterPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(skupperclusterpoliciesResource, skupperClusterPolicy), &v1alpha1.SkupperClusterPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SkupperClusterPolicy), err
}

// Delete takes name of the skupperClusterPolicy and deletes it. Returns an error if one occurs.
func (c *FakeSkupperClusterPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(skupperclusterpoliciesResource, name), &v1alpha1.SkupperClusterPolicy{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSkupperClusterPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(skupperclusterpoliciesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.SkupperClusterPolicyList{})
	return err
}

// Patch applies the patch and returns the patched skupperClusterPolicy.
func (c *FakeSkupperClusterPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.SkupperClusterPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(skupperclusterpoliciesResource, name, pt, data, subresources...), &v1alpha1.SkupperClusterPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SkupperClusterPolicy), err
}
