/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SkupperClusterPolicyLister helps list SkupperClusterPolicies.
// All objects returned here must be treated as read-only.
type SkupperClusterPolicyLister interface {
	// List lists all SkupperClusterPolicies in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.SkupperClusterPolicy, err error)
	// Get retrieves the SkupperClusterPolicy from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.SkupperClusterPolicy, error)
	SkupperClusterPolicyListerExpansion
}

// skupperClusterPolicyLister implements the SkupperClusterPolicyLister interface.
type skupperClusterPolicyLister struct {
	indexer cache.Indexer
}

// NewSkupperClusterPolicyLister returns a new SkupperClusterPolicyLister.
func NewSkupperClusterPolicyLister(indexer cache.Indexer) SkupperClusterPolicyLister {
	return &skupperClusterPolicyLister{indexer: indexer}
}

// List lists all SkupperClusterPolicies in the indexer.
func (s *skupperClusterPolicyLister) List(selector labels.Selector) (ret []*v1alpha1.SkupperClusterPolicy, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SkupperClusterPolicy))
	})
	return ret, err
}

// Get retrieves the SkupperClusterPolicy from the index for a given name.
func (s *skupperClusterPolicyLister) Get(name string) (*v1alpha1.SkupperClusterPolicy, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("skupperclusterpolicy"), name)
	}
	return obj.(*v1alpha1.SkupperClusterPolicy), nil
}
