// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerStopReader is a Reader for the ContainerStop structure.
type ContainerStopReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerStopReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerStopNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 304:
		result := NewContainerStopNotModified()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerStopNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerStopInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerStopNoContent creates a ContainerStopNoContent with default headers values
func NewContainerStopNoContent() *ContainerStopNoContent {
	return &ContainerStopNoContent{}
}

/*
ContainerStopNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerStopNoContent struct {
}

// IsSuccess returns true when this container stop no content response has a 2xx status code
func (o *ContainerStopNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container stop no content response has a 3xx status code
func (o *ContainerStopNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stop no content response has a 4xx status code
func (o *ContainerStopNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container stop no content response has a 5xx status code
func (o *ContainerStopNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container stop no content response a status code equal to that given
func (o *ContainerStopNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerStopNoContent) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNoContent ", 204)
}

func (o *ContainerStopNoContent) String() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNoContent ", 204)
}

func (o *ContainerStopNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerStopNotModified creates a ContainerStopNotModified with default headers values
func NewContainerStopNotModified() *ContainerStopNotModified {
	return &ContainerStopNotModified{}
}

/*
ContainerStopNotModified describes a response with status code 304, with default header values.

Container already stopped
*/
type ContainerStopNotModified struct {
	Payload *ContainerStopNotModifiedBody
}

// IsSuccess returns true when this container stop not modified response has a 2xx status code
func (o *ContainerStopNotModified) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container stop not modified response has a 3xx status code
func (o *ContainerStopNotModified) IsRedirect() bool {
	return true
}

// IsClientError returns true when this container stop not modified response has a 4xx status code
func (o *ContainerStopNotModified) IsClientError() bool {
	return false
}

// IsServerError returns true when this container stop not modified response has a 5xx status code
func (o *ContainerStopNotModified) IsServerError() bool {
	return false
}

// IsCode returns true when this container stop not modified response a status code equal to that given
func (o *ContainerStopNotModified) IsCode(code int) bool {
	return code == 304
}

func (o *ContainerStopNotModified) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNotModified  %+v", 304, o.Payload)
}

func (o *ContainerStopNotModified) String() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNotModified  %+v", 304, o.Payload)
}

func (o *ContainerStopNotModified) GetPayload() *ContainerStopNotModifiedBody {
	return o.Payload
}

func (o *ContainerStopNotModified) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStopNotModifiedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerStopNotFound creates a ContainerStopNotFound with default headers values
func NewContainerStopNotFound() *ContainerStopNotFound {
	return &ContainerStopNotFound{}
}

/*
ContainerStopNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerStopNotFound struct {
	Payload *ContainerStopNotFoundBody
}

// IsSuccess returns true when this container stop not found response has a 2xx status code
func (o *ContainerStopNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container stop not found response has a 3xx status code
func (o *ContainerStopNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stop not found response has a 4xx status code
func (o *ContainerStopNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container stop not found response has a 5xx status code
func (o *ContainerStopNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container stop not found response a status code equal to that given
func (o *ContainerStopNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerStopNotFound) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStopNotFound) String() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStopNotFound) GetPayload() *ContainerStopNotFoundBody {
	return o.Payload
}

func (o *ContainerStopNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStopNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerStopInternalServerError creates a ContainerStopInternalServerError with default headers values
func NewContainerStopInternalServerError() *ContainerStopInternalServerError {
	return &ContainerStopInternalServerError{}
}

/*
ContainerStopInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerStopInternalServerError struct {
	Payload *ContainerStopInternalServerErrorBody
}

// IsSuccess returns true when this container stop internal server error response has a 2xx status code
func (o *ContainerStopInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container stop internal server error response has a 3xx status code
func (o *ContainerStopInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stop internal server error response has a 4xx status code
func (o *ContainerStopInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container stop internal server error response has a 5xx status code
func (o *ContainerStopInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container stop internal server error response a status code equal to that given
func (o *ContainerStopInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerStopInternalServerError) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStopInternalServerError) String() string {
	return fmt.Sprintf("[POST /containers/{name}/stop][%d] containerStopInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStopInternalServerError) GetPayload() *ContainerStopInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerStopInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStopInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerStopInternalServerErrorBody container stop internal server error body
swagger:model ContainerStopInternalServerErrorBody
*/
type ContainerStopInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container stop internal server error body
func (o *ContainerStopInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container stop internal server error body based on context it is used
func (o *ContainerStopInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStopInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStopInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerStopInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerStopNotFoundBody container stop not found body
swagger:model ContainerStopNotFoundBody
*/
type ContainerStopNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container stop not found body
func (o *ContainerStopNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container stop not found body based on context it is used
func (o *ContainerStopNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStopNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStopNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerStopNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerStopNotModifiedBody container stop not modified body
swagger:model ContainerStopNotModifiedBody
*/
type ContainerStopNotModifiedBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container stop not modified body
func (o *ContainerStopNotModifiedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container stop not modified body based on context it is used
func (o *ContainerStopNotModifiedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStopNotModifiedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStopNotModifiedBody) UnmarshalBinary(b []byte) error {
	var res ContainerStopNotModifiedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
