// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewImagePruneParams creates a new ImagePruneParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImagePruneParams() *ImagePruneParams {
	return &ImagePruneParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImagePruneParamsWithTimeout creates a new ImagePruneParams object
// with the ability to set a timeout on a request.
func NewImagePruneParamsWithTimeout(timeout time.Duration) *ImagePruneParams {
	return &ImagePruneParams{
		timeout: timeout,
	}
}

// NewImagePruneParamsWithContext creates a new ImagePruneParams object
// with the ability to set a context for a request.
func NewImagePruneParamsWithContext(ctx context.Context) *ImagePruneParams {
	return &ImagePruneParams{
		Context: ctx,
	}
}

// NewImagePruneParamsWithHTTPClient creates a new ImagePruneParams object
// with the ability to set a custom HTTPClient for a request.
func NewImagePruneParamsWithHTTPClient(client *http.Client) *ImagePruneParams {
	return &ImagePruneParams{
		HTTPClient: client,
	}
}

/*
ImagePruneParams contains all the parameters to send to the API endpoint

	for the image prune operation.

	Typically these are written to a http.Request.
*/
type ImagePruneParams struct {

	/* Filters.

	   filters to apply to image pruning, encoded as JSON (map[string][]string). Available filters:
	- `dangling=<boolean>` When set to `true` (or `1`), prune only
	   unused *and* untagged images. When set to `false`
	   (or `0`), all unused images are pruned.
	- `until=<string>` Prune images created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.
	- `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune images with (or without, in case `label!=...` is used) the specified labels.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image prune params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePruneParams) WithDefaults() *ImagePruneParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image prune params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePruneParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image prune params
func (o *ImagePruneParams) WithTimeout(timeout time.Duration) *ImagePruneParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image prune params
func (o *ImagePruneParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image prune params
func (o *ImagePruneParams) WithContext(ctx context.Context) *ImagePruneParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image prune params
func (o *ImagePruneParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image prune params
func (o *ImagePruneParams) WithHTTPClient(client *http.Client) *ImagePruneParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image prune params
func (o *ImagePruneParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the image prune params
func (o *ImagePruneParams) WithFilters(filters *string) *ImagePruneParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the image prune params
func (o *ImagePruneParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *ImagePruneParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
