/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// AccessGrantLister helps list AccessGrants.
// All objects returned here must be treated as read-only.
type AccessGrantLister interface {
	// List lists all AccessGrants in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.AccessGrant, err error)
	// AccessGrants returns an object that can list and get AccessGrants.
	AccessGrants(namespace string) AccessGrantNamespaceLister
	AccessGrantListerExpansion
}

// accessGrantLister implements the AccessGrantLister interface.
type accessGrantLister struct {
	listers.ResourceIndexer[*v2alpha1.AccessGrant]
}

// NewAccessGrantLister returns a new AccessGrantLister.
func NewAccessGrantLister(indexer cache.Indexer) AccessGrantLister {
	return &accessGrantLister{listers.New[*v2alpha1.AccessGrant](indexer, v2alpha1.Resource("accessgrant"))}
}

// AccessGrants returns an object that can list and get AccessGrants.
func (s *accessGrantLister) AccessGrants(namespace string) AccessGrantNamespaceLister {
	return accessGrantNamespaceLister{listers.NewNamespaced[*v2alpha1.AccessGrant](s.ResourceIndexer, namespace)}
}

// AccessGrantNamespaceLister helps list and get AccessGrants.
// All objects returned here must be treated as read-only.
type AccessGrantNamespaceLister interface {
	// List lists all AccessGrants in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.AccessGrant, err error)
	// Get retrieves the AccessGrant from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.AccessGrant, error)
	AccessGrantNamespaceListerExpansion
}

// accessGrantNamespaceLister implements the AccessGrantNamespaceLister
// interface.
type accessGrantNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.AccessGrant]
}
