package images

const (
	DefaultImageRegistry      string = "registry.redhat.io/service-interconnect"
	RouterImageName           string = "skupper-router-rhel9:3.2.0"
	ControllerImageName       string = "skupper-controller-rhel9:2.0.0"
	KubeAdaptorImageName      string = "skupper-kube-adaptor-rhel9:2.0.0"
	NetworkObserverImageName  string = "skupper-network-observer-rhel9:2.0.0"
	CliImageName              string = "skupper-cli-rhel9:2.0.0"
	PrometheusImageRegistry   string = "registry.redhat.io/openshift4"
	PrometheusServerImageName string = "ose-prometheus-rhel9:v4.16.0"
	OauthProxyImageRegistry   string = "registry.redhat.io/openshift4"
	OauthProxyImageName       string = "ose-oauth-proxy-rhel9:v4.16.0"
)

var (
	KubeComponents    = []string{"router", "controller", "network-observer", "cli", "prometheus", "origin-oauth-proxy"}
	NonKubeComponents = []string{"router", "network-observer", "cli", "prometheus", "origin-oauth-proxy"}
	DefaultComponents = []string{"router", "prometheus", "origin-oauth-proxy"}
)
