// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PodResourceConfig pod resource config
//
// swagger:model PodResourceConfig
type PodResourceConfig struct {

	// CPU period of the cpuset, determined by --cpus
	CPUPeriod uint64 `json:"cpu_period,omitempty"`

	// CPU quota of the cpuset, determined by --cpus
	CPUQuota int64 `json:"cpu_quota,omitempty"`

	// ThrottleReadBpsDevice contains the rate at which the devices in the pod can be read from/accessed
	ThrottleReadBpsDevice map[string]LinuxThrottleDevice `json:"throttleReadBpsDevice,omitempty"`

	// resource limits
	ResourceLimits *LinuxResources `json:"resource_limits,omitempty"`
}

// Validate validates this pod resource config
func (m *PodResourceConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateThrottleReadBpsDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourceLimits(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PodResourceConfig) validateThrottleReadBpsDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleReadBpsDevice) { // not required
		return nil
	}

	for k := range m.ThrottleReadBpsDevice {

		if err := validate.Required("throttleReadBpsDevice"+"."+k, "body", m.ThrottleReadBpsDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleReadBpsDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleReadBpsDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *PodResourceConfig) validateResourceLimits(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourceLimits) { // not required
		return nil
	}

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this pod resource config based on the context it is used
func (m *PodResourceConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateThrottleReadBpsDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResourceLimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PodResourceConfig) contextValidateThrottleReadBpsDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleReadBpsDevice {

		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *PodResourceConfig) contextValidateResourceLimits(ctx context.Context, formats strfmt.Registry) error {

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PodResourceConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PodResourceConfig) UnmarshalBinary(b []byte) error {
	var res PodResourceConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
