/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"

	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	scheme "github.com/skupperproject/skupper/pkg/generated/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// RouterAccessesGetter has a method to return a RouterAccessInterface.
// A group's client should implement this interface.
type RouterAccessesGetter interface {
	RouterAccesses(namespace string) RouterAccessInterface
}

// RouterAccessInterface has methods to work with RouterAccess resources.
type RouterAccessInterface interface {
	Create(ctx context.Context, routerAccess *v2alpha1.RouterAccess, opts v1.CreateOptions) (*v2alpha1.RouterAccess, error)
	Update(ctx context.Context, routerAccess *v2alpha1.RouterAccess, opts v1.UpdateOptions) (*v2alpha1.RouterAccess, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, routerAccess *v2alpha1.RouterAccess, opts v1.UpdateOptions) (*v2alpha1.RouterAccess, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.RouterAccess, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.RouterAccessList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.RouterAccess, err error)
	RouterAccessExpansion
}

// routerAccesses implements RouterAccessInterface
type routerAccesses struct {
	*gentype.ClientWithList[*v2alpha1.RouterAccess, *v2alpha1.RouterAccessList]
}

// newRouterAccesses returns a RouterAccesses
func newRouterAccesses(c *SkupperV2alpha1Client, namespace string) *routerAccesses {
	return &routerAccesses{
		gentype.NewClientWithList[*v2alpha1.RouterAccess, *v2alpha1.RouterAccessList](
			"routeraccesses",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v2alpha1.RouterAccess { return &v2alpha1.RouterAccess{} },
			func() *v2alpha1.RouterAccessList { return &v2alpha1.RouterAccessList{} }),
	}
}
