// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.3.0 DO NOT EDIT.
package api

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strings"

	"github.com/gorilla/mux"
	"github.com/oapi-codegen/runtime"
)

// Defines values for ProcessRecordRole.
const (
	External ProcessRecordRole = "external"
	Internal ProcessRecordRole = "internal"
	Remote   ProcessRecordRole = "remote"
)

// Defines values for FlowAggregatePairType.
const (
	PROCESS      FlowAggregatePairType = "PROCESS"
	PROCESSGROUP FlowAggregatePairType = "PROCESS_GROUP"
	SITE         FlowAggregatePairType = "SITE"
)

// Defines values for LinkRoleType.
const (
	LinkRoleTypeEdge        LinkRoleType = "edge"
	LinkRoleTypeInterRouter LinkRoleType = "inter-router"
	LinkRoleTypeUnknown     LinkRoleType = "unknown"
)

// Defines values for OperStatusType.
const (
	Down OperStatusType = "down"
	Up   OperStatusType = "up"
)

// Defines values for ProcessBindingType.
const (
	Bound   ProcessBindingType = "bound"
	Unbound ProcessBindingType = "unbound"
)

// Defines values for SitePlatformType.
const (
	SitePlatformTypeDocker     SitePlatformType = "docker"
	SitePlatformTypeKubernetes SitePlatformType = "kubernetes"
	SitePlatformTypeLinux      SitePlatformType = "linux"
	SitePlatformTypePodman     SitePlatformType = "podman"
	SitePlatformTypeUnknown    SitePlatformType = "unknown"
)

// ApplicationFlowRecord defines model for ApplicationFlowRecord.
type ApplicationFlowRecord struct {
	ConnectionId    string  `json:"connectionId"`
	DestProcessId   string  `json:"destProcessId"`
	DestProcessName string  `json:"destProcessName"`
	DestSiteId      string  `json:"destSiteId"`
	DestSiteName    string  `json:"destSiteName"`
	Duration        *uint64 `json:"duration"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity          string `json:"identity"`
	Method            string `json:"method"`
	OctetCount        uint64 `json:"octetCount"`
	OctetReverseCount uint64 `json:"octetReverseCount"`
	Protocol          string `json:"protocol"`
	RoutingKey        string `json:"routingKey"`
	SourceProcessId   string `json:"sourceProcessId"`
	SourceProcessName string `json:"sourceProcessName"`
	SourceSiteId      string `json:"sourceSiteId"`
	SourceSiteName    string `json:"sourceSiteName"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
	Status    string `json:"status"`

	// TraceRouters Ordered array of the names of routers involved in proxying the connection
	TraceRouters []string `json:"traceRouters"`

	// TraceSites Ordered array of the names of sites involved in proxying the connection
	TraceSites []string `json:"traceSites"`
}

// ApplicationFlowResponse defines model for ApplicationFlowResponse.
type ApplicationFlowResponse struct {
	// Count number of results in response
	Count   int64                   `json:"count"`
	Results []ApplicationFlowRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ComponentListResponse defines model for ComponentListResponse.
type ComponentListResponse struct {
	// Count number of results in response
	Count   int64             `json:"count"`
	Results []ComponentRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ComponentRecord defines model for ComponentRecord.
type ComponentRecord struct {
	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity     string `json:"identity"`
	Name         string `json:"name"`
	ProcessCount int    `json:"processCount"`
	Role         string `json:"role"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// ComponentResponse defines model for ComponentResponse.
type ComponentResponse struct {
	Results ComponentRecord `json:"results"`
}

// ConnectionListResponse defines model for ConnectionListResponse.
type ConnectionListResponse struct {
	// Count number of results in response
	Count   int64              `json:"count"`
	Results []ConnectionRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ConnectionRecord defines model for ConnectionRecord.
type ConnectionRecord struct {
	ComponentPairId *string `json:"componentPairId"`
	ConnectorError  *string `json:"connectorError"`
	ConnectorId     string  `json:"connectorId"`
	DestHost        string  `json:"destHost"`
	DestPort        string  `json:"destPort"`
	DestProcessId   string  `json:"destProcessId"`
	DestProcessName string  `json:"destProcessName"`
	DestSiteId      string  `json:"destSiteId"`
	DestSiteName    string  `json:"destSiteName"`
	Duration        *uint64 `json:"duration"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity          string  `json:"identity"`
	Latency           uint64  `json:"latency"`
	LatencyReverse    uint64  `json:"latencyReverse"`
	ListenerError     *string `json:"listenerError"`
	ListenerId        string  `json:"listenerId"`
	OctetCount        uint64  `json:"octetCount"`
	OctetReverseCount uint64  `json:"octetReverseCount"`
	ProcessPairId     *string `json:"processPairId"`
	Protocol          string  `json:"protocol"`
	ProxyHost         string  `json:"proxyHost"`
	ProxyPort         string  `json:"proxyPort"`
	RoutingKey        string  `json:"routingKey"`
	SitePairId        *string `json:"sitePairId"`
	SourceHost        string  `json:"sourceHost"`
	SourcePort        string  `json:"sourcePort"`
	SourceProcessId   string  `json:"sourceProcessId"`
	SourceProcessName string  `json:"sourceProcessName"`
	SourceSiteId      string  `json:"sourceSiteId"`
	SourceSiteName    string  `json:"sourceSiteName"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`

	// TraceRouters Ordered array of the names of routers involved in proxying the connection
	TraceRouters []string `json:"traceRouters"`

	// TraceSites Ordered array of the names of sites involved in proxying the connection
	TraceSites []string `json:"traceSites"`
}

// ConnectorListResponse defines model for ConnectorListResponse.
type ConnectorListResponse struct {
	// Count number of results in response
	Count   int64             `json:"count"`
	Results []ConnectorRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ConnectorRecord defines model for ConnectorRecord.
type ConnectorRecord struct {
	DestHost string `json:"destHost"`
	DestPort string `json:"destPort"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity   string  `json:"identity"`
	Name       string  `json:"name"`
	ProcessId  string  `json:"processId"`
	Protocol   string  `json:"protocol"`
	RouterId   string  `json:"routerId"`
	RoutingKey string  `json:"routingKey"`
	ServiceId  *string `json:"serviceId,omitempty"`
	SiteId     string  `json:"siteId"`
	SiteName   string  `json:"siteName"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64  `json:"startTime"`
	Target    *string `json:"target"`
}

// ConnectorResponse defines model for ConnectorResponse.
type ConnectorResponse struct {
	Results ConnectorRecord `json:"results"`
}

// ErrorResponse defines model for ErrorResponse.
type ErrorResponse struct {
	Code    string `json:"code"`
	Message string `json:"message"`
}

// FlowAggregateListResponse defines model for FlowAggregateListResponse.
type FlowAggregateListResponse struct {
	// Count number of results in response
	Count   int64                 `json:"count"`
	Results []FlowAggregateRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// FlowAggregateRecord defines model for FlowAggregateRecord.
type FlowAggregateRecord struct {
	DestinationId       string  `json:"destinationId"`
	DestinationName     string  `json:"destinationName"`
	DestinationSiteId   *string `json:"destinationSiteId,omitempty"`
	DestinationSiteName *string `json:"destinationSiteName,omitempty"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity       string                `json:"identity"`
	PairType       FlowAggregatePairType `json:"pairType"`
	Protocol       string                `json:"protocol"`
	RecordCount    uint64                `json:"recordCount"`
	SourceId       string                `json:"sourceId"`
	SourceName     string                `json:"sourceName"`
	SourceSiteId   *string               `json:"sourceSiteId,omitempty"`
	SourceSiteName *string               `json:"sourceSiteName,omitempty"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// FlowAggregateResponse defines model for FlowAggregateResponse.
type FlowAggregateResponse struct {
	Results FlowAggregateRecord `json:"results"`
}

// ListenerListResponse defines model for ListenerListResponse.
type ListenerListResponse struct {
	// Count number of results in response
	Count   int64            `json:"count"`
	Results []ListenerRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ListenerRecord defines model for ListenerRecord.
type ListenerRecord struct {
	DestHost string `json:"destHost"`
	DestPort string `json:"destPort"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity   string  `json:"identity"`
	Name       string  `json:"name"`
	Protocol   string  `json:"protocol"`
	RouterId   string  `json:"routerId"`
	RoutingKey string  `json:"routingKey"`
	ServiceId  *string `json:"serviceId,omitempty"`
	SiteId     string  `json:"siteId"`
	SiteName   string  `json:"siteName"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// ListenerResponse defines model for ListenerResponse.
type ListenerResponse struct {
	Results ListenerRecord `json:"results"`
}

// ProcessListResponse defines model for ProcessListResponse.
type ProcessListResponse struct {
	// Count number of results in response
	Count   int64           `json:"count"`
	Results []ProcessRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ProcessRecord defines model for ProcessRecord.
type ProcessRecord struct {
	// Binding Indicates whether a process is exposed or not in a skupper network
	Binding ProcessBindingType `json:"binding"`

	// ComponentId Id of the component associated to the process.
	ComponentId   string `json:"componentId"`
	ComponentName string `json:"componentName"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// HostName The IP address of the pod within the Kubernetes cluster
	HostName *string `json:"hostName"`

	// Identity The unique identifier for the record.
	Identity  string  `json:"identity"`
	ImageName *string `json:"imageName"`
	Name      string  `json:"name"`

	// Role Internal processes are processes related to Skupper. Remote processes are processes indirectly connected, such as a proxy
	Role     ProcessRecordRole        `json:"role"`
	Services *[]ServiceIdentifierType `json:"services"`

	// SiteId Id of the site associated to the process.
	SiteId   string `json:"siteId"`
	SiteName string `json:"siteName"`

	// SourceHost The IP address of the node where the pod is running
	SourceHost string `json:"sourceHost"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// ProcessRecordRole Internal processes are processes related to Skupper. Remote processes are processes indirectly connected, such as a proxy
type ProcessRecordRole string

// ProcessResponse defines model for ProcessResponse.
type ProcessResponse struct {
	Results ProcessRecord `json:"results"`
}

// RouterAccessListResponse defines model for RouterAccessListResponse.
type RouterAccessListResponse struct {
	// Count number of results in response
	Count   int64                `json:"count"`
	Results []RouterAccessRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// RouterAccessRecord defines model for RouterAccessRecord.
type RouterAccessRecord struct {
	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity  string `json:"identity"`
	LinkCount uint64 `json:"linkCount"`
	Name      string `json:"name"`
	Role      string `json:"role"`
	RouterId  string `json:"routerId"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// RouterAccessResponse defines model for RouterAccessResponse.
type RouterAccessResponse struct {
	Results RouterAccessRecord `json:"results"`
}

// RouterLinkListResponse defines model for RouterLinkListResponse.
type RouterLinkListResponse struct {
	// Count number of results in response
	Count   int64              `json:"count"`
	Results []RouterLinkRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// RouterLinkRecord defines model for RouterLinkRecord.
type RouterLinkRecord struct {
	// Cost When connected, cost will be set to the link cost attribute
	Cost *uint64 `json:"cost"`

	// DestinationRouterId When connected, the identity of the destitation (peer) router.
	DestinationRouterId *string `json:"destinationRouterId"`

	// DestinationRouterName When connected, the name of the destitation (peer) router.
	DestinationRouterName *string `json:"destinationRouterName"`

	// DestinationSiteId When connected, the identity of the destitation (peer) site.
	DestinationSiteId *string `json:"destinationSiteId"`

	// DestinationSiteName When connected, the name of the destitation (peer) site.
	DestinationSiteName *string `json:"destinationSiteName"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity          string `json:"identity"`
	Name              string `json:"name"`
	OctetCount        uint64 `json:"octetCount"`
	OctetReverseCount uint64 `json:"octetReverseCount"`

	// Role The class of skupper link
	Role LinkRoleType `json:"role"`

	// RouterAccessId When connected, the identity of the destitation (peer) router access.
	RouterAccessId *string `json:"routerAccessId"`
	RouterId       string  `json:"routerId"`
	RouterName     string  `json:"routerName"`
	SourceSiteId   string  `json:"sourceSiteId"`
	SourceSiteName string  `json:"sourceSiteName"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64         `json:"startTime"`
	Status    OperStatusType `json:"status"`
}

// RouterLinkResponse defines model for RouterLinkResponse.
type RouterLinkResponse struct {
	Results RouterLinkRecord `json:"results"`
}

// RouterListResponse defines model for RouterListResponse.
type RouterListResponse struct {
	// Count number of results in response
	Count   int64          `json:"count"`
	Results []RouterRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// RouterRecord defines model for RouterRecord.
type RouterRecord struct {
	BuildVersion string `json:"buildVersion"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime  uint64 `json:"endTime"`
	HostName string `json:"hostName"`

	// Identity The unique identifier for the record.
	Identity     string  `json:"identity"`
	ImageName    string  `json:"imageName"`
	ImageVersion string  `json:"imageVersion"`
	Mode         string  `json:"mode"`
	Name         string  `json:"name"`
	Namespace    *string `json:"namespace,omitempty"`
	SiteId       string  `json:"siteId"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// RouterResponse defines model for RouterResponse.
type RouterResponse struct {
	Results RouterRecord `json:"results"`
}

// ServiceListResponse defines model for ServiceListResponse.
type ServiceListResponse struct {
	// Count number of results in response
	Count   int64           `json:"count"`
	Results []ServiceRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// ServiceRecord defines model for ServiceRecord.
type ServiceRecord struct {
	ConnectorCount int `json:"connectorCount"`

	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// HasListener true when there is at least one listener for this routingKey
	HasListener bool `json:"hasListener"`

	// Identity The unique identifier for the record.
	Identity string `json:"identity"`

	// IsBound true when there are both listeners and connectors configured
	IsBound       bool   `json:"isBound"`
	ListenerCount int    `json:"listenerCount"`
	Name          string `json:"name"`

	// ObservedApplicationProtocols Array of the observed application level protocols
	ObservedApplicationProtocols []string `json:"observedApplicationProtocols"`
	Protocol                     string   `json:"protocol"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// ServiceResponse defines model for ServiceResponse.
type ServiceResponse struct {
	Results ServiceRecord `json:"results"`
}

// SiteListResponse defines model for SiteListResponse.
type SiteListResponse struct {
	// Count number of results in response
	Count   int64        `json:"count"`
	Results []SiteRecord `json:"results"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// SiteRecord defines model for SiteRecord.
type SiteRecord struct {
	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity  string  `json:"identity"`
	Name      string  `json:"name"`
	Namespace *string `json:"namespace"`

	// Platform The platform used for the site.
	Platform SitePlatformType `json:"platform"`

	// Provider Possible values are 'AWS', 'IBM', 'Azure' ecc. Can be any string or 'unknown'
	Provider    string `json:"provider"`
	RouterCount int    `json:"routerCount"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`

	// Version The current skupper version installed. Can be any string or 'unknown'
	Version string `json:"version"`
}

// SiteResponse defines model for SiteResponse.
type SiteResponse struct {
	Results SiteRecord `json:"results"`
}

// BaseRecord defines model for baseRecord.
type BaseRecord struct {
	// EndTime The end time in microseconds of the record in Unix timestamp format.
	EndTime uint64 `json:"endTime"`

	// Identity The unique identifier for the record.
	Identity string `json:"identity"`

	// StartTime The creation time in microseconds of the record in Unix timestamp format. The value 0 means that the record is not terminated
	StartTime uint64 `json:"startTime"`
}

// CollectionResponse defines model for collectionResponse.
type CollectionResponse struct {
	// Count number of results in response
	Count int64 `json:"count"`

	// TimeRangeCount number of results matching filtering and time range constraints before any limit or offset is applied.
	TimeRangeCount int64 `json:"timeRangeCount"`
}

// FlowAggregatePairType defines model for flowAggregatePairType.
type FlowAggregatePairType string

// LinkRoleType The class of skupper link
type LinkRoleType string

// OperStatusType defines model for operStatusType.
type OperStatusType string

// ProcessBindingType Indicates whether a process is exposed or not in a skupper network
type ProcessBindingType string

// ServiceIdentifierType a special string for identifying services uses the form `name@identity@protocol`
type ServiceIdentifierType = AtmarkDelimitedString

// SitePlatformType The platform used for the site.
type SitePlatformType string

// PathID defines model for pathID.
type PathID = string

// ErrorBadRequest defines model for errorBadRequest.
type ErrorBadRequest = ErrorResponse

// ErrorNotFound defines model for errorNotFound.
type ErrorNotFound = ErrorResponse

// GetApplicationFlows defines model for getApplicationFlows.
type GetApplicationFlows = ApplicationFlowResponse

// GetComponentByID defines model for getComponentByID.
type GetComponentByID = ComponentResponse

// GetComponents defines model for getComponents.
type GetComponents = ComponentListResponse

// GetConnections defines model for getConnections.
type GetConnections = ConnectionListResponse

// GetConnectorByID defines model for getConnectorByID.
type GetConnectorByID = ConnectorResponse

// GetConnectors defines model for getConnectors.
type GetConnectors = ConnectorListResponse

// GetFlowAggregateByID defines model for getFlowAggregateByID.
type GetFlowAggregateByID = FlowAggregateResponse

// GetFlowAggregates defines model for getFlowAggregates.
type GetFlowAggregates = FlowAggregateListResponse

// GetListenerByID defines model for getListenerByID.
type GetListenerByID = ListenerResponse

// GetListeners defines model for getListeners.
type GetListeners = ListenerListResponse

// GetProcessByID defines model for getProcessByID.
type GetProcessByID = ProcessResponse

// GetProcesses defines model for getProcesses.
type GetProcesses = ProcessListResponse

// GetRouterAccess defines model for getRouterAccess.
type GetRouterAccess = RouterAccessListResponse

// GetRouterAccessByID defines model for getRouterAccessByID.
type GetRouterAccessByID = RouterAccessResponse

// GetRouterByID defines model for getRouterByID.
type GetRouterByID = RouterResponse

// GetRouterLinkByID defines model for getRouterLinkByID.
type GetRouterLinkByID = RouterLinkResponse

// GetRouterLinks defines model for getRouterLinks.
type GetRouterLinks = RouterLinkListResponse

// GetRouters defines model for getRouters.
type GetRouters = RouterListResponse

// GetServiceByID defines model for getServiceByID.
type GetServiceByID = ServiceResponse

// GetServices defines model for getServices.
type GetServices = ServiceListResponse

// GetSiteByID defines model for getSiteByID.
type GetSiteByID = SiteResponse

// GetSites defines model for getSites.
type GetSites = SiteListResponse

// NotSupported defines model for notSupported.
type NotSupported = ErrorResponse

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A list of callbacks for modifying requests which are generated before sending over
	// the network.
	RequestEditors []RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditors = append(c.RequestEditors, fn)
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// Applicationflows request
	Applicationflows(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Componentpairs request
	Componentpairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ComponentpairByID request
	ComponentpairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Components request
	Components(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ComponentByID request
	ComponentByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Connections request
	Connections(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Connectors request
	Connectors(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ConnectorByID request
	ConnectorByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Hosts request
	Hosts(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// HostsByID request
	HostsByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Listeners request
	Listeners(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListenerByID request
	ListenerByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Processes request
	Processes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ProcessById request
	ProcessById(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Processpairs request
	Processpairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ProcesspairByID request
	ProcesspairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Routeraccess request
	Routeraccess(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RouteraccessByID request
	RouteraccessByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Routerlinks request
	Routerlinks(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RouterlinkByID request
	RouterlinkByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Routers request
	Routers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RouterByID request
	RouterByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Services request
	Services(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ServiceByID request
	ServiceByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ConnectionsByService request
	ConnectionsByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ProcessesByService request
	ProcessesByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ProcessPairsByService request
	ProcessPairsByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Sitepairs request
	Sitepairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// SitepairByID request
	SitepairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Sites request
	Sites(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// SiteById request
	SiteById(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// HostsBySite request
	HostsBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ProcessesBySite request
	ProcessesBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RoutersBySite request
	RoutersBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error)
}

func (c *Client) Applicationflows(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewApplicationflowsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Componentpairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewComponentpairsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ComponentpairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewComponentpairByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Components(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewComponentsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ComponentByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewComponentByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Connections(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewConnectionsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Connectors(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewConnectorsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ConnectorByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewConnectorByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Hosts(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewHostsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) HostsByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewHostsByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Listeners(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListenersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListenerByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListenerByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Processes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcessesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ProcessById(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcessByIdRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Processpairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcesspairsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ProcesspairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcesspairByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Routeraccess(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRouteraccessRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RouteraccessByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRouteraccessByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Routerlinks(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRouterlinksRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RouterlinkByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRouterlinkByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Routers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRoutersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RouterByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRouterByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Services(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewServicesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ServiceByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewServiceByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ConnectionsByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewConnectionsByServiceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ProcessesByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcessesByServiceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ProcessPairsByService(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcessPairsByServiceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Sitepairs(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewSitepairsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) SitepairByID(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewSitepairByIDRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Sites(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewSitesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) SiteById(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewSiteByIdRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) HostsBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewHostsBySiteRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ProcessesBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewProcessesBySiteRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RoutersBySite(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRoutersBySiteRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

// NewApplicationflowsRequest generates requests for Applicationflows
func NewApplicationflowsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/applicationflows")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewComponentpairsRequest generates requests for Componentpairs
func NewComponentpairsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/componentpairs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewComponentpairByIDRequest generates requests for ComponentpairByID
func NewComponentpairByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/componentpairs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewComponentsRequest generates requests for Components
func NewComponentsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/components")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewComponentByIDRequest generates requests for ComponentByID
func NewComponentByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/components/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewConnectionsRequest generates requests for Connections
func NewConnectionsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/connections")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewConnectorsRequest generates requests for Connectors
func NewConnectorsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/connectors")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewConnectorByIDRequest generates requests for ConnectorByID
func NewConnectorByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/connectors/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewHostsRequest generates requests for Hosts
func NewHostsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/hosts")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewHostsByIDRequest generates requests for HostsByID
func NewHostsByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/hosts/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListenersRequest generates requests for Listeners
func NewListenersRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/listeners")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListenerByIDRequest generates requests for ListenerByID
func NewListenerByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/listeners/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcessesRequest generates requests for Processes
func NewProcessesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/processes")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcessByIdRequest generates requests for ProcessById
func NewProcessByIdRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/processes/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcesspairsRequest generates requests for Processpairs
func NewProcesspairsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/processpairs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcesspairByIDRequest generates requests for ProcesspairByID
func NewProcesspairByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/processpairs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRouteraccessRequest generates requests for Routeraccess
func NewRouteraccessRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routeraccess")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRouteraccessByIDRequest generates requests for RouteraccessByID
func NewRouteraccessByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routeraccess/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRouterlinksRequest generates requests for Routerlinks
func NewRouterlinksRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routerlinks")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRouterlinkByIDRequest generates requests for RouterlinkByID
func NewRouterlinkByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routerlinks/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRoutersRequest generates requests for Routers
func NewRoutersRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routers")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRouterByIDRequest generates requests for RouterByID
func NewRouterByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/routers/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewServicesRequest generates requests for Services
func NewServicesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/services")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewServiceByIDRequest generates requests for ServiceByID
func NewServiceByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/services/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewConnectionsByServiceRequest generates requests for ConnectionsByService
func NewConnectionsByServiceRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/services/%s/connections", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcessesByServiceRequest generates requests for ProcessesByService
func NewProcessesByServiceRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/services/%s/processes", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcessPairsByServiceRequest generates requests for ProcessPairsByService
func NewProcessPairsByServiceRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/services/%s/processpairs", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewSitepairsRequest generates requests for Sitepairs
func NewSitepairsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sitepairs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewSitepairByIDRequest generates requests for SitepairByID
func NewSitepairByIDRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sitepairs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewSitesRequest generates requests for Sites
func NewSitesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sites")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewSiteByIdRequest generates requests for SiteById
func NewSiteByIdRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sites/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewHostsBySiteRequest generates requests for HostsBySite
func NewHostsBySiteRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sites/%s/hosts", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewProcessesBySiteRequest generates requests for ProcessesBySite
func NewProcessesBySiteRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sites/%s/processes", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRoutersBySiteRequest generates requests for RoutersBySite
func NewRoutersBySiteRequest(server string, id PathID) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api/v2alpha1/sites/%s/routers", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

func (c *Client) applyEditors(ctx context.Context, req *http.Request, additionalEditors []RequestEditorFn) error {
	for _, r := range c.RequestEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	for _, r := range additionalEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	return nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// ApplicationflowsWithResponse request
	ApplicationflowsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ApplicationflowsResponse, error)

	// ComponentpairsWithResponse request
	ComponentpairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ComponentpairsResponse, error)

	// ComponentpairByIDWithResponse request
	ComponentpairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ComponentpairByIDResponse, error)

	// ComponentsWithResponse request
	ComponentsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ComponentsResponse, error)

	// ComponentByIDWithResponse request
	ComponentByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ComponentByIDResponse, error)

	// ConnectionsWithResponse request
	ConnectionsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ConnectionsResponse, error)

	// ConnectorsWithResponse request
	ConnectorsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ConnectorsResponse, error)

	// ConnectorByIDWithResponse request
	ConnectorByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ConnectorByIDResponse, error)

	// HostsWithResponse request
	HostsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*HostsResponse, error)

	// HostsByIDWithResponse request
	HostsByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*HostsByIDResponse, error)

	// ListenersWithResponse request
	ListenersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListenersResponse, error)

	// ListenerByIDWithResponse request
	ListenerByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ListenerByIDResponse, error)

	// ProcessesWithResponse request
	ProcessesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ProcessesResponse, error)

	// ProcessByIdWithResponse request
	ProcessByIdWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessByIdResponse, error)

	// ProcesspairsWithResponse request
	ProcesspairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ProcesspairsResponse, error)

	// ProcesspairByIDWithResponse request
	ProcesspairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcesspairByIDResponse, error)

	// RouteraccessWithResponse request
	RouteraccessWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RouteraccessResponse, error)

	// RouteraccessByIDWithResponse request
	RouteraccessByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouteraccessByIDResponse, error)

	// RouterlinksWithResponse request
	RouterlinksWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RouterlinksResponse, error)

	// RouterlinkByIDWithResponse request
	RouterlinkByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouterlinkByIDResponse, error)

	// RoutersWithResponse request
	RoutersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RoutersResponse, error)

	// RouterByIDWithResponse request
	RouterByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouterByIDResponse, error)

	// ServicesWithResponse request
	ServicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ServicesResponse, error)

	// ServiceByIDWithResponse request
	ServiceByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ServiceByIDResponse, error)

	// ConnectionsByServiceWithResponse request
	ConnectionsByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ConnectionsByServiceResponse, error)

	// ProcessesByServiceWithResponse request
	ProcessesByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessesByServiceResponse, error)

	// ProcessPairsByServiceWithResponse request
	ProcessPairsByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessPairsByServiceResponse, error)

	// SitepairsWithResponse request
	SitepairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*SitepairsResponse, error)

	// SitepairByIDWithResponse request
	SitepairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*SitepairByIDResponse, error)

	// SitesWithResponse request
	SitesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*SitesResponse, error)

	// SiteByIdWithResponse request
	SiteByIdWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*SiteByIdResponse, error)

	// HostsBySiteWithResponse request
	HostsBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*HostsBySiteResponse, error)

	// ProcessesBySiteWithResponse request
	ProcessesBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessesBySiteResponse, error)

	// RoutersBySiteWithResponse request
	RoutersBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RoutersBySiteResponse, error)
}

type ApplicationflowsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetApplicationFlows
}

// Status returns HTTPResponse.Status
func (r ApplicationflowsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ApplicationflowsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ComponentpairsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregates
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ComponentpairsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ComponentpairsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ComponentpairByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregateByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ComponentpairByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ComponentpairByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ComponentsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetComponents
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ComponentsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ComponentsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ComponentByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetComponentByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ComponentByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ComponentByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ConnectionsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetConnections
}

// Status returns HTTPResponse.Status
func (r ConnectionsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ConnectionsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ConnectorsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetConnectors
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ConnectorsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ConnectorsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ConnectorByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetConnectorByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ConnectorByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ConnectorByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type HostsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON410      *NotSupported
}

// Status returns HTTPResponse.Status
func (r HostsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r HostsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type HostsByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotSupported
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r HostsByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r HostsByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListenersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetListeners
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ListenersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListenersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListenerByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetListenerByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ListenerByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListenerByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcessesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetProcesses
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ProcessesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcessesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcessByIdResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetProcessByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ProcessByIdResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcessByIdResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcesspairsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregates
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ProcesspairsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcesspairsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcesspairByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregateByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ProcesspairByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcesspairByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RouteraccessResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouterAccess
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r RouteraccessResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RouteraccessResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RouteraccessByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouterAccessByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r RouteraccessByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RouteraccessByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RouterlinksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouterLinks
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r RouterlinksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RouterlinksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RouterlinkByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouterLinkByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r RouterlinkByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RouterlinkByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RoutersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouters
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r RoutersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RoutersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RouterByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouterByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r RouterByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RouterByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ServicesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetServices
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ServicesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ServicesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ServiceByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetServiceByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ServiceByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ServiceByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ConnectionsByServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetConnections
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ConnectionsByServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ConnectionsByServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcessesByServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetProcesses
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r ProcessesByServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcessesByServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcessPairsByServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregates
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ProcessPairsByServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcessPairsByServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type SitepairsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregates
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r SitepairsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r SitepairsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type SitepairByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetFlowAggregateByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r SitepairByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r SitepairByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type SitesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetSites
	JSON400      *ErrorBadRequest
}

// Status returns HTTPResponse.Status
func (r SitesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r SitesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type SiteByIdResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetSiteByID
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r SiteByIdResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r SiteByIdResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type HostsBySiteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON410      *NotSupported
}

// Status returns HTTPResponse.Status
func (r HostsBySiteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r HostsBySiteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ProcessesBySiteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetProcesses
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r ProcessesBySiteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ProcessesBySiteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RoutersBySiteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *GetRouters
	JSON404      *ErrorNotFound
}

// Status returns HTTPResponse.Status
func (r RoutersBySiteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RoutersBySiteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ApplicationflowsWithResponse request returning *ApplicationflowsResponse
func (c *ClientWithResponses) ApplicationflowsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ApplicationflowsResponse, error) {
	rsp, err := c.Applicationflows(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseApplicationflowsResponse(rsp)
}

// ComponentpairsWithResponse request returning *ComponentpairsResponse
func (c *ClientWithResponses) ComponentpairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ComponentpairsResponse, error) {
	rsp, err := c.Componentpairs(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseComponentpairsResponse(rsp)
}

// ComponentpairByIDWithResponse request returning *ComponentpairByIDResponse
func (c *ClientWithResponses) ComponentpairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ComponentpairByIDResponse, error) {
	rsp, err := c.ComponentpairByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseComponentpairByIDResponse(rsp)
}

// ComponentsWithResponse request returning *ComponentsResponse
func (c *ClientWithResponses) ComponentsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ComponentsResponse, error) {
	rsp, err := c.Components(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseComponentsResponse(rsp)
}

// ComponentByIDWithResponse request returning *ComponentByIDResponse
func (c *ClientWithResponses) ComponentByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ComponentByIDResponse, error) {
	rsp, err := c.ComponentByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseComponentByIDResponse(rsp)
}

// ConnectionsWithResponse request returning *ConnectionsResponse
func (c *ClientWithResponses) ConnectionsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ConnectionsResponse, error) {
	rsp, err := c.Connections(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseConnectionsResponse(rsp)
}

// ConnectorsWithResponse request returning *ConnectorsResponse
func (c *ClientWithResponses) ConnectorsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ConnectorsResponse, error) {
	rsp, err := c.Connectors(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseConnectorsResponse(rsp)
}

// ConnectorByIDWithResponse request returning *ConnectorByIDResponse
func (c *ClientWithResponses) ConnectorByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ConnectorByIDResponse, error) {
	rsp, err := c.ConnectorByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseConnectorByIDResponse(rsp)
}

// HostsWithResponse request returning *HostsResponse
func (c *ClientWithResponses) HostsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*HostsResponse, error) {
	rsp, err := c.Hosts(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseHostsResponse(rsp)
}

// HostsByIDWithResponse request returning *HostsByIDResponse
func (c *ClientWithResponses) HostsByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*HostsByIDResponse, error) {
	rsp, err := c.HostsByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseHostsByIDResponse(rsp)
}

// ListenersWithResponse request returning *ListenersResponse
func (c *ClientWithResponses) ListenersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListenersResponse, error) {
	rsp, err := c.Listeners(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListenersResponse(rsp)
}

// ListenerByIDWithResponse request returning *ListenerByIDResponse
func (c *ClientWithResponses) ListenerByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ListenerByIDResponse, error) {
	rsp, err := c.ListenerByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListenerByIDResponse(rsp)
}

// ProcessesWithResponse request returning *ProcessesResponse
func (c *ClientWithResponses) ProcessesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ProcessesResponse, error) {
	rsp, err := c.Processes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcessesResponse(rsp)
}

// ProcessByIdWithResponse request returning *ProcessByIdResponse
func (c *ClientWithResponses) ProcessByIdWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessByIdResponse, error) {
	rsp, err := c.ProcessById(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcessByIdResponse(rsp)
}

// ProcesspairsWithResponse request returning *ProcesspairsResponse
func (c *ClientWithResponses) ProcesspairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ProcesspairsResponse, error) {
	rsp, err := c.Processpairs(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcesspairsResponse(rsp)
}

// ProcesspairByIDWithResponse request returning *ProcesspairByIDResponse
func (c *ClientWithResponses) ProcesspairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcesspairByIDResponse, error) {
	rsp, err := c.ProcesspairByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcesspairByIDResponse(rsp)
}

// RouteraccessWithResponse request returning *RouteraccessResponse
func (c *ClientWithResponses) RouteraccessWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RouteraccessResponse, error) {
	rsp, err := c.Routeraccess(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRouteraccessResponse(rsp)
}

// RouteraccessByIDWithResponse request returning *RouteraccessByIDResponse
func (c *ClientWithResponses) RouteraccessByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouteraccessByIDResponse, error) {
	rsp, err := c.RouteraccessByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRouteraccessByIDResponse(rsp)
}

// RouterlinksWithResponse request returning *RouterlinksResponse
func (c *ClientWithResponses) RouterlinksWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RouterlinksResponse, error) {
	rsp, err := c.Routerlinks(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRouterlinksResponse(rsp)
}

// RouterlinkByIDWithResponse request returning *RouterlinkByIDResponse
func (c *ClientWithResponses) RouterlinkByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouterlinkByIDResponse, error) {
	rsp, err := c.RouterlinkByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRouterlinkByIDResponse(rsp)
}

// RoutersWithResponse request returning *RoutersResponse
func (c *ClientWithResponses) RoutersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*RoutersResponse, error) {
	rsp, err := c.Routers(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRoutersResponse(rsp)
}

// RouterByIDWithResponse request returning *RouterByIDResponse
func (c *ClientWithResponses) RouterByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RouterByIDResponse, error) {
	rsp, err := c.RouterByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRouterByIDResponse(rsp)
}

// ServicesWithResponse request returning *ServicesResponse
func (c *ClientWithResponses) ServicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ServicesResponse, error) {
	rsp, err := c.Services(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseServicesResponse(rsp)
}

// ServiceByIDWithResponse request returning *ServiceByIDResponse
func (c *ClientWithResponses) ServiceByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ServiceByIDResponse, error) {
	rsp, err := c.ServiceByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseServiceByIDResponse(rsp)
}

// ConnectionsByServiceWithResponse request returning *ConnectionsByServiceResponse
func (c *ClientWithResponses) ConnectionsByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ConnectionsByServiceResponse, error) {
	rsp, err := c.ConnectionsByService(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseConnectionsByServiceResponse(rsp)
}

// ProcessesByServiceWithResponse request returning *ProcessesByServiceResponse
func (c *ClientWithResponses) ProcessesByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessesByServiceResponse, error) {
	rsp, err := c.ProcessesByService(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcessesByServiceResponse(rsp)
}

// ProcessPairsByServiceWithResponse request returning *ProcessPairsByServiceResponse
func (c *ClientWithResponses) ProcessPairsByServiceWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessPairsByServiceResponse, error) {
	rsp, err := c.ProcessPairsByService(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcessPairsByServiceResponse(rsp)
}

// SitepairsWithResponse request returning *SitepairsResponse
func (c *ClientWithResponses) SitepairsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*SitepairsResponse, error) {
	rsp, err := c.Sitepairs(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseSitepairsResponse(rsp)
}

// SitepairByIDWithResponse request returning *SitepairByIDResponse
func (c *ClientWithResponses) SitepairByIDWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*SitepairByIDResponse, error) {
	rsp, err := c.SitepairByID(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseSitepairByIDResponse(rsp)
}

// SitesWithResponse request returning *SitesResponse
func (c *ClientWithResponses) SitesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*SitesResponse, error) {
	rsp, err := c.Sites(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseSitesResponse(rsp)
}

// SiteByIdWithResponse request returning *SiteByIdResponse
func (c *ClientWithResponses) SiteByIdWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*SiteByIdResponse, error) {
	rsp, err := c.SiteById(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseSiteByIdResponse(rsp)
}

// HostsBySiteWithResponse request returning *HostsBySiteResponse
func (c *ClientWithResponses) HostsBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*HostsBySiteResponse, error) {
	rsp, err := c.HostsBySite(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseHostsBySiteResponse(rsp)
}

// ProcessesBySiteWithResponse request returning *ProcessesBySiteResponse
func (c *ClientWithResponses) ProcessesBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*ProcessesBySiteResponse, error) {
	rsp, err := c.ProcessesBySite(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseProcessesBySiteResponse(rsp)
}

// RoutersBySiteWithResponse request returning *RoutersBySiteResponse
func (c *ClientWithResponses) RoutersBySiteWithResponse(ctx context.Context, id PathID, reqEditors ...RequestEditorFn) (*RoutersBySiteResponse, error) {
	rsp, err := c.RoutersBySite(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRoutersBySiteResponse(rsp)
}

// ParseApplicationflowsResponse parses an HTTP response from a ApplicationflowsWithResponse call
func ParseApplicationflowsResponse(rsp *http.Response) (*ApplicationflowsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ApplicationflowsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetApplicationFlows
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseComponentpairsResponse parses an HTTP response from a ComponentpairsWithResponse call
func ParseComponentpairsResponse(rsp *http.Response) (*ComponentpairsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ComponentpairsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregates
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseComponentpairByIDResponse parses an HTTP response from a ComponentpairByIDWithResponse call
func ParseComponentpairByIDResponse(rsp *http.Response) (*ComponentpairByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ComponentpairByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregateByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseComponentsResponse parses an HTTP response from a ComponentsWithResponse call
func ParseComponentsResponse(rsp *http.Response) (*ComponentsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ComponentsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetComponents
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseComponentByIDResponse parses an HTTP response from a ComponentByIDWithResponse call
func ParseComponentByIDResponse(rsp *http.Response) (*ComponentByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ComponentByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetComponentByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseConnectionsResponse parses an HTTP response from a ConnectionsWithResponse call
func ParseConnectionsResponse(rsp *http.Response) (*ConnectionsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ConnectionsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetConnections
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseConnectorsResponse parses an HTTP response from a ConnectorsWithResponse call
func ParseConnectorsResponse(rsp *http.Response) (*ConnectorsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ConnectorsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetConnectors
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseConnectorByIDResponse parses an HTTP response from a ConnectorByIDWithResponse call
func ParseConnectorByIDResponse(rsp *http.Response) (*ConnectorByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ConnectorByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetConnectorByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseHostsResponse parses an HTTP response from a HostsWithResponse call
func ParseHostsResponse(rsp *http.Response) (*HostsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &HostsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 410:
		var dest NotSupported
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON410 = &dest

	}

	return response, nil
}

// ParseHostsByIDResponse parses an HTTP response from a HostsByIDWithResponse call
func ParseHostsByIDResponse(rsp *http.Response) (*HostsByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &HostsByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotSupported
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseListenersResponse parses an HTTP response from a ListenersWithResponse call
func ParseListenersResponse(rsp *http.Response) (*ListenersResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListenersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetListeners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseListenerByIDResponse parses an HTTP response from a ListenerByIDWithResponse call
func ParseListenerByIDResponse(rsp *http.Response) (*ListenerByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListenerByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetListenerByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseProcessesResponse parses an HTTP response from a ProcessesWithResponse call
func ParseProcessesResponse(rsp *http.Response) (*ProcessesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcessesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetProcesses
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseProcessByIdResponse parses an HTTP response from a ProcessByIdWithResponse call
func ParseProcessByIdResponse(rsp *http.Response) (*ProcessByIdResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcessByIdResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetProcessByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseProcesspairsResponse parses an HTTP response from a ProcesspairsWithResponse call
func ParseProcesspairsResponse(rsp *http.Response) (*ProcesspairsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcesspairsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregates
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseProcesspairByIDResponse parses an HTTP response from a ProcesspairByIDWithResponse call
func ParseProcesspairByIDResponse(rsp *http.Response) (*ProcesspairByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcesspairByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregateByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseRouteraccessResponse parses an HTTP response from a RouteraccessWithResponse call
func ParseRouteraccessResponse(rsp *http.Response) (*RouteraccessResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RouteraccessResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouterAccess
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseRouteraccessByIDResponse parses an HTTP response from a RouteraccessByIDWithResponse call
func ParseRouteraccessByIDResponse(rsp *http.Response) (*RouteraccessByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RouteraccessByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouterAccessByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseRouterlinksResponse parses an HTTP response from a RouterlinksWithResponse call
func ParseRouterlinksResponse(rsp *http.Response) (*RouterlinksResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RouterlinksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouterLinks
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseRouterlinkByIDResponse parses an HTTP response from a RouterlinkByIDWithResponse call
func ParseRouterlinkByIDResponse(rsp *http.Response) (*RouterlinkByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RouterlinkByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouterLinkByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseRoutersResponse parses an HTTP response from a RoutersWithResponse call
func ParseRoutersResponse(rsp *http.Response) (*RoutersResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RoutersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouters
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseRouterByIDResponse parses an HTTP response from a RouterByIDWithResponse call
func ParseRouterByIDResponse(rsp *http.Response) (*RouterByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RouterByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouterByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseServicesResponse parses an HTTP response from a ServicesWithResponse call
func ParseServicesResponse(rsp *http.Response) (*ServicesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ServicesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetServices
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseServiceByIDResponse parses an HTTP response from a ServiceByIDWithResponse call
func ParseServiceByIDResponse(rsp *http.Response) (*ServiceByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ServiceByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetServiceByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseConnectionsByServiceResponse parses an HTTP response from a ConnectionsByServiceWithResponse call
func ParseConnectionsByServiceResponse(rsp *http.Response) (*ConnectionsByServiceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ConnectionsByServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetConnections
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseProcessesByServiceResponse parses an HTTP response from a ProcessesByServiceWithResponse call
func ParseProcessesByServiceResponse(rsp *http.Response) (*ProcessesByServiceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcessesByServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetProcesses
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseProcessPairsByServiceResponse parses an HTTP response from a ProcessPairsByServiceWithResponse call
func ParseProcessPairsByServiceResponse(rsp *http.Response) (*ProcessPairsByServiceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcessPairsByServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregates
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseSitepairsResponse parses an HTTP response from a SitepairsWithResponse call
func ParseSitepairsResponse(rsp *http.Response) (*SitepairsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &SitepairsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregates
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseSitepairByIDResponse parses an HTTP response from a SitepairByIDWithResponse call
func ParseSitepairByIDResponse(rsp *http.Response) (*SitepairByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &SitepairByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetFlowAggregateByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseSitesResponse parses an HTTP response from a SitesWithResponse call
func ParseSitesResponse(rsp *http.Response) (*SitesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &SitesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetSites
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest ErrorBadRequest
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	}

	return response, nil
}

// ParseSiteByIdResponse parses an HTTP response from a SiteByIdWithResponse call
func ParseSiteByIdResponse(rsp *http.Response) (*SiteByIdResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &SiteByIdResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetSiteByID
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseHostsBySiteResponse parses an HTTP response from a HostsBySiteWithResponse call
func ParseHostsBySiteResponse(rsp *http.Response) (*HostsBySiteResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &HostsBySiteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 410:
		var dest NotSupported
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON410 = &dest

	}

	return response, nil
}

// ParseProcessesBySiteResponse parses an HTTP response from a ProcessesBySiteWithResponse call
func ParseProcessesBySiteResponse(rsp *http.Response) (*ProcessesBySiteResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ProcessesBySiteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetProcesses
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ParseRoutersBySiteResponse parses an HTTP response from a RoutersBySiteWithResponse call
func ParseRoutersBySiteResponse(rsp *http.Response) (*RoutersBySiteResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RoutersBySiteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest GetRouters
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest ErrorNotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	}

	return response, nil
}

// ServerInterface represents all server handlers.
type ServerInterface interface {

	// (GET /api/v2alpha1/applicationflows)
	Applicationflows(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/componentpairs)
	Componentpairs(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/componentpairs/{id})
	ComponentpairByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/components)
	Components(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/components/{id})
	ComponentByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/connections)
	Connections(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/connectors)
	Connectors(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/connectors/{id})
	ConnectorByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/hosts)
	Hosts(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/hosts/{id})
	HostsByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/listeners)
	Listeners(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/listeners/{id})
	ListenerByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/processes)
	Processes(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/processes/{id})
	ProcessById(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/processpairs)
	Processpairs(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/processpairs/{id})
	ProcesspairByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/routeraccess)
	Routeraccess(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/routeraccess/{id})
	RouteraccessByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/routerlinks)
	Routerlinks(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/routerlinks/{id})
	RouterlinkByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/routers)
	Routers(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/routers/{id})
	RouterByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/services)
	Services(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/services/{id})
	ServiceByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/services/{id}/connections)
	ConnectionsByService(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/services/{id}/processes)
	ProcessesByService(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/services/{id}/processpairs)
	ProcessPairsByService(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/sitepairs)
	Sitepairs(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/sitepairs/{id})
	SitepairByID(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/sites)
	Sites(w http.ResponseWriter, r *http.Request)

	// (GET /api/v2alpha1/sites/{id})
	SiteById(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/sites/{id}/hosts)
	HostsBySite(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/sites/{id}/processes)
	ProcessesBySite(w http.ResponseWriter, r *http.Request, id PathID)

	// (GET /api/v2alpha1/sites/{id}/routers)
	RoutersBySite(w http.ResponseWriter, r *http.Request, id PathID)
}

// ServerInterfaceWrapper converts contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler            ServerInterface
	HandlerMiddlewares []MiddlewareFunc
	ErrorHandlerFunc   func(w http.ResponseWriter, r *http.Request, err error)
}

type MiddlewareFunc func(http.Handler) http.Handler

// Applicationflows operation middleware
func (siw *ServerInterfaceWrapper) Applicationflows(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Applicationflows(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Componentpairs operation middleware
func (siw *ServerInterfaceWrapper) Componentpairs(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Componentpairs(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ComponentpairByID operation middleware
func (siw *ServerInterfaceWrapper) ComponentpairByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ComponentpairByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Components operation middleware
func (siw *ServerInterfaceWrapper) Components(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Components(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ComponentByID operation middleware
func (siw *ServerInterfaceWrapper) ComponentByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ComponentByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Connections operation middleware
func (siw *ServerInterfaceWrapper) Connections(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Connections(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Connectors operation middleware
func (siw *ServerInterfaceWrapper) Connectors(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Connectors(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ConnectorByID operation middleware
func (siw *ServerInterfaceWrapper) ConnectorByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ConnectorByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Hosts operation middleware
func (siw *ServerInterfaceWrapper) Hosts(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Hosts(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// HostsByID operation middleware
func (siw *ServerInterfaceWrapper) HostsByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.HostsByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Listeners operation middleware
func (siw *ServerInterfaceWrapper) Listeners(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Listeners(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ListenerByID operation middleware
func (siw *ServerInterfaceWrapper) ListenerByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ListenerByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Processes operation middleware
func (siw *ServerInterfaceWrapper) Processes(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Processes(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ProcessById operation middleware
func (siw *ServerInterfaceWrapper) ProcessById(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ProcessById(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Processpairs operation middleware
func (siw *ServerInterfaceWrapper) Processpairs(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Processpairs(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ProcesspairByID operation middleware
func (siw *ServerInterfaceWrapper) ProcesspairByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ProcesspairByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Routeraccess operation middleware
func (siw *ServerInterfaceWrapper) Routeraccess(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Routeraccess(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// RouteraccessByID operation middleware
func (siw *ServerInterfaceWrapper) RouteraccessByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.RouteraccessByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Routerlinks operation middleware
func (siw *ServerInterfaceWrapper) Routerlinks(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Routerlinks(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// RouterlinkByID operation middleware
func (siw *ServerInterfaceWrapper) RouterlinkByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.RouterlinkByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Routers operation middleware
func (siw *ServerInterfaceWrapper) Routers(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Routers(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// RouterByID operation middleware
func (siw *ServerInterfaceWrapper) RouterByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.RouterByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Services operation middleware
func (siw *ServerInterfaceWrapper) Services(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Services(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ServiceByID operation middleware
func (siw *ServerInterfaceWrapper) ServiceByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ServiceByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ConnectionsByService operation middleware
func (siw *ServerInterfaceWrapper) ConnectionsByService(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ConnectionsByService(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ProcessesByService operation middleware
func (siw *ServerInterfaceWrapper) ProcessesByService(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ProcessesByService(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ProcessPairsByService operation middleware
func (siw *ServerInterfaceWrapper) ProcessPairsByService(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ProcessPairsByService(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Sitepairs operation middleware
func (siw *ServerInterfaceWrapper) Sitepairs(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Sitepairs(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// SitepairByID operation middleware
func (siw *ServerInterfaceWrapper) SitepairByID(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.SitepairByID(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// Sites operation middleware
func (siw *ServerInterfaceWrapper) Sites(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Sites(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// SiteById operation middleware
func (siw *ServerInterfaceWrapper) SiteById(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.SiteById(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// HostsBySite operation middleware
func (siw *ServerInterfaceWrapper) HostsBySite(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.HostsBySite(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ProcessesBySite operation middleware
func (siw *ServerInterfaceWrapper) ProcessesBySite(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ProcessesBySite(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// RoutersBySite operation middleware
func (siw *ServerInterfaceWrapper) RoutersBySite(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "id" -------------
	var id PathID

	err = runtime.BindStyledParameterWithOptions("simple", "id", mux.Vars(r)["id"], &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "id", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.RoutersBySite(w, r, id)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

type UnescapedCookieParamError struct {
	ParamName string
	Err       error
}

func (e *UnescapedCookieParamError) Error() string {
	return fmt.Sprintf("error unescaping cookie parameter '%s'", e.ParamName)
}

func (e *UnescapedCookieParamError) Unwrap() error {
	return e.Err
}

type UnmarshalingParamError struct {
	ParamName string
	Err       error
}

func (e *UnmarshalingParamError) Error() string {
	return fmt.Sprintf("Error unmarshaling parameter %s as JSON: %s", e.ParamName, e.Err.Error())
}

func (e *UnmarshalingParamError) Unwrap() error {
	return e.Err
}

type RequiredParamError struct {
	ParamName string
}

func (e *RequiredParamError) Error() string {
	return fmt.Sprintf("Query argument %s is required, but not found", e.ParamName)
}

type RequiredHeaderError struct {
	ParamName string
	Err       error
}

func (e *RequiredHeaderError) Error() string {
	return fmt.Sprintf("Header parameter %s is required, but not found", e.ParamName)
}

func (e *RequiredHeaderError) Unwrap() error {
	return e.Err
}

type InvalidParamFormatError struct {
	ParamName string
	Err       error
}

func (e *InvalidParamFormatError) Error() string {
	return fmt.Sprintf("Invalid format for parameter %s: %s", e.ParamName, e.Err.Error())
}

func (e *InvalidParamFormatError) Unwrap() error {
	return e.Err
}

type TooManyValuesForParamError struct {
	ParamName string
	Count     int
}

func (e *TooManyValuesForParamError) Error() string {
	return fmt.Sprintf("Expected one value for %s, got %d", e.ParamName, e.Count)
}

// Handler creates http.Handler with routing matching OpenAPI spec.
func Handler(si ServerInterface) http.Handler {
	return HandlerWithOptions(si, GorillaServerOptions{})
}

type GorillaServerOptions struct {
	BaseURL          string
	BaseRouter       *mux.Router
	Middlewares      []MiddlewareFunc
	ErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

// HandlerFromMux creates http.Handler with routing matching OpenAPI spec based on the provided mux.
func HandlerFromMux(si ServerInterface, r *mux.Router) http.Handler {
	return HandlerWithOptions(si, GorillaServerOptions{
		BaseRouter: r,
	})
}

func HandlerFromMuxWithBaseURL(si ServerInterface, r *mux.Router, baseURL string) http.Handler {
	return HandlerWithOptions(si, GorillaServerOptions{
		BaseURL:    baseURL,
		BaseRouter: r,
	})
}

// HandlerWithOptions creates http.Handler with additional options
func HandlerWithOptions(si ServerInterface, options GorillaServerOptions) http.Handler {
	r := options.BaseRouter

	if r == nil {
		r = mux.NewRouter()
	}
	if options.ErrorHandlerFunc == nil {
		options.ErrorHandlerFunc = func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}
	}
	wrapper := ServerInterfaceWrapper{
		Handler:            si,
		HandlerMiddlewares: options.Middlewares,
		ErrorHandlerFunc:   options.ErrorHandlerFunc,
	}

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/applicationflows", wrapper.Applicationflows).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/componentpairs", wrapper.Componentpairs).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/componentpairs/{id}", wrapper.ComponentpairByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/components", wrapper.Components).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/components/{id}", wrapper.ComponentByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/connections", wrapper.Connections).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/connectors", wrapper.Connectors).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/connectors/{id}", wrapper.ConnectorByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/hosts", wrapper.Hosts).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/hosts/{id}", wrapper.HostsByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/listeners", wrapper.Listeners).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/listeners/{id}", wrapper.ListenerByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/processes", wrapper.Processes).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/processes/{id}", wrapper.ProcessById).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/processpairs", wrapper.Processpairs).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/processpairs/{id}", wrapper.ProcesspairByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routeraccess", wrapper.Routeraccess).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routeraccess/{id}", wrapper.RouteraccessByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routerlinks", wrapper.Routerlinks).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routerlinks/{id}", wrapper.RouterlinkByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routers", wrapper.Routers).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/routers/{id}", wrapper.RouterByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/services", wrapper.Services).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/services/{id}", wrapper.ServiceByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/services/{id}/connections", wrapper.ConnectionsByService).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/services/{id}/processes", wrapper.ProcessesByService).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/services/{id}/processpairs", wrapper.ProcessPairsByService).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sitepairs", wrapper.Sitepairs).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sitepairs/{id}", wrapper.SitepairByID).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sites", wrapper.Sites).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sites/{id}", wrapper.SiteById).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sites/{id}/hosts", wrapper.HostsBySite).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sites/{id}/processes", wrapper.ProcessesBySite).Methods("GET")

	r.HandleFunc(options.BaseURL+"/api/v2alpha1/sites/{id}/routers", wrapper.RoutersBySite).Methods("GET")

	return r
}
