/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2alpha1

import (
	internalinterfaces "github.com/skupperproject/skupper/pkg/generated/client/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// AccessGrants returns a AccessGrantInformer.
	AccessGrants() AccessGrantInformer
	// AccessTokens returns a AccessTokenInformer.
	AccessTokens() AccessTokenInformer
	// AttachedConnectors returns a AttachedConnectorInformer.
	AttachedConnectors() AttachedConnectorInformer
	// AttachedConnectorBindings returns a AttachedConnectorBindingInformer.
	AttachedConnectorBindings() AttachedConnectorBindingInformer
	// Certificates returns a CertificateInformer.
	Certificates() CertificateInformer
	// Connectors returns a ConnectorInformer.
	Connectors() ConnectorInformer
	// Links returns a LinkInformer.
	Links() LinkInformer
	// Listeners returns a ListenerInformer.
	Listeners() ListenerInformer
	// RouterAccesses returns a RouterAccessInformer.
	RouterAccesses() RouterAccessInformer
	// SecuredAccesses returns a SecuredAccessInformer.
	SecuredAccesses() SecuredAccessInformer
	// Sites returns a SiteInformer.
	Sites() SiteInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// AccessGrants returns a AccessGrantInformer.
func (v *version) AccessGrants() AccessGrantInformer {
	return &accessGrantInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// AccessTokens returns a AccessTokenInformer.
func (v *version) AccessTokens() AccessTokenInformer {
	return &accessTokenInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// AttachedConnectors returns a AttachedConnectorInformer.
func (v *version) AttachedConnectors() AttachedConnectorInformer {
	return &attachedConnectorInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// AttachedConnectorBindings returns a AttachedConnectorBindingInformer.
func (v *version) AttachedConnectorBindings() AttachedConnectorBindingInformer {
	return &attachedConnectorBindingInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Certificates returns a CertificateInformer.
func (v *version) Certificates() CertificateInformer {
	return &certificateInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Connectors returns a ConnectorInformer.
func (v *version) Connectors() ConnectorInformer {
	return &connectorInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Links returns a LinkInformer.
func (v *version) Links() LinkInformer {
	return &linkInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Listeners returns a ListenerInformer.
func (v *version) Listeners() ListenerInformer {
	return &listenerInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// RouterAccesses returns a RouterAccessInformer.
func (v *version) RouterAccesses() RouterAccessInformer {
	return &routerAccessInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// SecuredAccesses returns a SecuredAccessInformer.
func (v *version) SecuredAccesses() SecuredAccessInformer {
	return &securedAccessInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Sites returns a SiteInformer.
func (v *version) Sites() SiteInformer {
	return &siteInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
