/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// AttachedConnectorLister helps list AttachedConnectors.
// All objects returned here must be treated as read-only.
type AttachedConnectorLister interface {
	// List lists all AttachedConnectors in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.AttachedConnector, err error)
	// AttachedConnectors returns an object that can list and get AttachedConnectors.
	AttachedConnectors(namespace string) AttachedConnectorNamespaceLister
	AttachedConnectorListerExpansion
}

// attachedConnectorLister implements the AttachedConnectorLister interface.
type attachedConnectorLister struct {
	listers.ResourceIndexer[*v2alpha1.AttachedConnector]
}

// NewAttachedConnectorLister returns a new AttachedConnectorLister.
func NewAttachedConnectorLister(indexer cache.Indexer) AttachedConnectorLister {
	return &attachedConnectorLister{listers.New[*v2alpha1.AttachedConnector](indexer, v2alpha1.Resource("attachedconnector"))}
}

// AttachedConnectors returns an object that can list and get AttachedConnectors.
func (s *attachedConnectorLister) AttachedConnectors(namespace string) AttachedConnectorNamespaceLister {
	return attachedConnectorNamespaceLister{listers.NewNamespaced[*v2alpha1.AttachedConnector](s.ResourceIndexer, namespace)}
}

// AttachedConnectorNamespaceLister helps list and get AttachedConnectors.
// All objects returned here must be treated as read-only.
type AttachedConnectorNamespaceLister interface {
	// List lists all AttachedConnectors in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.AttachedConnector, err error)
	// Get retrieves the AttachedConnector from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.AttachedConnector, error)
	AttachedConnectorNamespaceListerExpansion
}

// attachedConnectorNamespaceLister implements the AttachedConnectorNamespaceLister
// interface.
type attachedConnectorNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.AttachedConnector]
}
