// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerStartReader is a Reader for the ContainerStart structure.
type ContainerStartReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerStartReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerStartNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 304:
		result := NewContainerStartNotModified()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerStartNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerStartInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerStartNoContent creates a ContainerStartNoContent with default headers values
func NewContainerStartNoContent() *ContainerStartNoContent {
	return &ContainerStartNoContent{}
}

/*
ContainerStartNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerStartNoContent struct {
}

// IsSuccess returns true when this container start no content response has a 2xx status code
func (o *ContainerStartNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container start no content response has a 3xx status code
func (o *ContainerStartNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container start no content response has a 4xx status code
func (o *ContainerStartNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container start no content response has a 5xx status code
func (o *ContainerStartNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container start no content response a status code equal to that given
func (o *ContainerStartNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerStartNoContent) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNoContent ", 204)
}

func (o *ContainerStartNoContent) String() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNoContent ", 204)
}

func (o *ContainerStartNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerStartNotModified creates a ContainerStartNotModified with default headers values
func NewContainerStartNotModified() *ContainerStartNotModified {
	return &ContainerStartNotModified{}
}

/*
ContainerStartNotModified describes a response with status code 304, with default header values.

Container already started
*/
type ContainerStartNotModified struct {
	Payload *ContainerStartNotModifiedBody
}

// IsSuccess returns true when this container start not modified response has a 2xx status code
func (o *ContainerStartNotModified) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container start not modified response has a 3xx status code
func (o *ContainerStartNotModified) IsRedirect() bool {
	return true
}

// IsClientError returns true when this container start not modified response has a 4xx status code
func (o *ContainerStartNotModified) IsClientError() bool {
	return false
}

// IsServerError returns true when this container start not modified response has a 5xx status code
func (o *ContainerStartNotModified) IsServerError() bool {
	return false
}

// IsCode returns true when this container start not modified response a status code equal to that given
func (o *ContainerStartNotModified) IsCode(code int) bool {
	return code == 304
}

func (o *ContainerStartNotModified) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNotModified  %+v", 304, o.Payload)
}

func (o *ContainerStartNotModified) String() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNotModified  %+v", 304, o.Payload)
}

func (o *ContainerStartNotModified) GetPayload() *ContainerStartNotModifiedBody {
	return o.Payload
}

func (o *ContainerStartNotModified) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStartNotModifiedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerStartNotFound creates a ContainerStartNotFound with default headers values
func NewContainerStartNotFound() *ContainerStartNotFound {
	return &ContainerStartNotFound{}
}

/*
ContainerStartNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerStartNotFound struct {
	Payload *ContainerStartNotFoundBody
}

// IsSuccess returns true when this container start not found response has a 2xx status code
func (o *ContainerStartNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container start not found response has a 3xx status code
func (o *ContainerStartNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container start not found response has a 4xx status code
func (o *ContainerStartNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container start not found response has a 5xx status code
func (o *ContainerStartNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container start not found response a status code equal to that given
func (o *ContainerStartNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerStartNotFound) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStartNotFound) String() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStartNotFound) GetPayload() *ContainerStartNotFoundBody {
	return o.Payload
}

func (o *ContainerStartNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStartNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerStartInternalServerError creates a ContainerStartInternalServerError with default headers values
func NewContainerStartInternalServerError() *ContainerStartInternalServerError {
	return &ContainerStartInternalServerError{}
}

/*
ContainerStartInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerStartInternalServerError struct {
	Payload *ContainerStartInternalServerErrorBody
}

// IsSuccess returns true when this container start internal server error response has a 2xx status code
func (o *ContainerStartInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container start internal server error response has a 3xx status code
func (o *ContainerStartInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container start internal server error response has a 4xx status code
func (o *ContainerStartInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container start internal server error response has a 5xx status code
func (o *ContainerStartInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container start internal server error response a status code equal to that given
func (o *ContainerStartInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerStartInternalServerError) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStartInternalServerError) String() string {
	return fmt.Sprintf("[POST /containers/{name}/start][%d] containerStartInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStartInternalServerError) GetPayload() *ContainerStartInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerStartInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStartInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerStartInternalServerErrorBody container start internal server error body
swagger:model ContainerStartInternalServerErrorBody
*/
type ContainerStartInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container start internal server error body
func (o *ContainerStartInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container start internal server error body based on context it is used
func (o *ContainerStartInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStartInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStartInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerStartInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerStartNotFoundBody container start not found body
swagger:model ContainerStartNotFoundBody
*/
type ContainerStartNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container start not found body
func (o *ContainerStartNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container start not found body based on context it is used
func (o *ContainerStartNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStartNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStartNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerStartNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerStartNotModifiedBody container start not modified body
swagger:model ContainerStartNotModifiedBody
*/
type ContainerStartNotModifiedBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container start not modified body
func (o *ContainerStartNotModifiedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container start not modified body based on context it is used
func (o *ContainerStartNotModifiedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStartNotModifiedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStartNotModifiedBody) UnmarshalBinary(b []byte) error {
	var res ContainerStartNotModifiedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
