// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerStopParams creates a new ContainerStopParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerStopParams() *ContainerStopParams {
	return &ContainerStopParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerStopParamsWithTimeout creates a new ContainerStopParams object
// with the ability to set a timeout on a request.
func NewContainerStopParamsWithTimeout(timeout time.Duration) *ContainerStopParams {
	return &ContainerStopParams{
		timeout: timeout,
	}
}

// NewContainerStopParamsWithContext creates a new ContainerStopParams object
// with the ability to set a context for a request.
func NewContainerStopParamsWithContext(ctx context.Context) *ContainerStopParams {
	return &ContainerStopParams{
		Context: ctx,
	}
}

// NewContainerStopParamsWithHTTPClient creates a new ContainerStopParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerStopParamsWithHTTPClient(client *http.Client) *ContainerStopParams {
	return &ContainerStopParams{
		HTTPClient: client,
	}
}

/*
ContainerStopParams contains all the parameters to send to the API endpoint

	for the container stop operation.

	Typically these are written to a http.Request.
*/
type ContainerStopParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* T.

	   number of seconds to wait before killing container
	*/
	T *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container stop params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStopParams) WithDefaults() *ContainerStopParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container stop params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStopParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container stop params
func (o *ContainerStopParams) WithTimeout(timeout time.Duration) *ContainerStopParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container stop params
func (o *ContainerStopParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container stop params
func (o *ContainerStopParams) WithContext(ctx context.Context) *ContainerStopParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container stop params
func (o *ContainerStopParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container stop params
func (o *ContainerStopParams) WithHTTPClient(client *http.Client) *ContainerStopParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container stop params
func (o *ContainerStopParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container stop params
func (o *ContainerStopParams) WithName(name string) *ContainerStopParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container stop params
func (o *ContainerStopParams) SetName(name string) {
	o.Name = name
}

// WithT adds the t to the container stop params
func (o *ContainerStopParams) WithT(t *int64) *ContainerStopParams {
	o.SetT(t)
	return o
}

// SetT adds the t to the container stop params
func (o *ContainerStopParams) SetT(t *int64) {
	o.T = t
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerStopParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.T != nil {

		// query param t
		var qrT int64

		if o.T != nil {
			qrT = *o.T
		}
		qT := swag.FormatInt64(qrT)
		if qT != "" {

			if err := r.SetQueryParam("t", qT); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
