// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerUnpauseParams creates a new ContainerUnpauseParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerUnpauseParams() *ContainerUnpauseParams {
	return &ContainerUnpauseParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerUnpauseParamsWithTimeout creates a new ContainerUnpauseParams object
// with the ability to set a timeout on a request.
func NewContainerUnpauseParamsWithTimeout(timeout time.Duration) *ContainerUnpauseParams {
	return &ContainerUnpauseParams{
		timeout: timeout,
	}
}

// NewContainerUnpauseParamsWithContext creates a new ContainerUnpauseParams object
// with the ability to set a context for a request.
func NewContainerUnpauseParamsWithContext(ctx context.Context) *ContainerUnpauseParams {
	return &ContainerUnpauseParams{
		Context: ctx,
	}
}

// NewContainerUnpauseParamsWithHTTPClient creates a new ContainerUnpauseParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerUnpauseParamsWithHTTPClient(client *http.Client) *ContainerUnpauseParams {
	return &ContainerUnpauseParams{
		HTTPClient: client,
	}
}

/*
ContainerUnpauseParams contains all the parameters to send to the API endpoint

	for the container unpause operation.

	Typically these are written to a http.Request.
*/
type ContainerUnpauseParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container unpause params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerUnpauseParams) WithDefaults() *ContainerUnpauseParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container unpause params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerUnpauseParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container unpause params
func (o *ContainerUnpauseParams) WithTimeout(timeout time.Duration) *ContainerUnpauseParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container unpause params
func (o *ContainerUnpauseParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container unpause params
func (o *ContainerUnpauseParams) WithContext(ctx context.Context) *ContainerUnpauseParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container unpause params
func (o *ContainerUnpauseParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container unpause params
func (o *ContainerUnpauseParams) WithHTTPClient(client *http.Client) *ContainerUnpauseParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container unpause params
func (o *ContainerUnpauseParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container unpause params
func (o *ContainerUnpauseParams) WithName(name string) *ContainerUnpauseParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container unpause params
func (o *ContainerUnpauseParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerUnpauseParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
