// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NetworkConnectReader is a Reader for the NetworkConnect structure.
type NetworkConnectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkConnectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkConnectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewNetworkConnectBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNetworkConnectInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkConnectOK creates a NetworkConnectOK with default headers values
func NewNetworkConnectOK() *NetworkConnectOK {
	return &NetworkConnectOK{}
}

/*
NetworkConnectOK describes a response with status code 200, with default header values.

OK
*/
type NetworkConnectOK struct {
}

// IsSuccess returns true when this network connect o k response has a 2xx status code
func (o *NetworkConnectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network connect o k response has a 3xx status code
func (o *NetworkConnectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect o k response has a 4xx status code
func (o *NetworkConnectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network connect o k response has a 5xx status code
func (o *NetworkConnectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network connect o k response a status code equal to that given
func (o *NetworkConnectOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkConnectOK) Error() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectOK ", 200)
}

func (o *NetworkConnectOK) String() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectOK ", 200)
}

func (o *NetworkConnectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkConnectBadRequest creates a NetworkConnectBadRequest with default headers values
func NewNetworkConnectBadRequest() *NetworkConnectBadRequest {
	return &NetworkConnectBadRequest{}
}

/*
NetworkConnectBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type NetworkConnectBadRequest struct {
	Payload *NetworkConnectBadRequestBody
}

// IsSuccess returns true when this network connect bad request response has a 2xx status code
func (o *NetworkConnectBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network connect bad request response has a 3xx status code
func (o *NetworkConnectBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect bad request response has a 4xx status code
func (o *NetworkConnectBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this network connect bad request response has a 5xx status code
func (o *NetworkConnectBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this network connect bad request response a status code equal to that given
func (o *NetworkConnectBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *NetworkConnectBadRequest) Error() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectBadRequest  %+v", 400, o.Payload)
}

func (o *NetworkConnectBadRequest) String() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectBadRequest  %+v", 400, o.Payload)
}

func (o *NetworkConnectBadRequest) GetPayload() *NetworkConnectBadRequestBody {
	return o.Payload
}

func (o *NetworkConnectBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkConnectBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkConnectInternalServerError creates a NetworkConnectInternalServerError with default headers values
func NewNetworkConnectInternalServerError() *NetworkConnectInternalServerError {
	return &NetworkConnectInternalServerError{}
}

/*
NetworkConnectInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkConnectInternalServerError struct {
	Payload *NetworkConnectInternalServerErrorBody
}

// IsSuccess returns true when this network connect internal server error response has a 2xx status code
func (o *NetworkConnectInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network connect internal server error response has a 3xx status code
func (o *NetworkConnectInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect internal server error response has a 4xx status code
func (o *NetworkConnectInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network connect internal server error response has a 5xx status code
func (o *NetworkConnectInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network connect internal server error response a status code equal to that given
func (o *NetworkConnectInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkConnectInternalServerError) Error() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkConnectInternalServerError) String() string {
	return fmt.Sprintf("[POST /networks/{name}/connect][%d] networkConnectInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkConnectInternalServerError) GetPayload() *NetworkConnectInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkConnectInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkConnectInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkConnectBadRequestBody network connect bad request body
swagger:model NetworkConnectBadRequestBody
*/
type NetworkConnectBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network connect bad request body
func (o *NetworkConnectBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network connect bad request body based on context it is used
func (o *NetworkConnectBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkConnectBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkConnectBadRequestBody) UnmarshalBinary(b []byte) error {
	var res NetworkConnectBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkConnectInternalServerErrorBody network connect internal server error body
swagger:model NetworkConnectInternalServerErrorBody
*/
type NetworkConnectInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network connect internal server error body
func (o *NetworkConnectInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network connect internal server error body based on context it is used
func (o *NetworkConnectInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkConnectInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkConnectInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkConnectInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
