// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageConfig ImageConfig defines the execution parameters which should be used as a base when running a container using an image.
//
// swagger:model ImageConfig
type ImageConfig struct {

	// Cmd defines the default arguments to the entrypoint of the container.
	Cmd []string `json:"Cmd"`

	// Entrypoint defines a list of arguments to use as the command to execute when the container starts.
	Entrypoint []string `json:"Entrypoint"`

	// Env is a list of environment variables to be used in a container.
	Env []string `json:"Env"`

	// ExposedPorts a set of ports to expose from a container running this image.
	ExposedPorts map[string]interface{} `json:"ExposedPorts,omitempty"`

	// Labels contains arbitrary metadata for the container.
	Labels map[string]string `json:"Labels,omitempty"`

	// StopSignal contains the system call signal that will be sent to the container to exit.
	StopSignal string `json:"StopSignal,omitempty"`

	// User defines the username or UID which the process in the container should run as.
	User string `json:"User,omitempty"`

	// Volumes is a set of directories describing where the process is likely write data specific to a container instance.
	Volumes map[string]interface{} `json:"Volumes,omitempty"`

	// WorkingDir sets the current working directory of the entrypoint process in the container.
	WorkingDir string `json:"WorkingDir,omitempty"`
}

// Validate validates this image config
func (m *ImageConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image config based on context it is used
func (m *ImageConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ImageConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ImageConfig) UnmarshalBinary(b []byte) error {
	var res ImageConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
