// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Schema2ManifestDescriptor Schema2ManifestDescriptor references a platform-specific manifest.
//
// swagger:model Schema2ManifestDescriptor
type Schema2ManifestDescriptor struct {

	// media type
	MediaType string `json:"mediaType,omitempty"`

	// size
	Size int64 `json:"size,omitempty"`

	// u r ls
	URLs []string `json:"urls"`

	// digest
	Digest Digest `json:"digest,omitempty"`

	// platform
	Platform *Schema2PlatformSpec `json:"platform,omitempty"`
}

// Validate validates this schema2 manifest descriptor
func (m *Schema2ManifestDescriptor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDigest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatform(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schema2ManifestDescriptor) validateDigest(formats strfmt.Registry) error {
	if swag.IsZero(m.Digest) { // not required
		return nil
	}

	if err := m.Digest.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("digest")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("digest")
		}
		return err
	}

	return nil
}

func (m *Schema2ManifestDescriptor) validatePlatform(formats strfmt.Registry) error {
	if swag.IsZero(m.Platform) { // not required
		return nil
	}

	if m.Platform != nil {
		if err := m.Platform.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("platform")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("platform")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this schema2 manifest descriptor based on the context it is used
func (m *Schema2ManifestDescriptor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDigest(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePlatform(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schema2ManifestDescriptor) contextValidateDigest(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Digest.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("digest")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("digest")
		}
		return err
	}

	return nil
}

func (m *Schema2ManifestDescriptor) contextValidatePlatform(ctx context.Context, formats strfmt.Registry) error {

	if m.Platform != nil {
		if err := m.Platform.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("platform")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("platform")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Schema2ManifestDescriptor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Schema2ManifestDescriptor) UnmarshalBinary(b []byte) error {
	var res Schema2ManifestDescriptor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
