/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.xb.QNameBuilder;
import org.w3c.dom.Element;

public class SOAPFaultImpl
extends SOAPBodyElementDoc
implements SOAPFault {
    private static Logger log = Logger.getLogger(SOAPFaultImpl.class);
    private SOAPElement faultcode;
    private SOAPElement faultstring;
    private SOAPElement faultactor;
    private Locale faultStringLocale;

    public SOAPFaultImpl(String namespaceURI) throws SOAPException {
        super(new NameImpl("Fault", "env", namespaceURI));
        SOAPFactoryImpl factory = new SOAPFactoryImpl();
        this.faultcode = factory.createElement("faultcode");
        this.addChildElement(this.faultcode);
        this.faultstring = factory.createElement("faultstring");
        this.addChildElement(this.faultstring);
    }

    public Detail addDetail() throws SOAPException {
        Detail detail = this.getDetail();
        if (detail != null) {
            throw new SOAPException("SOAPFault already contains a detail node");
        }
        SOAPFactoryImpl factory = new SOAPFactoryImpl();
        detail = (Detail)this.addChildElement((SOAPElement)factory.createDetail());
        return detail;
    }

    public Detail getDetail() {
        Iterator it = this.getChildElements(new NameImpl("detail"));
        Detail detail = it.hasNext() ? (Detail)it.next() : null;
        return detail;
    }

    public String getFaultActor() {
        return this.faultactor != null ? this.faultactor.getValue() : null;
    }

    public String getFaultCode() {
        String value = this.faultcode.getValue();
        return value;
    }

    public Name getFaultCodeAsName() {
        QName qname = QNameBuilder.buildQName((Element)((Object)this), (String)this.faultcode.getValue());
        return new NameImpl(qname);
    }

    public String getFaultString() {
        String value = this.faultstring.getValue();
        return value;
    }

    public Locale getFaultStringLocale() {
        return this.faultStringLocale;
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.faultactor == null) {
            SOAPFactoryImpl factory = new SOAPFactoryImpl();
            this.faultactor = factory.createElement("faultactor");
            this.addChildElement(this.faultactor);
        }
        this.faultactor.setValue(faultActor);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        if (faultCode == null || faultCode.indexOf(":") < 1) {
            throw new IllegalArgumentException("Invalid faultCode: " + faultCode);
        }
        QName qname = QNameBuilder.buildQName((Element)((Object)this), (String)faultCode);
        this.setFaultCode(new NameImpl(qname));
    }

    public void setFaultCode(Name faultName) throws SOAPException {
        String prevNS;
        String nsURI = faultName.getURI();
        String prefix = faultName.getPrefix();
        String localName = faultName.getLocalName();
        if ("".equals(nsURI)) {
            log.warn((Object)("Empty namespace URI with fault code '" + faultName + "', assuming: " + "http://schemas.xmlsoap.org/soap/envelope/"));
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if ("".equals(prefix) && this.getNamespaceURI().equals(nsURI)) {
            prefix = this.getPrefix();
        }
        if (!nsURI.equals(prevNS = this.getNamespaceURI(prefix))) {
            this.addNamespaceDeclaration(prefix, nsURI);
        }
        String faultCode = prefix + ":" + localName;
        this.faultcode.setValue(faultCode);
    }

    public void setFaultString(String faultString) throws SOAPException {
        this.faultstring.setValue(faultString);
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        this.setFaultString(faultString);
        this.faultStringLocale = locale;
    }
}

