/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import com.deltax.util.ArrayEnumeration;
import com.deltax.util.ClassFileFinder;
import com.deltax.util.DynamicJDK12ClassFileFinder;
import com.deltax.util.ResourceFileFinder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JDK12ClassFileFinder
implements ClassFileFinder,
ResourceFileFinder {
    protected String classPath;
    protected Enumeration classPathDirs;
    protected HashSet missingFilesNotified = new HashSet();
    protected HashMap classCache = new HashMap();
    protected boolean classCacheOn = false;
    private Set reportedProblematicJars = new HashSet();
    private HashMap classNameEntryCache = new HashMap();

    public JDK12ClassFileFinder(String string) {
        this.classPath = string;
    }

    public JDK12ClassFileFinder() {
        this(System.getProperties().getProperty("java.class.path"));
    }

    public String getSupportedLoadingScheme() {
        return "1.2 (2)";
    }

    public InputStream openClass(String string) throws IOException, ClassNotFoundException {
        File file = this.findClassFile(string);
        if (!this.isJar(file)) {
            return new FileInputStream(file);
        }
        return this.openClassInJar(string, file);
    }

    public File findClassFile(String string) throws IOException, ClassNotFoundException {
        try {
            return this.searchInDirectory(new File(System.getProperties().getProperty("java.home") + File.separator + "lib"), string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return this.searchInDirectory(new File(System.getProperties().getProperty("java.ext.dirs")), string, true);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                Enumeration enumeration = this.getClassPathDirs();
                while (enumeration.hasMoreElements()) {
                    try {
                        Object object;
                        String string2 = (String)enumeration.nextElement();
                        File file = new File(string2);
                        if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) {
                            object = this.getCandidateClassFile(file, string);
                            if (!((File)object).exists()) continue;
                            return object;
                        }
                        object = new File[]{file};
                        return this.searchJars(string, (File[])object);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                    }
                }
                throw new ClassNotFoundException(string);
            }
        }
    }

    public byte[] getBytes(String string) throws IOException, ClassNotFoundException {
        int n;
        InputStream inputStream = this.openClass(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isJar(File file) {
        return file.getName().endsWith(".jar");
    }

    protected InputStream openClassInJar(String string, File file) throws IOException, ClassNotFoundException {
        Object object;
        if (this.classCacheOn && (object = (Object[])this.classCache.get(string)) != null && ((File)object[0]).equals(file)) {
            return new ByteArrayInputStream((byte[])object[1]);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getCanonicalPath().toString());
        }
        object = new JarFile(file);
        String string2 = this.classNameToEntry(string);
        JarEntry jarEntry = ((JarFile)object).getJarEntry(string2);
        if (jarEntry == null) {
            throw new ClassNotFoundException(string);
        }
        if (jarEntry.getSize() == -1L) {
            throw new RuntimeException("Unknown entry size in JAR file " + file);
        }
        if ((long)((int)jarEntry.getSize()) != jarEntry.getSize()) {
            throw new RuntimeException("Entry " + string2 + " too big in " + file);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(((JarFile)object).getInputStream(jarEntry));
        byte[] byArray = new byte[(int)jarEntry.getSize()];
        int n = 0;
        while ((long)n < jarEntry.getSize()) {
            byArray[n] = (byte)((InputStream)bufferedInputStream).read();
            ++n;
        }
        ((InputStream)bufferedInputStream).close();
        if (this.classCacheOn) {
            this.classCache.put(string, new Object[]{file, byArray});
        }
        return new ByteArrayInputStream(byArray);
    }

    protected File searchJars(String string, File[] fileArray) throws IOException, ClassNotFoundException {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (this.reportedProblematicJars.contains(fileArray[i])) continue;
                this.openClassInJar(string, fileArray[i]).close();
                return fileArray[i];
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.missingFilesNotified.contains(fileNotFoundException.getMessage())) continue;
                System.err.println(fileNotFoundException.getMessage() + " is in class path but cannot be located while searching jars");
                this.missingFilesNotified.add(fileNotFoundException.getMessage());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Warning: problem with " + fileArray[i] + " while searching for class " + string + " (" + iOException.getClass().getName() + ": " + iOException.getMessage() + "). The file will be ignored.");
                this.reportedProblematicJars.add(fileArray[i]);
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected File[] findJarsInPath(File file) {
        if (!file.isDirectory()) {
            return new File[0];
        }
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        });
    }

    protected String classNameToPath(String string) {
        if (string.endsWith(".class")) {
            return string;
        }
        return string.replace('.', File.separatorChar) + ".class";
    }

    protected String classNameToEntry(String string) {
        String string2 = (String)this.classNameEntryCache.get(string);
        if (string2 == null) {
            if (string.endsWith(".class")) {
                return string;
            }
            string2 = string.replace('.', '/') + ".class";
            this.classNameEntryCache.put(string, string2);
        }
        return string2;
    }

    private File getCandidateClassFile(File file, String string) {
        return new File(file.getAbsolutePath() + File.separator + this.classNameToPath(string));
    }

    private File searchInDirectory(File file, String string, boolean bl) throws IOException, ClassNotFoundException {
        File file2;
        if (!bl && (file2 = this.getCandidateClassFile(file, string)).exists()) {
            return file2;
        }
        return this.searchJars(string, this.findJarsInPath(file));
    }

    protected synchronized Enumeration getClassPathDirs() {
        if (this.classPathDirs == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
            Object[] objectArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                objectArray[n++] = stringTokenizer.nextToken();
            }
            this.classPathDirs = new ArrayEnumeration(objectArray);
        } else {
            ((ArrayEnumeration)this.classPathDirs).reset();
        }
        return this.classPathDirs;
    }

    public byte[] getClassBytes(String string) throws IOException, ClassNotFoundException {
        int n;
        Object object;
        if (this.classCacheOn && (object = (Object[])this.classCache.get(string)) != null) {
            return (byte[])object[1];
        }
        object = new BufferedInputStream(this.openClass(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = ((BufferedInputStream)object).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        ((BufferedInputStream)object).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public InputStream openResource(String string) throws IOException {
        ResourceSearchResult resourceSearchResult = this.findResourceFile0(string);
        if (resourceSearchResult != null) {
            return resourceSearchResult.stream;
        }
        return null;
    }

    public File findResourceFile(String string) throws IOException {
        ResourceSearchResult resourceSearchResult = this.findResourceFile0(string);
        if (resourceSearchResult != null) {
            return resourceSearchResult.f;
        }
        return null;
    }

    public byte[] getResourceBytes(String string) throws IOException {
        int n;
        InputStream inputStream = this.openResource(string);
        if (inputStream == null) {
            return null;
        }
        if (inputStream instanceof FileInputStream) {
            inputStream = new BufferedInputStream(inputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResourceSearchResult findResourceFile0(String string) throws IOException {
        if (string.endsWith(".class")) {
            return null;
        }
        ResourceSearchResult resourceSearchResult = null;
        resourceSearchResult = this.searchResourceInDirectory(new File(System.getProperties().getProperty("java.home") + File.separator + "lib"), string, false);
        if (resourceSearchResult != null) {
            return resourceSearchResult;
        }
        resourceSearchResult = this.searchResourceInDirectory(new File(System.getProperties().getProperty("java.ext.dirs")), string, true);
        if (resourceSearchResult != null) {
            return resourceSearchResult;
        }
        Enumeration enumeration = this.getClassPathDirs();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            System.out.println("JDK12CFF: looking for resource " + string + " in " + string2);
            File file = new File(string2);
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) {
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                return new ResourceSearchResult(file2);
            }
            if (!file.exists() || (resourceSearchResult = this.searchResourceInJars(string, new File[]{file})) == null) continue;
            return resourceSearchResult;
        }
        return null;
    }

    private ResourceSearchResult searchResourceInDirectory(File file, String string, boolean bl) throws IOException {
        File file2;
        if (!bl && (file2 = new File(string)).exists()) {
            return new ResourceSearchResult(file2);
        }
        return this.searchResourceInJars(string, this.findJarsInPath(file));
    }

    private ResourceSearchResult searchResourceInJars(String string, File[] fileArray) throws IOException {
        ResourceSearchResult resourceSearchResult = new ResourceSearchResult();
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.reportedProblematicJars.contains(fileArray[i])) continue;
            try {
                resourceSearchResult.f = fileArray[i];
                resourceSearchResult.stream = this.openResourceInJar(string, fileArray[i]);
                if (resourceSearchResult.stream == null) continue;
                return resourceSearchResult;
            }
            catch (IOException iOException) {
                System.err.println("Warning: problem with " + fileArray[i] + " while searching for resource " + string + " (" + iOException.getClass().getName() + ": " + iOException.getMessage() + "). The file will be ignored.");
                this.reportedProblematicJars.add(fileArray[i]);
            }
        }
        return null;
    }

    private InputStream openResourceInJar(String string, File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        JarFile jarFile = new JarFile(file);
        JarEntry jarEntry = null;
        jarEntry = jarFile.getJarEntry(string);
        if (jarEntry == null) {
            return null;
        }
        if (jarEntry.getSize() == -1L) {
            throw new RuntimeException("Unknown entry size in JAR file " + file);
        }
        if ((long)((int)jarEntry.getSize()) != jarEntry.getSize()) {
            throw new RuntimeException("Entry " + string + " too big in " + file);
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        byte[] byArray = new byte[(int)jarEntry.getSize()];
        int n = 0;
        while ((long)n < jarEntry.getSize()) {
            byArray[n] = (byte)inputStream.read();
            ++n;
        }
        inputStream.close();
        return new ByteArrayInputStream(byArray);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            return;
        }
        DynamicJDK12ClassFileFinder dynamicJDK12ClassFileFinder = new DynamicJDK12ClassFileFinder();
        dynamicJDK12ClassFileFinder.addClassPathEntry("c:\\j2sdk1.4.1_01\\jre\\lib\\endorsed\\xercesImpl.jar");
        InputStream inputStream = dynamicJDK12ClassFileFinder.openResource("org.apache.xerces.impl.msg.XMLMessages.properties");
        if (inputStream != null) {
            System.out.println("Resource found");
        } else {
            System.out.println("Resource not found");
        }
    }

    public boolean isClassCacheOn() {
        return this.classCacheOn;
    }

    public void setClassCacheOn(boolean bl) {
        this.classCacheOn = bl;
        if (!bl) {
            this.classCache = new HashMap();
        }
    }

    public Set getCorruptFiles() {
        return this.reportedProblematicJars;
    }

    public void clearCorruptFiles() {
        this.reportedProblematicJars = new HashSet();
    }

    private class ResourceSearchResult {
        public File f;
        public InputStream stream;

        ResourceSearchResult() {
        }

        ResourceSearchResult(File file) throws IOException {
            this.f = file;
            this.stream = new FileInputStream(file);
        }
    }
}

