/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util.listener;

import com.deltax.util.listener.BaseSignalSource;
import com.deltax.util.listener.ExceptionSignal;
import com.deltax.util.listener.Listener;
import com.deltax.util.listener.Signal;

public abstract class BaseSignalSourceThread
extends Thread {
    private static LFThreadGroup lfThreadGroup = new LFThreadGroup();
    protected BaseSignalSource bs;

    public BaseSignalSourceThread() {
        super((ThreadGroup)lfThreadGroup, "signal source " + lfThreadGroup.getNextCount());
        this.bs = new BaseSignalSource(){};
    }

    protected BaseSignalSourceThread(BaseSignalSource baseSignalSource) {
        super((ThreadGroup)lfThreadGroup, "signal source " + lfThreadGroup.getNextCount());
        this.bs = baseSignalSource;
    }

    public void addListener(Listener listener) {
        this.bs.addListener(listener);
    }

    public boolean isRegistered(Listener listener) {
        return this.bs.isRegistered(listener);
    }

    protected void notify(Signal signal) {
        this.bs.notify(signal);
    }

    protected void notifyException(ExceptionSignal exceptionSignal) {
        this.bs.notifyException(exceptionSignal);
    }

    public void removeListener(Listener listener) {
        this.bs.removeListener(listener);
    }

    public void removeAllListeners() {
        this.bs.removeAllListeners();
    }

    private static class LFThreadGroup
    extends ThreadGroup {
        private long threadCount = 0L;

        LFThreadGroup() {
            super("Signal thread group");
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }

        public synchronized long getNextCount() {
            return this.threadCount++;
        }
    }
}

