/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class AutoCRWriter
extends Writer {
    private static char[] lineSep;
    private PrintWriter out;
    private int index = 0;

    public AutoCRWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public AutoCRWriter(OutputStream outputStream) {
        this.out = new PrintWriter(new OutputStreamWriter(outputStream));
    }

    public void write(int n) throws IOException {
        if (n == lineSep[this.index]) {
            if (++this.index == lineSep.length) {
                this.out.flush();
                this.out.println();
                this.index = 0;
                return;
            }
        } else {
            if (this.index != 0) {
                for (int i = 0; i < this.index; ++i) {
                    this.out.write(lineSep[i]);
                }
                this.index = 0;
            }
            this.out.write(n);
        }
    }

    public void close() throws IOException {
        if (this.index != 0) {
            for (int i = 0; i < this.index; ++i) {
                this.out.write(lineSep[i]);
            }
            this.index = 0;
        }
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.index != 0) {
            for (int i = 0; i < this.index; ++i) {
                this.out.write(lineSep[i]);
            }
            this.index = 0;
        }
        this.out.flush();
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.write(cArray[i]);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        PrintWriter printWriter = new PrintWriter(new AutoCRWriter(System.out));
        ((Writer)printWriter).write("Hello");
        ((Writer)printWriter).write(new String(lineSep));
        ((Writer)printWriter).write("World");
        ((Writer)printWriter).write(new String(lineSep));
        printWriter.print("Hello2");
        printWriter.println();
        printWriter.print("World2");
        printWriter.println();
    }

    static {
        String string = System.getProperty("line.separator");
        lineSep = new char[string.length()];
        for (int i = 0; i < lineSep.length; ++i) {
            AutoCRWriter.lineSep[i] = string.charAt(i);
        }
    }
}

