/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;

public class AxisObjectSerializer {
    private Class msgContextCls;
    private Class axisEngineCls;
    private Class axisServerCls;
    private Class serializationContextCls;
    private Class beanSerializerCls;
    private Class qNameCls;
    private Class attributesCls;
    private static AxisObjectSerializer axisObjectSerializer;
    private static Object lock;

    private AxisObjectSerializer() {
        try {
            this.msgContextCls = Class.forName("org.apache.axis.MessageContext");
            this.axisEngineCls = Class.forName("org.apache.axis.AxisEngine");
            this.axisServerCls = Class.forName("org.apache.axis.server.AxisServer");
            this.serializationContextCls = Class.forName("org.apache.axis.encoding.SerializationContext");
            this.beanSerializerCls = Class.forName("org.apache.axis.encoding.ser.BeanSerializer");
            this.qNameCls = Class.forName("javax.xml.namespace.QName");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("The AXIS libraries are not in classpath (missing " + classNotFoundException.getMessage() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisObjectSerializer getInstance() {
        Object object = lock;
        synchronized (object) {
            if (axisObjectSerializer == null) {
                axisObjectSerializer = new AxisObjectSerializer();
            }
            return axisObjectSerializer;
        }
    }

    public byte[] serializeAxisObjectToXML(Object object) {
        Method method;
        Method method2;
        try {
            method2 = object.getClass().getMethod("getTypeDesc", new Class[0]);
            method = object.getClass().getMethod("getSerializer", String.class, Class.class, this.qNameCls);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(object + " is not an AXIS object");
        }
        try {
            Object t = this.axisServerCls.newInstance();
            Object t2 = this.msgContextCls.getConstructor(this.axisEngineCls).newInstance(t);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            Object t3 = this.serializationContextCls.getConstructor(Writer.class, this.msgContextCls).newInstance(outputStreamWriter, t2);
            Object object2 = method2.invoke(null, new Object[0]);
            Method method3 = object2.getClass().getMethod("getXmlType", new Class[0]);
            Object object3 = method3.invoke(object2, new Object[0]);
            Object object4 = method.invoke(null, "", object.getClass(), object3);
            Method method4 = object4.getClass().getMethod("serialize", this.qNameCls, Attributes.class, Object.class, this.serializationContextCls);
            method4.invoke(object4, object3, null, object, t3);
            ((Writer)outputStreamWriter).flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String serializeAxisObjectToXMLString(Object object) {
        byte[] byArray = this.serializeAxisObjectToXML(object);
        return new String(byArray);
    }

    static {
        lock = new Object();
    }
}

