/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sadun.util.ObjectWithId;
import org.sadun.util.ObjectWithIdMetadata;
import org.sadun.util.SimpleObjectWithIdMetadata;

public abstract class BaseObjectWithId
implements Serializable,
ObjectWithId {
    private ObjectWithIdMetadata metadata;
    protected static transient Map objectWithIdMetadataMap = new HashMap();
    private transient boolean modified;
    protected String objectId;
    private boolean requireSameTypeForEquality;

    protected BaseObjectWithId(String string, boolean bl) {
        this.objectId = string;
        this.requireSameTypeForEquality = bl;
        this.metadata = this.getMetadata();
        this.clearModified();
        if (this.metadata == null) {
            this.metadata = (ObjectWithIdMetadata)Collections.synchronizedMap(objectWithIdMetadataMap).get(this.getClass());
            if (this.metadata == null) {
                this.metadata = BaseObjectWithId.mkDefaultMetdata(this.getClass());
                Collections.synchronizedMap(objectWithIdMetadataMap).put(this.getClass(), this.metadata);
            }
        }
        this.checkPrefix(string, this.metadata);
    }

    protected void checkPrefix(String string, ObjectWithIdMetadata objectWithIdMetadata) {
        String string2 = objectWithIdMetadata.getIdPrefix();
        if (string2 != null && !string.startsWith(string2)) {
            throw new IllegalArgumentException("The given ID '" + string + "' for instance of " + this.getClass() + " does not match the required id prefix '" + string2 + "'");
        }
    }

    protected BaseObjectWithId(String string) {
        this(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectWithIdMetadata mkDefaultMetdata(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        CharSequence charSequence = stringBuffer;
        synchronized (charSequence) {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (!Character.isUpperCase(c)) continue;
                stringBuffer.append(Character.toLowerCase(c));
            }
        }
        charSequence = stringBuffer.toString();
        if (((String)charSequence).length() == 0) {
            charSequence = string.substring(0, Math.min(string.length(), 4));
        }
        SimpleObjectWithIdMetadata simpleObjectWithIdMetadata = new SimpleObjectWithIdMetadata(clazz, (String)charSequence);
        return simpleObjectWithIdMetadata;
    }

    public String getId() {
        return this.objectId;
    }

    public final boolean equals(Object object) {
        if (object instanceof ObjectWithId && !this.requireSameTypeForEquality) {
            if (object.getClass() != this.getClass()) {
                return false;
            }
            return this.objectId.equals(((ObjectWithId)object).getId());
        }
        return this.equalWithNoObjectWithId(object);
    }

    protected boolean equalWithNoObjectWithId(Object object) {
        return false;
    }

    public final int hashCode() {
        return this.objectId.hashCode();
    }

    public ObjectWithIdMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = (ObjectWithIdMetadata)Collections.synchronizedMap(objectWithIdMetadataMap).get(this.getClass());
            if (this.metadata == null) {
                this.metadata = BaseObjectWithId.mkDefaultMetdata(this.getClass());
                Collections.synchronizedMap(objectWithIdMetadataMap).put(this.getClass(), this.metadata);
            }
        }
        return this.metadata;
    }

    protected final void setModified() {
        this.modified = true;
    }

    protected final void clearModified() {
        this.modified = false;
    }

    public final boolean isModified() {
        return this.modified;
    }
}

