/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Cache {
    private HashMap map;
    private List accessList;
    private int max;

    public Cache(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("A cache can't be less than size 2");
        }
        this.max = n;
        this.clear();
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.map.size() >= this.max) {
            if (this.accessList.size() <= 0) {
                throw new IllegalStateException("AccessList size is 0");
            }
            Object e = this.accessList.get(0);
            this.accessList.remove(0);
            this.map.remove(e);
            this.removed(e);
        }
        this.used(object);
        return this.map.put(object, object2);
    }

    protected void removed(Object object) {
    }

    public synchronized Object remove(Object object) {
        Object v = this.map.remove(object);
        if (v == null) {
            return null;
        }
        this.accessList.remove(object);
        this.removed(v);
        return v;
    }

    public synchronized Object get(Object object) {
        Object v = this.map.get(object);
        if (v == null) {
            return null;
        }
        this.used(object);
        return v;
    }

    public synchronized void used(Object object) {
        boolean bl = this.accessList.isEmpty();
        if (!bl && this.accessList.get(0) != object) {
            this.accessList.remove(object);
            this.accessList.add(object);
        } else if (bl) {
            this.accessList.add(object);
        }
    }

    protected void clear() {
        this.map = new HashMap();
        this.accessList = new LinkedList();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }
}

