/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ClassPathIterator
implements Iterator {
    private StringTokenizer st;
    private String currentEntry;
    private File currentFile;

    public ClassPathIterator(String string) {
        this.st = new StringTokenizer(string, File.pathSeparator);
    }

    public ClassPathIterator() {
        this(System.getProperty("java.class.path"));
    }

    public boolean hasNext() {
        return this.st.hasMoreTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        ClassPathIterator classPathIterator = this;
        synchronized (classPathIterator) {
            this.currentEntry = this.st.nextToken();
            this.currentFile = new File(this.currentEntry);
            return this.currentEntry;
        }
    }

    public String nextEntryString() {
        return (String)this.next();
    }

    public File nextEntryFile() {
        this.next();
        return this.currentFile;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isJar(boolean bl) {
        if (this.currentEntry == null) {
            throw new IllegalStateException("Please invoke next() first");
        }
        return this.currentEntry.endsWith(".jar") && (!bl || bl && this.currentFile.exists());
    }

    public boolean isJar() {
        return this.isJar(false);
    }

    public boolean isDirectory(boolean bl) {
        if (this.currentEntry == null) {
            throw new IllegalStateException("Please invoke next() first");
        }
        return this.currentFile.isDirectory() && (!bl || bl && this.currentFile.exists());
    }

    public boolean isDirectory() {
        return this.isDirectory(false);
    }
}

