/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EnvironmentVariables {
    private static EnvironmentVariables instance;
    private Map env = new HashMap();
    private SimpleNameTransformer simpleNameTransformer;

    public EnvironmentVariables() {
        String[][] stringArray = this.getGenerator().getEnvironment();
        for (int i = 0; i < stringArray.length; ++i) {
            this.env.put(stringArray[i][0], stringArray[i][1]);
        }
        this.simpleNameTransformer = new SimpleNameTransformer();
    }

    protected String getEnv(String string, NameTransformer nameTransformer) {
        return (String)this.env.get(nameTransformer.transform(string));
    }

    public String getEnv(String string) {
        return this.getEnv(string, IdenticalNameTransformer.getInstance());
    }

    public String getEnvProperty(String string) {
        return this.getEnv(string, this.simpleNameTransformer);
    }

    public Set envNames() {
        return new HashSet(this.env.keySet());
    }

    public Set envPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.env.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(this.simpleNameTransformer.transform((String)iterator.next()));
        }
        return hashSet;
    }

    public Properties getAsProperties() {
        return this.getAsProperties(new Properties());
    }

    private Properties getAsProperties(Properties properties) {
        Iterator iterator = this.env.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            properties.put(this.simpleNameTransformer.transform(string), this.env.get(string));
        }
        return properties;
    }

    public void toSystemProperties() {
        this.getAsProperties(System.getProperties());
    }

    public static EnvironmentVariables getInstance() {
        if (instance == null) {
            instance = new EnvironmentVariables();
        }
        return instance;
    }

    private Generator getGenerator() throws UnsupportedOperationException {
        String string = System.getProperties().getProperty("os.name");
        if (string.startsWith("Windows")) {
            return new SetBasedGenerator("cmd /c set");
        }
        throw new UnsupportedOperationException("");
    }

    public class SimpleNameTransformer
    implements NameTransformer {
        private Map cachedNames = new HashMap();
        private String prefix;

        public SimpleNameTransformer(String string) {
            this.prefix = string;
        }

        public SimpleNameTransformer() {
            this("env");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String transform(String string) {
            StringBuffer stringBuffer;
            if (string.toUpperCase().equals(string)) {
                return this.transformAllUpperCase(string);
            }
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(this.prefix);
            synchronized (stringBuffer2) {
                boolean bl = false;
                char c = stringCharacterIterator.first();
                while (c != '\uffff') {
                    if (Character.isUpperCase(c)) {
                        if (!bl) {
                            stringBuffer.append("_");
                            bl = true;
                        } else {
                            bl = false;
                        }
                        stringBuffer.append(c);
                    }
                    c = stringCharacterIterator.next();
                }
                return this.transformAllUpperCase(stringBuffer.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String transformAllUpperCase(String string) {
            StringBuffer stringBuffer;
            String string2 = (String)this.cachedNames.get(string);
            if (string2 != null) {
                return string2;
            }
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(this.prefix);
            synchronized (stringBuffer2) {
                if (this.prefix.length() > 0) {
                    stringBuffer.append(".");
                }
                char c = stringCharacterIterator.first();
                while (c != '\uffff') {
                    if (c == '_') {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(".");
                        }
                    } else {
                        stringBuffer.append(Character.toLowerCase(c));
                    }
                    c = stringCharacterIterator.next();
                }
                string2 = stringBuffer.toString();
                this.cachedNames.put(string, string2);
                return string2;
            }
        }
    }

    private static class IdenticalNameTransformer
    implements NameTransformer {
        private static IdenticalNameTransformer instance = new IdenticalNameTransformer();

        private IdenticalNameTransformer() {
        }

        public static IdenticalNameTransformer getInstance() {
            return instance;
        }

        public String transform(String string) {
            return string;
        }
    }

    private class SetBasedGenerator
    implements Generator {
        private String cmd;

        public SetBasedGenerator(String string) {
            this.cmd = string;
        }

        public String[][] getEnvironment() {
            try {
                Process process = Runtime.getRuntime().exec(this.cmd);
                try {
                    String string;
                    int n;
                    InputStream inputStream = process.getInputStream();
                    StringWriter stringWriter = new StringWriter();
                    while ((n = inputStream.read()) != -1) {
                        stringWriter.write(n);
                    }
                    inputStream.close();
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    while ((string = bufferedReader.readLine()) != null) {
                        int n2 = string.indexOf("=");
                        if (n2 == -1) continue;
                        String[] stringArray = new String[2];
                        stringArray[0] = string.substring(0, n2);
                        if (string.length() == n2 + 1) continue;
                        stringArray[1] = string.substring(n2 + 1);
                        arrayList.add(stringArray);
                    }
                    String[][] stringArray = new String[arrayList.size()][2];
                    arrayList.toArray((T[])stringArray);
                    return stringArray;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Problem obtaining the result of the 'set' command");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("Impossible to run the 'set' command");
            }
        }
    }

    public static interface NameTransformer {
        public String transform(String var1);
    }

    public static interface Generator {
        public String[][] getEnvironment();
    }
}

