/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.sadun.util.PathNormalizer;
import org.sadun.util.PrefixProvider;

public class PrefixPrintWriter
extends PrintWriter {
    private static char[] ls = System.getProperty("line.separator").toCharArray();
    private PrefixProvider pp;
    private int truncatedNL = 0;
    private boolean start = true;
    private boolean autoFlush = true;
    public static final TimePrefixProvider TIME_PREFIXPROVIDER = new TimePrefixProvider();

    public PrefixPrintWriter(Writer writer, PrefixProvider prefixProvider) {
        super(writer, true);
        this.pp = prefixProvider;
    }

    public PrefixPrintWriter(Writer writer, String string) {
        this(writer, (PrefixProvider)new ConstantStringPrefixProvider(string));
    }

    public PrefixPrintWriter(OutputStream outputStream, PrefixProvider prefixProvider) {
        this((Writer)new OutputStreamWriter(outputStream), prefixProvider);
    }

    public PrefixPrintWriter(OutputStream outputStream, String string) {
        this((Writer)new OutputStreamWriter(outputStream), string);
    }

    public void write(int n) {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Writer writer = this.out;
        synchronized (writer) {
            int n3;
            String string = this.pp.getPrefix();
            if (this.start) {
                super.write(string, 0, string.length());
                this.start = false;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = this.truncatedNL;
            for (n3 = n; n3 < n + n2; ++n3) {
                if (!this.isNL(cArray, n3, n + n2)) continue;
                arrayList.add(new Integer(n3));
            }
            n3 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                super.write(cArray, n3, n5 - n3);
                super.write(ls, 0, ls.length);
                string = this.pp.getPrefix();
                super.write(string, 0, string.length());
                n3 = n5 + ls.length - n4;
                if (n4 == 0) continue;
                n4 = 0;
            }
            super.write(cArray, n3, n + n2 - n3);
            if (this.autoFlush) {
                super.flush();
            }
        }
    }

    private boolean isNL(char[] cArray, int n, int n2) {
        for (int i = this.truncatedNL; i < ls.length && i < n2; ++i) {
            if (cArray[n + i - this.truncatedNL] == ls[i]) continue;
            if (this.truncatedNL != 0) {
                this.truncatedNL = 0;
            }
            return false;
        }
        if (n2 - n + this.truncatedNL < ls.length) {
            this.truncatedNL = n2 - n;
            return false;
        }
        if (this.truncatedNL != 0) {
            this.truncatedNL = 0;
        }
        return true;
    }

    public void println() {
        super.println();
        this.start = true;
    }

    public static void main(String[] stringArray) throws Exception {
        PrefixPrintWriter prefixPrintWriter = new PrefixPrintWriter((OutputStream)System.out, ">");
        prefixPrintWriter.write(ls[0]);
        prefixPrintWriter.write(ls[1]);
        prefixPrintWriter.print("This is a test... ");
        prefixPrintWriter.println("Hello" + System.getProperty("line.separator") + "World");
    }

    private static class ConstantStringPrefixProvider
    implements PrefixProvider {
        private String s;

        public ConstantStringPrefixProvider(String string) {
            this.s = string;
        }

        public String getPrefix() {
            return this.s;
        }
    }

    public static final class DirectoryPrefixProvider
    implements PrefixProvider {
        private String tildeValue;

        public DirectoryPrefixProvider() {
            this(null);
        }

        public DirectoryPrefixProvider(File file) {
            if (file != null) {
                if (!file.isDirectory()) {
                    throw new RuntimeException("tilde value can only be a directory, or null");
                }
                this.tildeValue = PathNormalizer.normalize(file).getAbsolutePath();
            }
        }

        public String getPrefix() {
            String string = PathNormalizer.normalize(new File(".")).getAbsolutePath();
            if (this.tildeValue != null) {
                if (string.equals(this.tildeValue)) {
                    string = "~" + File.separator;
                } else if (string.startsWith(this.tildeValue)) {
                    string = "~" + File.separator + string.substring(this.tildeValue.length());
                }
            }
            return string;
        }
    }

    private static final class TimePrefixProvider
    implements PrefixProvider {
        private TimePrefixProvider() {
        }

        public String getPrefix() {
            return "[" + DateFormat.getDateTimeInstance().format(new Date()) + "] ";
        }
    }
}

