/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TelnetInputStream
extends FilterInputStream {
    private Object lock = new Object();
    public static final int IAC = 255;
    public static final int SE = 240;
    public static final int NOP = 241;
    public static final int DM = 242;
    public static final int BREAK = 243;
    public static final int IP = 244;
    public static final int AO = 245;
    public static final int AYT = 246;
    public static final int EC = 247;
    public static final int EL = 248;
    public static final int GA = 249;
    public static final int SB = 250;
    public static final int WILL = 251;
    public static final int WONT = 252;
    public static final int DO = 253;
    public static final int DONT = 254;
    private static final int OPTION_TRANSMIT_BINARY = 0;
    private static final int OPTION_ECHO = 1;
    private static final int OPTION_SUPPRESS_GO_AHEAD = 3;
    private static final int OPTION_STATUS = 5;
    private static final String[] optNames = new String[]{"TRANSMIT_BINARY", "ECHO", null, "SUPPRESS_GO_AHEAD", null, "STATUS"};
    private static final String[] cmdNames = new String[]{"IAC", "DONT", "DO", "WONT", "WILL", "SB", "GA", "EL", "EC", "AYT", "AO", "IP", "BREAK", "DM", "NOP", "SE"};
    private long cmdCount = 0L;
    private List cmdList = new LinkedList();
    private Set commandListeners = new HashSet();
    private boolean trimLinesEnabled = true;
    private PrintStream debugStream;

    public TelnetInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        if (n == 255) {
            int n2 = this.in.read();
            if (n2 == -1) {
                throw new IOException("Unterminated IAC telnet sequence");
            }
            switch (n2) {
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: {
                    this.commandFound(new TelnetCommand(this.cmdCount, n2));
                    break;
                }
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    int n3 = this.in.read();
                    if (n3 == -1) {
                        throw new IOException("Unterminated telnet option command sequence for command " + TelnetInputStream.getCommandName(n2) + "(" + n2 + ")");
                    }
                    this.commandFound(new TelnetCommand(this.cmdCount, n2, n3));
                    break;
                }
                default: {
                    throw new IOException("Unrecognized telnet command int: " + n2);
                }
            }
            ++this.cmdCount;
            return this.read();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandFound(TelnetCommand telnetCommand) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.debugStream != null) {
                this.debugStream.println(telnetCommand);
            }
            this.cmdList.add(telnetCommand);
            int n = -1;
            Iterator iterator = this.commandListeners.iterator();
            while (iterator.hasNext()) {
                TelnetCommandListener telnetCommandListener = (TelnetCommandListener)iterator.next();
                telnetCommandListener.telnetCommandReceived(this, telnetCommand);
            }
        }
    }

    public TelnetCommand[] getCommands() {
        TelnetCommand[] telnetCommandArray = new TelnetCommand[this.cmdList.size()];
        this.cmdList.toArray(telnetCommandArray);
        return telnetCommandArray;
    }

    public void commandHandled(TelnetCommand telnetCommand) {
        if (telnetCommand.getTIS() != this) {
            throw new RuntimeException("The command " + telnetCommand + " is not been issued over this TelnetInputStream");
        }
        this.cmdList.remove(telnetCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTelnetCommandListener(TelnetCommandListener telnetCommandListener) {
        Object object = this.lock;
        synchronized (object) {
            this.commandListeners.add(telnetCommandListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTelnetCommandListener(TelnetCommandListener telnetCommandListener) {
        Object object = this.lock;
        synchronized (object) {
            this.commandListeners.remove(telnetCommandListener);
        }
    }

    private static final String getCommandName(int n) {
        if (n > 255 || n < 240) {
            throw new IllegalArgumentException("Invalid command code " + n + " - range is 240-255 inclusive");
        }
        return cmdNames[255 - n];
    }

    public PrintStream getDebugStream() {
        return this.debugStream;
    }

    public void setDebugStream(PrintStream printStream) {
        this.debugStream = printStream;
    }

    public class TelnetCommand {
        private int code;
        private int option;
        private long sequenceNumber;

        TelnetCommand(long l, int n, int n2) {
            this.code = n;
            this.option = n2;
            this.sequenceNumber = l;
        }

        TelnetCommand(long l, int n) {
            this(l, n, -1);
        }

        public boolean hasOptionCode() {
            return this.option != -1;
        }

        public int getOptionCode() {
            if (!this.hasOptionCode()) {
                throw new IllegalStateException("The command " + TelnetInputStream.getCommandName(this.code) + " has not option code");
            }
            return this.option;
        }

        public int getCommandCode() {
            return this.code;
        }

        public String getCommandName() {
            return TelnetInputStream.getCommandName(this.code);
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return this.getCommandName() + " " + (this.hasOptionCode() ? "" + this.getOptionCode() : "") + " (seq# " + this.sequenceNumber + ")";
        }

        TelnetInputStream getTIS() {
            return TelnetInputStream.this;
        }
    }

    public static interface TelnetCommandListener {
        public void telnetCommandReceived(TelnetInputStream var1, TelnetCommand var2) throws IOException;
    }

    public static class BasicNVTListener
    implements TelnetCommandListener {
        protected OutputStream os;

        public BasicNVTListener(OutputStream outputStream) {
            this.os = outputStream;
        }

        public void telnetCommandReceived(TelnetInputStream telnetInputStream, TelnetCommand telnetCommand) throws IOException {
            if (telnetCommand.getCommandCode() == 253) {
                this.os.write(255);
                this.os.write(252);
                this.os.write(telnetCommand.getOptionCode());
                this.os.flush();
            } else if (telnetCommand.getCommandCode() == 251) {
                this.os.write(255);
                this.os.write(254);
                this.os.write(telnetCommand.getOptionCode());
                this.os.flush();
            }
            telnetInputStream.commandHandled(telnetCommand);
        }
    }
}

