/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.Random;
import org.sadun.util.ThreadDescriptor;

public class ThreadBlockRunner {
    private long sleepTime = 1000L;
    private ThreadDescriptor[] threadDescriptors;
    private int maxThreads;
    private static Random testRandom = new Random();
    private static Object lock = new Object();

    public ThreadBlockRunner(Thread[] threadArray, int n) {
        this.threadDescriptors = ThreadDescriptor.toDefaultDescriptorArray(threadArray);
        this.maxThreads = n;
        if (n < 1) {
            throw new IllegalArgumentException("Invalid maxThreads value:" + n);
        }
    }

    public ThreadBlockRunner(Thread[] threadArray) {
        this(threadArray, threadArray.length);
    }

    private int findThreadIndex(Thread thread) {
        for (int i = 0; i < this.threadDescriptors.length; ++i) {
            if (this.threadDescriptors[i].getThread() != thread) continue;
            return i;
        }
        throw new IllegalArgumentException("Programming error: thread " + thread.getName() + " is not controlled by the this ThreadBlockRunner object");
    }

    public void setSynchronizedWithPrevious(Thread thread, boolean bl) {
        this.setSynchronizedWithPrevious(this.findThreadIndex(thread), bl);
    }

    public boolean isSynchronizedWithPrevious(Thread thread) {
        return this.isSynchronizedWithPrevious(this.findThreadIndex(thread));
    }

    public void setSynchronizedWithPrevious(int n, boolean bl) {
        if (n < 0 || n >= this.threadDescriptors.length) {
            throw new IllegalArgumentException("Programming error: invalid thread index");
        }
        this.threadDescriptors[n].setSynchronizeWithPrevious(bl);
    }

    public boolean isSynchronizedWithPrevious(int n) {
        if (n < 0 || n >= this.threadDescriptors.length) {
            throw new IllegalArgumentException("Programming error: invalid thread index");
        }
        return this.threadDescriptors[n].isSynchronizeWithPrevious();
    }

    public void runAll() {
        this.runBlock(0, this.threadDescriptors.length);
    }

    public void runBlock(int n, int n2) {
        int n3;
        if (n < 0 || n2 > this.threadDescriptors.length || n > n2) {
            throw new IllegalArgumentException(this.threadDescriptors.length + " threads in the array. (" + n + "," + n2 + ") is an invalid range");
        }
        ThreadDescriptor[] threadDescriptorArray = new ThreadDescriptor[this.threadDescriptors.length];
        for (n3 = 0; n3 < threadDescriptorArray.length; ++n3) {
            threadDescriptorArray[n3] = (ThreadDescriptor)this.threadDescriptors[n3].clone();
        }
        n3 = 0;
        int n4 = 0;
        boolean[] blArray = new boolean[threadDescriptorArray.length];
        boolean[] blArray2 = new boolean[threadDescriptorArray.length];
        do {
            for (int i = n; i < n2; ++i) {
                if (threadDescriptorArray[i].getThread() == null) continue;
                if (i > n && threadDescriptorArray[i].isSynchronizeWithPrevious()) {
                    if (!blArray[i]) {
                        blArray[i] = true;
                        ++n4;
                    } else if (!blArray2[i] && blArray2[i - 1] && !this.threadDescriptors[i - 1].getThread().isAlive()) {
                        --n4;
                        threadDescriptorArray[i].getThread().start();
                        blArray2[i] = true;
                        ++n3;
                    }
                } else if (!blArray2[i]) {
                    blArray2[i] = true;
                    Thread thread = threadDescriptorArray[i].getThread();
                    thread.start();
                    ++n3;
                }
                if (n3 != this.maxThreads) continue;
                n3 = this.waitForOneToFinish(threadDescriptorArray, blArray2, n, i + 1);
            }
            if (n4 <= 0) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (n4 > 0);
        this.waitForAllFinished(n, n2);
    }

    private int waitForOneToFinish(ThreadDescriptor[] threadDescriptorArray, boolean[] blArray, int n, int n2) {
        int n3;
        int n4;
        do {
            n4 = 0;
            n3 = 0;
            for (int i = n; i < n2; ++i) {
                if (!blArray[i] || threadDescriptorArray[i].getThread() == null) continue;
                if (!threadDescriptorArray[i].getThread().isAlive()) {
                    threadDescriptorArray[i].setThread(null);
                    ++n4;
                    continue;
                }
                ++n3;
            }
            if (n4 != 0) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (n4 == 0);
        return n3;
    }

    private void waitForAllFinished(int n, int n2) {
        int n3;
        do {
            n3 = 0;
            for (int i = n; i < n2; ++i) {
                if (this.threadDescriptors[i].getThread() == null || !this.threadDescriptors[i].getThread().isAlive()) continue;
                ++n3;
            }
            if (n3 <= 0) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (n3 > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main2(String[] stringArray) {
        Thread[] threadArray = new Thread[3];
        Random random = new Random();
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new TestThread(i);
        }
        ThreadBlockRunner threadBlockRunner = new ThreadBlockRunner(threadArray, 3);
        for (int i = 0; i < threadArray.length; ++i) {
            if (i != 1) continue;
            threadBlockRunner.setSynchronizedWithPrevious(i, true);
        }
        threadBlockRunner.runBlock(0, 3);
        Object object = lock;
        synchronized (object) {
            System.out.println("********************");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Thread[] threadArray = new Thread[10];
        Random random = new Random();
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new TestThread(i);
        }
        ThreadBlockRunner threadBlockRunner = new ThreadBlockRunner(threadArray, 3);
        for (int i = 0; i < threadArray.length; ++i) {
            if (i <= 0 || !random.nextBoolean()) continue;
            System.out.println("thread " + i + " waits for previous one to finish");
            threadBlockRunner.setSynchronizedWithPrevious(i, true);
        }
        threadBlockRunner.runBlock(0, 6);
        Object object = lock;
        synchronized (object) {
            System.out.println("********************");
        }
        threadBlockRunner.runBlock(6, threadArray.length);
    }

    private static class TestThread
    extends Thread {
        int count;

        TestThread(int n) {
            super("thread-" + n);
            this.count = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = 20L;
            if (this.count % 2 == 0) {
                l = 1000L;
            }
            Object object = lock;
            synchronized (object) {
                System.out.println(this.getName() + " started");
                System.out.flush();
            }
            try {
                TestThread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            object = lock;
            synchronized (object) {
                System.out.println(this.getName() + " finished");
                System.out.println(this.getName() + " -------------------");
                System.out.flush();
            }
        }
    }
}

