/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.connection;

import java.io.StringWriter;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.sadun.util.DynamicClassLoader;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.ObjectLister;

public class SQLContext {
    private DynamicClassLoader dcl;
    private String classPath;
    private String[] jdbcDriverNames;
    private Set loadedJdbcDrivers;
    private Set failedToLoadJdbcDrivers;

    public SQLContext(String string, String[] stringArray) {
        this.classPath = string;
        this.jdbcDriverNames = stringArray;
        this.setClassPath(string);
    }

    public void setJdbcDriverNames(String[] stringArray) {
        this.jdbcDriverNames = stringArray;
        this.loadedJdbcDrivers = new HashSet();
        this.failedToLoadJdbcDrivers = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                System.out.print("Loading " + stringArray[i] + ": ");
                DriverManager.registerDriver((Driver)this.dcl.loadClass(stringArray[i]).newInstance());
                this.loadedJdbcDrivers.add(stringArray[i]);
                System.out.println("ok.");
                continue;
            }
            catch (Exception exception) {
                this.failedToLoadJdbcDrivers.add(stringArray[i]);
                System.out.println("failed.");
            }
        }
    }

    public SQLContext(String[] stringArray) {
        this(System.getProperty("java.class.path"), stringArray);
    }

    public SQLContext(String string) {
        this(SQLContext.split(string, ":,; "));
    }

    public SQLContext() {
        this(System.getProperty("jdbc.drivers"));
    }

    private static String[] split(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        indentedPrintWriter.print("SQL Context, classpath: ");
        indentedPrintWriter.println(this.classPath);
        indentedPrintWriter.println();
        indentedPrintWriter.print(this.jdbcDriverNames.length + " JDBC Drivers registered");
        if (this.jdbcDriverNames.length > 0) {
            indentedPrintWriter.print(":");
        }
        indentedPrintWriter.println();
        indentedPrintWriter.incIndentation(3);
        for (int i = 0; i < this.jdbcDriverNames.length; ++i) {
            indentedPrintWriter.print(this.jdbcDriverNames[i]);
            indentedPrintWriter.print(" (");
            if (this.loadedJdbcDrivers.contains(this.jdbcDriverNames[i])) {
                indentedPrintWriter.print("loaded");
            } else {
                indentedPrintWriter.print("failed");
            }
            indentedPrintWriter.println(")");
        }
        return stringWriter.toString();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String string) {
        this.classPath = string;
        this.dcl = new DynamicClassLoader();
        this.dcl.setClassPath(string);
        this.setJdbcDriverNames(this.jdbcDriverNames);
    }

    public String[] getFailedToLoadJdbcDrivers() {
        String[] stringArray = new String[this.failedToLoadJdbcDrivers.size()];
        this.failedToLoadJdbcDrivers.toArray(stringArray);
        return stringArray;
    }

    public String[] getJdbcDriverNames() {
        return this.jdbcDriverNames;
    }

    public String[] getLoadedJdbcDrivers() {
        String[] stringArray = new String[this.loadedJdbcDrivers.size()];
        this.loadedJdbcDrivers.toArray(stringArray);
        return stringArray;
    }

    public static void main(String[] stringArray) {
        System.out.println(new SQLContext("com.microsoft.jdbc.sqlserver.SQLServerDriver"));
    }

    public String getJdbcDriverNamesAsString() {
        String string = new ObjectLister(":", '\u0000').list(this.jdbcDriverNames);
        return string;
    }
}

