/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.sadun.util.pool2.ActivationException;
import org.sadun.util.pool2.ObjectPool;
import org.sadun.util.pool2.PassivationException;
import org.sadun.util.pool2.PooledObject;

public abstract class BasePooledObject
implements PooledObject {
    private static Random random = new Random();
    private Object original;
    private boolean passivated;
    private boolean originalAcquired;
    private Object passivationLock = new Object();
    private ObjectPool objectPool;
    private File serializedFile;

    protected BasePooledObject(ObjectPool objectPool, Object object) {
        this.objectPool = objectPool;
        this.original = object;
        this.passivated = false;
        this.originalAcquired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object _getOriginal() throws ActivationException {
        Object object = this.passivationLock;
        synchronized (object) {
            if (this.original == null) {
                this._activate();
            }
            this.originalAcquired = true;
        }
        return this.original;
    }

    public final void _releaseOriginal() {
        this.originalAcquired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void _activate() throws ActivationException {
        Object object = this.passivationLock;
        synchronized (object) {
            if (!this.passivated) {
                return;
            }
            if (this.objectPool.getLogStream() != null) {
                this.objectPool.getLogStream().println("Activating passivated object from " + this.serializedFile);
            }
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    try {
                        objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.serializedFile)));
                    }
                    catch (IOException iOException) {
                        throw new ActivationException("Could not open passivated file " + this.serializedFile, iOException);
                    }
                    this.original = objectInputStream.readObject();
                    this.serializedFile = null;
                    this.passivated = false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ActivationException("Could not find the class with which the pooled object has been serialized", classNotFoundException);
                }
                catch (IOException iOException) {
                    throw new ActivationException("Could not read the serialized object from file " + this.serializedFile, iOException);
                }
                Object var5_6 = null;
                if (objectInputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (objectInputStream == null) throw throwable;
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ActivationException("Could not close the serialized object file " + this.serializedFile, iOException);
                }
            }
            try {}
            catch (IOException iOException) {
                throw new ActivationException("Could not close the serialized object file " + this.serializedFile, iOException);
            }
            objectInputStream.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void _passivate() throws PassivationException {
        Object object = this.passivationLock;
        synchronized (object) {
            if (this.passivated) {
                throw new PassivationException("Already passivated");
            }
            if (!this.objectPool.getPassivationManager().canPassivate(this.original.getClass())) {
                throw new PassivationException("Object " + this.original.toString() + " is intrinsecally not passivable");
            }
            if (this.originalAcquired) {
                throw new PassivationException("Original object acquired");
            }
            File file = new File(this.objectPool.getConfiguration().getStorageDirectory(), this.original.getClass().getName());
            if (!file.exists() && !file.mkdirs()) {
                throw new PassivationException("Cannot create passivation directory " + file);
            }
            this.serializedFile = new File(file, this.mkTmpFileName(this.original));
            if (this.objectPool.getLogStream() != null) {
                this.objectPool.getLogStream().println("Passivating " + this + " to " + this.serializedFile);
            }
            ObjectOutputStream objectOutputStream = null;
            try {
                try {
                    try {
                        objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.serializedFile)));
                    }
                    catch (IOException iOException) {
                        throw new PassivationException("Could not create file for passivated object", iOException);
                    }
                    objectOutputStream.writeObject(this.original);
                    this.original = null;
                    this.passivated = true;
                }
                catch (NotSerializableException notSerializableException) {
                    throw new PassivationException("The pooled object is not Serializable", notSerializableException);
                }
                catch (IOException iOException) {
                    throw new PassivationException("Could not write passivated object to file", iOException);
                }
                Object var6_7 = null;
                if (objectOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (objectOutputStream == null) throw throwable;
                try {
                    objectOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new PassivationException("Could not close passivated object file", iOException);
                }
            }
            try {}
            catch (IOException iOException) {
                throw new PassivationException("Could not close passivated object file", iOException);
            }
            objectOutputStream.close();
            return;
        }
    }

    private String mkTmpFileName(Object object) {
        return System.currentTimeMillis() + "_" + object.getClass().getName() + random.nextInt(1000);
    }

    public boolean _isPassivableNow() {
        return this._isPassivable() && !this.passivated && !this.originalAcquired;
    }

    public boolean _isPassivable() {
        return this.objectPool.getPassivationManager().canPassivate(this.objectPool.getObjectType());
    }

    public boolean _isPassivated() {
        return this.passivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getSerializedFile() {
        Object object = this.passivationLock;
        synchronized (object) {
            return this.serializedFile;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Pooled ");
        stringBuffer.append(this.objectPool.getObjectType().getName());
        stringBuffer.append(" object");
        if (this.passivated) {
            stringBuffer.append("(passivated)");
        } else {
            if (this.original != null) {
                stringBuffer.append(" [");
                stringBuffer.append(this.original.toString());
                stringBuffer.append("] ");
            }
            if (this._isPassivable()) {
                stringBuffer.append("(active)");
            } else {
                stringBuffer.append("(not passivable)");
            }
        }
        return stringBuffer.toString();
    }

    protected Object getOriginal() {
        return this.original;
    }

    public final ObjectPool getObjectPool() {
        return this.objectPool;
    }

    final void setObjectPool(ObjectPool objectPool) {
        if (this.objectPool != null) {
            throw new IllegalStateException("Object pool can be set only once");
        }
        this.objectPool = objectPool;
    }
}

