/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.util.HashMap;
import java.util.Map;
import org.sadun.util.pool2.BasePassivationManager;
import org.sadun.util.pool2.ObjectPool;
import org.sadun.util.pool2.PooledObject;

public class DefaultPassivationManager
extends BasePassivationManager {
    private static DefaultPassivationManager instance;
    private static long defaultPassivationThreshold;
    private Map statesMap = new HashMap();
    private long passivationThreshold;

    public DefaultPassivationManager() {
        super("Default passivation thread");
        this.commonInit();
    }

    public DefaultPassivationManager(String string) {
        super(string);
        this.commonInit();
    }

    public DefaultPassivationManager(String string, int n) {
        super(string, n);
        this.commonInit();
    }

    public DefaultPassivationManager(ObjectPool objectPool, String string, int n) {
        super(objectPool, string, n);
        this.commonInit();
    }

    private void commonInit() {
        this.passivationThreshold = DefaultPassivationManager.getDefaultPassivationThreshold();
    }

    protected void createState(ObjectPool objectPool, PooledObject pooledObject) {
        HashMap<PooledObject, PooledObjectState> hashMap = (HashMap<PooledObject, PooledObjectState>)this.statesMap.get(objectPool);
        if (hashMap == null) {
            hashMap = new HashMap<PooledObject, PooledObjectState>();
            this.statesMap.put(objectPool, hashMap);
        }
        hashMap.put(pooledObject, new PooledObjectState(objectPool.isAcquired(pooledObject), System.currentTimeMillis()));
    }

    protected void removeState(ObjectPool objectPool, PooledObject pooledObject) {
        Map map = (Map)this.statesMap.get(objectPool);
        if (map == null) {
            return;
        }
        map.remove(pooledObject);
    }

    protected void handleInvoked(ObjectPool objectPool, PooledObject pooledObject) {
        PooledObjectState pooledObjectState = (PooledObjectState)((Map)this.statesMap.get(objectPool)).get(pooledObject);
        pooledObjectState.lastAccessed = System.currentTimeMillis();
    }

    protected boolean isToPassivate(ObjectPool objectPool, PooledObject pooledObject, Object object) {
        PooledObjectState pooledObjectState = (PooledObjectState)((Map)this.statesMap.get(objectPool)).get(pooledObject);
        long l = System.currentTimeMillis();
        if (l - pooledObjectState.lastAccessed > this.passivationThreshold) {
            return true;
        }
        if (objectPool.getLogStream() != null) {
            objectPool.getLogStream().println(pooledObject + " accessed " + (l - pooledObjectState.lastAccessed) + "ms ago, not to passivate");
        }
        return false;
    }

    protected void handleAcquired(ObjectPool objectPool, PooledObject pooledObject) {
    }

    protected void handleReleased(ObjectPool objectPool, PooledObject pooledObject) {
    }

    protected Object prepareForPassivationCheck(ObjectPool objectPool) {
        return null;
    }

    public static DefaultPassivationManager getInstance() {
        if (instance == null) {
            instance = new DefaultPassivationManager();
        }
        return instance;
    }

    public long getPassivationThreshold() {
        return this.passivationThreshold;
    }

    public void setPassivationThreshold(long l) {
        this.passivationThreshold = l;
    }

    public static long getDefaultPassivationThreshold() {
        return defaultPassivationThreshold;
    }

    public static void setDefaultPassivationThreshold(long l) {
        defaultPassivationThreshold = l;
    }

    static {
        defaultPassivationThreshold = 36000L;
    }

    private class PooledObjectState {
        private long inserted;
        private long lastAccessed;

        public PooledObjectState(boolean bl, long l) {
            this.inserted = l;
            this.lastAccessed = l;
        }
    }
}

