/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.sql;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sadun.util.PrintStringWriter;
import org.sadun.util.sql.ResultSetPrinter;

public class PlainResultSetPrinter
implements ResultSetPrinter {
    private ResultSet rs;
    private String[] captions;
    private boolean[] disabled;
    private PrintStream out = System.out;

    public PlainResultSetPrinter(ResultSet resultSet) throws SQLException {
        this.rs = resultSet;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.captions = new String[resultSetMetaData.getColumnCount()];
        this.disabled = new boolean[this.captions.length];
        for (int i = 0; i < this.captions.length; ++i) {
            this.captions[i] = resultSetMetaData.getColumnName(i + 1);
        }
    }

    public void printAll() throws SQLException {
        this.printCaptions();
        while (this.rs.next()) {
            this.printNextRow();
        }
    }

    public void printCaptions() {
        int n;
        PrintStringWriter printStringWriter = new PrintStringWriter();
        for (n = 0; n < this.captions.length; ++n) {
            if (this.disabled[n]) continue;
            if (printStringWriter.length() > 0) {
                printStringWriter.print(" ");
            }
            printStringWriter.print(this.captions[n]);
        }
        this.out.println(printStringWriter.toString());
        for (n = 0; n < this.captions.length; ++n) {
            if (this.disabled[n]) continue;
            if (printStringWriter.length() > 0) {
                printStringWriter.print(" ");
            }
            printStringWriter.print(this.pad(this.captions[n].length()));
        }
    }

    private String pad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public void printNextRow() throws SQLException {
        PrintStringWriter printStringWriter = new PrintStringWriter();
        for (int i = 0; i < this.captions.length; ++i) {
            if (this.disabled[i]) continue;
            if (printStringWriter.length() > 0) {
                printStringWriter.print(" ");
            }
            printStringWriter.print(this.rs.getObject(i + 1));
        }
        this.out.println(printStringWriter.toString());
    }
}

