/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.xml.configuration;

import org.sadun.util.xml.configuration.Configurator;
import org.sadun.util.xml.configuration.DispatcherHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseConfigurator
extends DefaultHandler
implements Configurator {
    protected StringBuffer buffer = new StringBuffer();
    protected boolean completed = false;

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.completed = true;
    }

    public final Object getConfiguredObject() throws SAXException {
        this.checkCompleted();
        return this.doGetConfiguredObject();
    }

    protected void checkCompleted() {
        if (!this.completed) {
            throw new IllegalStateException("The object(s) under configuration are not completed yet (possibly endElement has been overriden without invoking its super implementation)");
        }
    }

    protected abstract Object doGetConfiguredObject() throws SAXException;

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public final String getText() {
        return this.buffer.toString();
    }

    public final String getTextAndResetBuffer() {
        return this.getTextAndResetBuffer(true);
    }

    public final String getTextAndResetBuffer(boolean bl) {
        String string = this.buffer.toString();
        if (bl) {
            string = string.trim();
        }
        this.buffer.delete(0, this.buffer.length());
        return string;
    }

    public String toString() {
        return DispatcherHandler.baseName(this.getClass().getName());
    }

    protected boolean getBooleanText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        if ("true".equals(string2) || "yes".equals(string2)) {
            return true;
        }
        if ("false".equals(string2) || "no".equals(string2)) {
            return false;
        }
        throw new SAXException("Invalid value for element " + string + " (boolean expected, found '" + string2 + "')");
    }

    protected short getShortText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (short expected, found '" + string2 + "')");
        }
    }

    protected int getIntText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (int expected, found '" + string2 + "')");
        }
    }

    protected long getLongText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (long expected, found '" + string2 + "')");
        }
    }

    protected byte getByteText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (byte expected, found '" + string2 + "')");
        }
    }

    protected float getFloatText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (float expected, found '" + string2 + "')");
        }
    }

    protected double getDoubleText(String string) throws SAXException {
        String string2 = this.getTextAndResetBuffer().trim();
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Invalid value for element " + string + " (double expected, found '" + string2 + "')");
        }
    }
}

