/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.gif;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.gif.GIFColorTable;
import com.sun.jimi.core.decoder.gif.GIFFileHeader;
import com.sun.jimi.core.decoder.gif.GIFGraphicExt;
import com.sun.jimi.core.decoder.gif.GIFImageDescriptor;
import com.sun.jimi.core.options.GIFOptions;
import com.sun.jimi.core.util.LEDataInputStream;
import com.sun.jimi.core.util.lzw.LZWDecompressor;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;

public class GIFDecoder
extends JimiDecoderBase {
    static final byte IMAGE_SEPERATOR = 44;
    static final byte EXTENSION_INTRODUCER = 33;
    static final byte GRAPHIC_CONTROL_EXTENSION = -7;
    static final byte COMMENT_EXTENSION = -2;
    static final byte APPLICATION_EXTENSION = -1;
    static final byte PLAINTEXT_EXTENSION = 1;
    static final byte TRAILER = 59;
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream dIn_;
    private volatile int state_;
    GIFFileHeader gifFH_;
    GIFGraphicExt gifGraphicExt_;
    protected int numberOfLoops_ = 1;
    boolean gotPrevImageSeperator_;
    String comment_;
    AdaptiveRasterImage baseJI_;
    GIFImageDescriptor imageDescriptor_;
    int disposal_ = 0;
    int xOffset_ = 0;
    int yOffset_ = 0;
    int dWidth_ = 0;
    int dHeight_ = 0;
    byte[] prevSaved_;
    int imageDelay_ = 0;

    void addImageDelta(GIFImageDescriptor gIFImageDescriptor, AdaptiveRasterImage adaptiveRasterImage, AdaptiveRasterImage adaptiveRasterImage2) throws JimiException {
        boolean bl;
        this.setOptions(adaptiveRasterImage2);
        boolean bl2 = bl = this.baseJI_ == null;
        if (this.baseJI_ == null) {
            this.baseJI_ = this.createAdaptiveRasterImage(this.gifFH_.screenWidth, this.gifFH_.screenHeight, adaptiveRasterImage.getColorModel());
            this.setOptions(this.baseJI_);
            this.baseJI_.setPixels();
            if ((this.gifFH_.packed & 0x80) != 0) {
                this.baseJI_.setChannel(this.gifFH_.backgroundColor);
            }
            this.baseJI_.addFullCoverage();
        }
        this.disposePreviousDelta();
        if (this.gifGraphicExt_ != null) {
            this.disposal_ = (this.gifGraphicExt_.packed & 0x1C) >> 2;
            this.imageDelay_ = this.gifGraphicExt_.delayTime;
        }
        this.xOffset_ = gIFImageDescriptor.left;
        this.yOffset_ = gIFImageDescriptor.top;
        this.dWidth_ = gIFImageDescriptor.width;
        this.dHeight_ = gIFImageDescriptor.height;
        this.saveForNextDelta();
        byte[] byArray = new byte[this.dWidth_];
        int n = this.yOffset_;
        int n2 = 0;
        while (n2 < this.dHeight_) {
            adaptiveRasterImage.getChannel(0, n2, byArray, 0);
            if (bl || this.gifGraphicExt_ == null || (this.gifGraphicExt_.packed & 1) == 0) {
                this.baseJI_.setChannel(0, this.xOffset_, n, this.dWidth_, 1, byArray, 0, 0);
            } else {
                int n3 = this.gifGraphicExt_.colorIndex;
                int n4 = 0;
                boolean bl3 = false;
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (byArray[n5] == n3 || n5 == byArray.length - 1) {
                        if (bl3) {
                            this.baseJI_.setChannel(0, this.xOffset_ + n4, n, n5 - n4, 1, byArray, n4, 0);
                            bl3 = false;
                        }
                    } else if (!bl3) {
                        n4 = n5;
                        bl3 = true;
                    }
                    ++n5;
                }
            }
            ++n;
            ++n2;
        }
        this.baseJI_.setColorModel(adaptiveRasterImage.getColorModel());
        if (this.comment_ != null) {
            this.comment_ = null;
        }
        byArray = new byte[this.baseJI_.getWidth()];
        adaptiveRasterImage2.setSize(this.baseJI_.getWidth(), this.baseJI_.getHeight());
        adaptiveRasterImage2.setColorModel(this.baseJI_.getColorModel());
        this.setOptions(adaptiveRasterImage2);
        adaptiveRasterImage2.setPixels();
        int n6 = 0;
        while (n6 < this.baseJI_.getHeight()) {
            this.baseJI_.getChannel(0, n6, byArray, 0);
            adaptiveRasterImage2.setChannel(0, n6, byArray);
            ++n6;
        }
    }

    private void decodeImage(LEDataInputStream lEDataInputStream, GIFImageDescriptor gIFImageDescriptor, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        int n = gIFImageDescriptor.height;
        byte by = lEDataInputStream.readByte();
        LZWDecompressor lZWDecompressor = new LZWDecompressor(lEDataInputStream, by, false);
        byte[] byArray = new byte[gIFImageDescriptor.width];
        int n2 = 0;
        if (gIFImageDescriptor.interlace) {
            adaptiveRasterImage.setHints(22);
            int n3 = 0;
            while (n3 < n) {
                lZWDecompressor.decompress(byArray);
                adaptiveRasterImage.setChannel(0, n3, byArray);
                this.setProgress(n2++ * 100 / gIFImageDescriptor.height);
                n3 += 8;
            }
            n3 = 4;
            while (n3 < n) {
                lZWDecompressor.decompress(byArray);
                adaptiveRasterImage.setChannel(0, n3, byArray);
                this.setProgress(n2++ * 100 / gIFImageDescriptor.height);
                n3 += 8;
            }
            n3 = 2;
            while (n3 < n) {
                lZWDecompressor.decompress(byArray);
                adaptiveRasterImage.setChannel(0, n3, byArray);
                this.setProgress(n2++ * 100 / gIFImageDescriptor.height);
                n3 += 4;
            }
            n3 = 1;
            while (n3 < n) {
                lZWDecompressor.decompress(byArray);
                adaptiveRasterImage.setChannel(0, n3, byArray);
                this.setProgress(n2++ * 100 / gIFImageDescriptor.height);
                n3 += 2;
            }
            this.setProgress(100);
        } else {
            int n4 = 0;
            while (n4 < n) {
                lZWDecompressor.decompress(byArray);
                adaptiveRasterImage.setChannel(0, n4, byArray);
                this.setProgress(n4 * 100 / n);
                ++n4;
            }
        }
        lZWDecompressor.gifFinishBlocks();
    }

    void disposePreviousDelta() throws JimiException {
        switch (this.disposal_) {
            case 2: {
                int n;
                byte[] byArray = new byte[this.dWidth_];
                if (this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0) {
                    n = 0;
                    while (n < byArray.length) {
                        byArray[n] = (byte)this.gifGraphicExt_.colorIndex;
                        ++n;
                    }
                }
                if ((this.gifFH_.packed & 0x80) != 0) {
                    if (this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0) {
                        n = 0;
                        while (n < byArray.length) {
                            byArray[n] = (byte)this.gifGraphicExt_.colorIndex;
                            ++n;
                        }
                    } else {
                        n = this.dWidth_;
                        while (--n >= 0) {
                            byArray[n] = this.gifFH_.backgroundColor;
                        }
                    }
                }
                int n2 = this.yOffset_;
                while (n2 < this.yOffset_ + this.dHeight_) {
                    this.baseJI_.setChannel(0, this.xOffset_, n2, this.dWidth_, 1, byArray, 0, 0);
                    ++n2;
                }
                break;
            }
            case 3: {
                if (this.prevSaved_ == null) {
                    throw new RuntimeException("Internal GIFDecoder Error");
                }
                this.baseJI_.setChannel(0, this.xOffset_, this.yOffset_, this.dWidth_, this.dHeight_, this.prevSaved_, 0, this.dWidth_);
                break;
            }
        }
    }

    public synchronized boolean driveDecoder() throws JimiException {
        try {
            if (this.gifFH_ == null) {
                this.gifFH_ = new GIFFileHeader(this.dIn_);
            }
            this.getNextImage(this.dIn_, this.ji_);
            this.ji_.addFullCoverage();
            this.state_ |= 6;
        }
        catch (IOException iOException) {
            this.state_ &= 0xFFFFFFF7;
            throw new JimiException(iOException.getMessage());
        }
        catch (JimiException jimiException) {
            this.state_ &= 0xFFFFFFF7;
            throw new JimiException(jimiException.getMessage());
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.dIn_ = null;
        this.ji_ = null;
    }

    public int getCapabilities() {
        return 1;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    /*
     * Unable to fully structure code
     */
    public void getNextImage(LEDataInputStream var1_1, AdaptiveRasterImage var2_2) throws JimiException, IOException {
        var4_3 = false;
        var5_4 = this.createAdaptiveRasterImage();
        block10: while (true) {
            var3_5 = this.gotPrevImageSeperator_ != false ? 44 : (int)var1_1.readByte();
            switch (var3_5) {
                default: {
                    continue block10;
                }
                case 44: {
                    if (var4_3) {
                        this.gotPrevImageSeperator_ = true;
                        return;
                    }
                    this.imageDescriptor_ = var7_7 = new GIFImageDescriptor(var1_1);
                    this.initJimiImage(var7_7, var5_4);
                    this.decodeImage(var1_1, var7_7, var5_4);
                    var5_4.addFullCoverage();
                    this.addImageDelta(var7_7, var5_4, this.ji_);
                    this.gifGraphicExt_ = null;
                    var4_3 = true;
                    this.gotPrevImageSeperator_ = false;
                    continue block10;
                }
                case 59: {
                    this.state_ &= -9;
                    this.gotPrevImageSeperator_ = false;
                    this.gifGraphicExt_ = null;
                    return;
                }
                case 33: 
            }
            var3_5 = this.dIn_.readByte();
            switch (var3_5) {
                default: {
                    continue block10;
                }
                case -1: 
                case 1: {
                    var8_8 = var1_1.readByte();
                    var9_9 = new byte[var8_8];
                    var1_1.readFully(var9_9);
                    var10_10 = new String(var9_9);
                    if (var10_10.equals("NETSCAPE2.0")) {
                        var11_11 = var1_1.read();
                        var12_13 = new byte[var11_11];
                        var13_14 = 0;
                        while (var13_14 < var12_13.length) {
                            var12_13[var13_14] = (byte)var1_1.read();
                            ++var13_14;
                        }
                        if (var11_11 == 3 && var12_13[0] == 1) {
                            this.numberOfLoops_ = (var12_13[2] & 255) << 8;
                            this.numberOfLoops_ |= var12_13[1] & 255;
                            if (this.numberOfLoops_ != 0) {
                                ++this.numberOfLoops_;
                            }
                        }
                    }
                    while (true) {
                        if ((var6_6 = var1_1.readUnsignedByte()) == 0) continue block10;
                        var1_1.skip(var6_6);
                    }
                }
                case -2: {
                    if (this.comment_ != null) ** GOTO lbl64
                    while (true) {
                        if ((var6_6 = var1_1.readUnsignedByte()) == 0) continue block10;
                        var11_12 = new byte[var6_6];
                        var1_1.readFully(var11_12);
                        this.comment_ = String.valueOf(this.comment_) + new String(var11_12, 0);
                    }
lbl-1000:
                    // 1 sources

                    {
                        var1_1.skip(var6_6);
lbl64:
                        // 2 sources

                        ** while ((var6_6 = var1_1.readUnsignedByte()) != 0)
                    }
lbl65:
                    // 1 sources

                    continue block10;
                }
                case -7: 
            }
            this.gifGraphicExt_ = new GIFGraphicExt(var1_1);
        }
    }

    public int getNumberOfImages() {
        return -1;
    }

    public int getState() {
        return this.state_;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in_ = inputStream;
        this.dIn_ = new LEDataInputStream(inputStream);
        this.ji_ = adaptiveRasterImage;
        this.state_ = 8;
        this.gifFH_ = null;
        this.gifGraphicExt_ = null;
        this.gotPrevImageSeperator_ = false;
        this.baseJI_ = null;
    }

    private void initJimiImage(GIFImageDescriptor gIFImageDescriptor, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        GIFColorTable gIFColorTable;
        if ((gIFImageDescriptor.packed & 0x80) != 0) {
            gIFColorTable = gIFImageDescriptor.colorTable;
            int n = gIFImageDescriptor.colorTableNumBits;
        } else {
            gIFColorTable = this.gifFH_.colorTable;
            int n = this.gifFH_.colorTableNumBits;
        }
        IndexColorModel indexColorModel = this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0 ? new IndexColorModel(8, gIFColorTable.red.length, gIFColorTable.red, gIFColorTable.green, gIFColorTable.blue, this.gifGraphicExt_.colorIndex) : new IndexColorModel(8, gIFColorTable.red.length, gIFColorTable.red, gIFColorTable.green, gIFColorTable.blue);
        adaptiveRasterImage.setColorModel(indexColorModel);
        adaptiveRasterImage.setSize(gIFImageDescriptor.width, gIFImageDescriptor.height);
        this.setOptions(adaptiveRasterImage);
        adaptiveRasterImage.setPixels();
    }

    public boolean mustWaitForOptions() {
        return true;
    }

    void saveForNextDelta() throws JimiException {
        switch (this.disposal_) {
            case 3: {
                this.prevSaved_ = new byte[this.dWidth_ * this.dHeight_];
                int n = 0;
                byte[] byArray = new byte[this.baseJI_.getWidth()];
                int n2 = this.yOffset_;
                while (n2 < this.yOffset_ + this.dHeight_) {
                    this.baseJI_.getChannel(0, n2, byArray, 0);
                    System.arraycopy(byArray, this.xOffset_, this.prevSaved_, n, this.dWidth_);
                    n += this.dWidth_;
                    ++n2;
                }
                break;
            }
        }
    }

    public void setJimiImage(AdaptiveRasterImage adaptiveRasterImage) {
        this.ji_ = adaptiveRasterImage;
    }

    void setOptions(AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        GIFOptions gIFOptions = new GIFOptions();
        gIFOptions.setInterlaced(this.imageDescriptor_.interlace);
        gIFOptions.setNumberOfLoops(this.numberOfLoops_);
        if (this.gifGraphicExt_ != null) {
            gIFOptions.setFrameDelay(this.gifGraphicExt_.delayTime);
            if ((this.gifGraphicExt_.packed & 1) != 0) {
                gIFOptions.setTransparentIndex(this.gifGraphicExt_.colorIndex);
            }
            if ((this.imageDescriptor_.packed & 0x80) != 0) {
                gIFOptions.setUseLocalPalettes(true);
            }
        }
        adaptiveRasterImage.setOptions(gIFOptions);
    }

    public void skipImage() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.createAdaptiveRasterImage();
        try {
            if (this.gifFH_ == null) {
                this.gifFH_ = new GIFFileHeader(this.dIn_);
            }
            this.getNextImage(this.dIn_, adaptiveRasterImage);
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

