/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.core.encoder.png.png_chunk_ihdr;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;

class PNGWrite
implements PNGConstants {
    AdaptiveRasterImage ji;
    png_chunk_ihdr ihdr;
    byte filtering;
    Deflater compress;
    byte[] zbuf;
    int zbufO;
    byte[] scanLine;
    byte[] filter_ = new byte[1];
    byte[] prevScanLine;
    PNGChunkUtil pcu;
    byte[] packedBuf_ = null;
    boolean zeroIsWhite_;
    PNGEncoder encoder;

    PNGWrite(AdaptiveRasterImage adaptiveRasterImage, png_chunk_ihdr png_chunk_ihdr2, int n, PNGChunkUtil pNGChunkUtil, PNGEncoder pNGEncoder) {
        this.ji = adaptiveRasterImage;
        this.ihdr = png_chunk_ihdr2;
        this.pcu = pNGChunkUtil;
        this.filtering = pNGEncoder.getFilter();
        this.encoder = pNGEncoder;
        this.compress = new Deflater();
        this.zbuf = new byte[n];
        this.compress.setStrategy(0);
        this.compress.setLevel(pNGEncoder.getCompression());
        if (png_chunk_ihdr2.colorType == 2) {
            this.scanLine = new byte[adaptiveRasterImage.getWidth() * 3];
        } else if (png_chunk_ihdr2.colorType == 6) {
            this.scanLine = new byte[adaptiveRasterImage.getWidth() * 4];
        } else if (png_chunk_ihdr2.colorType == 0 || png_chunk_ihdr2.colorType == 3) {
            this.scanLine = new byte[adaptiveRasterImage.getWidth()];
        }
        this.prevScanLine = new byte[this.scanLine.length];
        this.zeroIsWhite_ = false;
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
    }

    void png_write_iend(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = new byte[1];
        this.pcu.write(dataOutputStream, PNGConstants.png_IEND, byArray, 0);
    }

    void png_write_sbit(DataOutputStream dataOutputStream) throws IOException {
        ColorModel colorModel = this.ji.getColorModel();
        if (!(this.ihdr.colorType != 2 && this.ihdr.colorType != 6 || JimiUtil.isRGBDefault(colorModel))) {
            byte[] byArray = JimiUtil.getChannelWidths(colorModel);
            byte[] byArray2 = new byte[4];
            byArray2[0] = byArray[1];
            byArray2[1] = byArray[2];
            byArray2[2] = byArray[3];
            if (this.ihdr.colorType == 2) {
                this.pcu.write(dataOutputStream, PNGConstants.png_sBIT, byArray2, 3);
            } else if (this.ihdr.colorType == 6) {
                byArray2[3] = byArray[0];
                this.pcu.write(dataOutputStream, PNGConstants.png_sBIT, byArray2, 4);
            }
        }
    }

    void png_write_sig(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(PNGConstants.png_sig);
    }

    void writeFilteredRow(DataOutputStream dataOutputStream) throws JimiException, IOException {
        int n;
        this.compress.setInput(this.filter_, 0, 1);
        do {
            n = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += n;
            if (this.zbufO != this.zbuf.length) continue;
            this.pcu.write(dataOutputStream, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.needsInput());
        switch (this.ihdr.colorType) {
            case 0: 
            case 3: {
                if (this.packedBuf_ == null) {
                    n = this.ihdr.width * this.ihdr.bitDepth / 8 + (this.ihdr.width * this.ihdr.bitDepth % 8 != 0 ? 1 : 0);
                    this.packedBuf_ = new byte[n];
                }
                JimiUtil.packPixels(this.ihdr.bitDepth, this.scanLine, this.packedBuf_);
                this.compress.setInput(this.packedBuf_, 0, this.packedBuf_.length);
                break;
            }
            default: {
                this.compress.setInput(this.scanLine, 0, this.scanLine.length);
            }
        }
        do {
            n = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += n;
            if (this.zbufO != this.zbuf.length) continue;
            this.pcu.write(dataOutputStream, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.needsInput());
        byte[] byArray = this.prevScanLine;
        this.prevScanLine = this.scanLine;
        this.scanLine = byArray;
    }

    void writeFinalize(DataOutputStream dataOutputStream) throws JimiException, IOException {
        this.compress.finish();
        do {
            int n = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += n;
            if (!this.compress.finished() && this.zbufO != this.zbuf.length) continue;
            this.pcu.write(dataOutputStream, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.finished());
        this.compress.reset();
    }

    void writeFindFilter(DataOutputStream dataOutputStream) throws JimiException, IOException {
        this.writeFilteredRow(dataOutputStream);
    }

    void writeImageData(DataOutputStream dataOutputStream) throws JimiException, IOException {
        if (this.ihdr.colorType == 2 || this.ihdr.colorType == 6) {
            this.ji.setRGBDefault(true);
        }
        switch (this.ihdr.interlaceMethod) {
            case 0: {
                this.writeInterlaceNone(dataOutputStream);
                break;
            }
            case 1: {
                this.writeInterlaceAdam7(dataOutputStream);
                break;
            }
        }
    }

    void writeInterlaceAdam7(DataOutputStream dataOutputStream) throws JimiException, IOException {
        throw new JimiException("writeImageData() does not support writing interlace PNGs yet");
    }

    void writeInterlaceNone(DataOutputStream dataOutputStream) throws JimiException, IOException {
        this.zbufO = 0;
        int n = 0;
        while (n < this.ji.getHeight()) {
            this.filter_[0] = 0;
            switch (this.ihdr.colorType) {
                case 2: {
                    this.ji.getChannelRGB(n, this.scanLine, 0);
                    break;
                }
                case 6: {
                    this.ji.getChannelRGBA(n, this.scanLine, 0);
                    break;
                }
                case 0: {
                    this.ji.getChannel(0, n, this.scanLine, 0);
                    if (!this.zeroIsWhite_) break;
                    int n2 = this.scanLine.length;
                    while (--n2 >= 0) {
                        this.scanLine[n2] = ~this.scanLine[n2];
                    }
                    break;
                }
                case 3: {
                    this.ji.getChannel(0, n, this.scanLine, 0);
                    break;
                }
            }
            this.writeFindFilter(dataOutputStream);
            this.encoder.setProgress(n * 100 / this.ji.getHeight());
            ++n;
        }
        this.writeFinalize(dataOutputStream);
    }
}

