/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.x11;

import java.io.InputStream;
import java.io.StreamTokenizer;

public class XbmParser {
    private static final int GET_WIDTH = 0;
    private static final int GET_HEIGHT = 1;
    private static final int GET_START = 2;
    private static final int GET_BYTES = 3;
    private StreamTokenizer tokenizer;
    private int width = 0;
    private int height = 0;
    private int length = 0;
    private int[] bitmap = null;

    public XbmParser(InputStream inputStream) {
        this.tokenizer = new StreamTokenizer(inputStream);
        this.tokenizer.slashStarComments(true);
        this.tokenizer.ordinaryChar(47);
    }

    public int[] getBitmap() {
        return this.bitmap;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean parse() {
        try {
            this.parseInput();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseInput() throws Exception {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        n2 = this.tokenizer.nextToken();
        block8: while (n2 != -1) {
            switch (n) {
                case 0: {
                    if (n2 != -2) break;
                    this.width = (int)this.tokenizer.nval;
                    n = 1;
                    break;
                }
                case 1: {
                    if (n2 != -2) break;
                    this.height = (int)this.tokenizer.nval;
                    n = 2;
                    break;
                }
                case 2: {
                    if (n2 != 123) break;
                    this.resetTokenizer();
                    this.width = (this.width + 7) / 8 * 8;
                    this.length = this.width / 8 * this.height;
                    this.bitmap = new int[this.length];
                    n = 3;
                    break;
                }
                case 3: {
                    if (n2 == -3) {
                        if (this.tokenizer.sval.length() <= 2 || this.tokenizer.sval.charAt(0) != '0' || this.tokenizer.sval.charAt(1) != 'x' && this.tokenizer.sval.charAt(1) != 'x') break;
                        try {
                            int n4 = Integer.parseInt(this.tokenizer.sval.substring(2), 16);
                            this.bitmap[n3++] = n4;
                            break;
                        }
                        catch (Exception exception) {
                            n2 = -1;
                            --n3;
                            continue block8;
                        }
                    }
                    if (n2 != 125) break;
                    n2 = -1;
                }
            }
            n2 = this.tokenizer.nextToken();
        }
        if (this.width != 0 && this.height != 0 && n3 == this.length) {
            return;
        }
        throw new Exception();
    }

    private void resetTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 102);
        this.tokenizer.wordChars(65, 70);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(120, 120);
        this.tokenizer.wordChars(88, 88);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.slashStarComments(true);
    }
}

