/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk.handlers;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logging.jdk.handlers.FileHandler;
import org.jboss.logging.jdk.handlers.RollingCalendar;

public class DailyRollingFileHandler
extends FileHandler {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyRollingFileHandler() {
    }

    public DailyRollingFileHandler(Formatter layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            this.reportError("Either File or DatePattern options are not set for appender [" + this.name + "].", null, 4);
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                this.debug("Appender [" + this.name + "] to be rolled every minute.");
                break;
            }
            case 1: {
                this.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                break;
            }
            case 2: {
                this.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                break;
            }
            case 3: {
                this.debug("Appender [" + this.name + "] to be rolled at midnight.");
                break;
            }
            case 4: {
                this.debug("Appender [" + this.name + "] to be rolled at start of week.");
                break;
            }
            case 5: {
                this.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                break;
            }
            default: {
                this.reportError("Unknown periodicity for appender [" + this.name + "].", null, 5);
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.reportError("Missing DatePattern option in rollOver().", null, 4);
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.close();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            this.debug(this.fileName + " -> " + this.scheduledFilename);
        } else {
            this.reportError("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].", null, 4);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.reportError("setFile(" + this.fileName + ", false) call failed.", null, 4);
        }
        this.scheduledFilename = datedFilename;
    }

    protected void subPublish(LogRecord event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                this.reportError("rollOver() failed.", ioe, 4);
            }
        }
        super.subPublish(event);
    }
}

