/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ITextUtils {
    static Map<String, Color> colorMap = new HashMap<String, Color>();

    public static int alignmentValue(String alignment) {
        if ("Center".equalsIgnoreCase(alignment)) {
            return 1;
        }
        if ("Left".equalsIgnoreCase(alignment)) {
            return 0;
        }
        if ("Right".equalsIgnoreCase(alignment)) {
            return 2;
        }
        if ("Justify".equalsIgnoreCase(alignment)) {
            return 3;
        }
        if ("JustifyAll".equalsIgnoreCase(alignment)) {
            return 8;
        }
        if ("Top".equalsIgnoreCase(alignment)) {
            return 4;
        }
        if ("Middle".equalsIgnoreCase(alignment)) {
            return 5;
        }
        if ("Bottom".equalsIgnoreCase(alignment)) {
            return 6;
        }
        if ("Baseline".equalsIgnoreCase(alignment)) {
            return 7;
        }
        return -1;
    }

    public static Rectangle pageSizeValue(String name) {
        if (name.indexOf(32) != -1) {
            int[] sizes = ITextUtils.stringToIntArray(name);
            if (sizes.length != 2) {
                throw new RuntimeException("page size should contain two integer numbers");
            }
            return new Rectangle((float)sizes[0], (float)sizes[1]);
        }
        try {
            Field field = PageSize.class.getDeclaredField(name.toUpperCase());
            return (Rectangle)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't find page size " + name);
        }
    }

    public static Color colorValue(String colorName) {
        Color color = colorMap.get(colorName.toLowerCase());
        if (color == null) {
            color = Color.decode(colorName);
        }
        return color;
    }

    public static float[] stringToFloatArray(String text) {
        String[] parts = text.split("\\s");
        float[] values = new float[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = Float.valueOf(parts[i]).floatValue();
        }
        return values;
    }

    public static int[] stringToIntArray(String text) {
        String[] parts = text.split("\\s");
        int[] values = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = Integer.valueOf(parts[i]);
        }
        return values;
    }

    static {
        colorMap.put("white", Color.white);
        colorMap.put("gray", Color.gray);
        colorMap.put("lightgray", Color.lightGray);
        colorMap.put("darkgray", Color.darkGray);
        colorMap.put("black", Color.black);
        colorMap.put("red", Color.red);
        colorMap.put("pink", Color.pink);
        colorMap.put("yellow", Color.yellow);
        colorMap.put("green", Color.green);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("blue", Color.blue);
    }
}

