/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.List;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryUnitConfigMap;

public abstract class ParameterAccessor {
    public static final String DEVICE_PARAMETERS = "device-parameters";

    public static Object getParameterObject(String name, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue(config);
        }
        return null;
    }

    public static String getStringParameter(String name, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    public static String getStringParameter(String name, String defaultVal, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue();
        }
        return defaultVal;
    }

    public static boolean getBoolParameter(String name, boolean defaultVal, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param == null) {
            return defaultVal;
        }
        String paramVal = param.getValue();
        if (paramVal == null) {
            return defaultVal;
        }
        if ((paramVal = paramVal.trim()).equals("true")) {
            return true;
        }
        if (paramVal.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    public static Parameter getParamter(String name, ContentDeliveryConfig config) {
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in method call.");
        }
        if (config == null) {
            throw new IllegalArgumentException("null 'config' arg in method call.");
        }
        List<ContentDeliveryUnitConfigMap> list = config.getSmooksResourceConfigurations(DEVICE_PARAMETERS);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SmooksResourceConfiguration resourceConfig = (SmooksResourceConfiguration)((Object)list.get(i));
                Parameter param = resourceConfig.getParameter(name);
                if (param == null) continue;
                return param;
            }
        }
        return null;
    }
}

