/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationSortComparator;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitConfigMapTable;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.delivery.ExpandableContentDeliveryUnit;
import org.milyn.delivery.JavaContentDeliveryUnitCreator;
import org.milyn.delivery.UnsupportedContentDeliveryUnitTypeException;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.dom.Phase;
import org.milyn.delivery.dom.VisitPhase;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.dtd.DTDStore;
import org.milyn.profile.ProfileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDeliveryConfigImpl
implements DOMContentDeliveryConfig {
    private static Log logger = LogFactory.getLog(ContentDeliveryConfigImpl.class);
    private static final String DELIVERY_CONFIG_TABLE_CTX_KEY = ContentDeliveryConfig.class.getName() + "#configTable";
    private ProfileSet profileSet;
    private ApplicationContext applicationContext;
    private static final String ELCSPEC_PREFIX = "elcspec:";
    private Hashtable<String, List<SmooksResourceConfiguration>> resourceConfigTable = new Hashtable();
    private ContentDeliveryUnitConfigMapTable assemblyUnitTable = new ContentDeliveryUnitConfigMapTable();
    private ContentDeliveryUnitConfigMapTable processingUnitTable = new ContentDeliveryUnitConfigMapTable();
    private ContentDeliveryUnitConfigMapTable serializationUnitTable = new ContentDeliveryUnitConfigMapTable();
    private Hashtable objectsTable = new Hashtable();
    private DTDStore.DTDObjectContainer dtd;
    private static final Vector EMPTY_LIST = new Vector();

    private ContentDeliveryConfigImpl(ProfileSet profileSet, ApplicationContext applicationContext) {
        this.profileSet = profileSet;
        this.applicationContext = applicationContext;
    }

    public static ContentDeliveryConfig getInstance(ProfileSet profileSet, ApplicationContext applicationContext) {
        ContentDeliveryConfigImpl config;
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg passed in method call.");
        }
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg passed in method call.");
        }
        Hashtable<String, ContentDeliveryConfigImpl> configTable = (Hashtable<String, ContentDeliveryConfigImpl>)applicationContext.getAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY);
        if (configTable == null) {
            configTable = new Hashtable<String, ContentDeliveryConfigImpl>();
            applicationContext.setAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY, configTable);
        }
        if ((config = (ContentDeliveryConfigImpl)configTable.get(profileSet.getBaseProfile())) == null) {
            config = new ContentDeliveryConfigImpl(profileSet, applicationContext);
            config.load();
            configTable.put(profileSet.getBaseProfile(), config);
        }
        return config;
    }

    private void load() {
        List<SmooksResourceConfiguration> resourceConfigsList = Arrays.asList(this.applicationContext.getStore().getSmooksResourceConfigurations(this.profileSet));
        this.buildSmooksResourceConfigurationTable(resourceConfigsList);
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        List<SmooksResourceConfiguration> dtdSmooksResourceConfigurations = this.resourceConfigTable.get("dtd");
        if (dtdSmooksResourceConfigurations != null && dtdSmooksResourceConfigurations.size() > 0) {
            SmooksResourceConfiguration dtdSmooksResourceConfiguration = dtdSmooksResourceConfigurations.get(0);
            byte[] dtdDataBytes = dtdSmooksResourceConfiguration.getBytes();
            if (dtdDataBytes != null) {
                DTDStore.addDTD(this.profileSet, new ByteArrayInputStream(dtdDataBytes));
                this.dtd = DTDStore.getDTDObject(this.profileSet);
            } else {
                logger.error((Object)("DTD resource [" + dtdSmooksResourceConfiguration.getResource() + "] not found in classpath."));
            }
        }
        this.expandSmooksResourceConfigurationTable();
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        if (logger.isDebugEnabled()) {
            this.logResourceConfig();
        }
        this.extractContentDeliveryUnits();
    }

    private void logResourceConfig() {
        logger.debug((Object)"==================================================================================================");
        logger.debug((Object)("Resource configuration (sorted) for profile [" + this.profileSet.getBaseProfile() + "].  Sub Profiles: [" + this.profileSet + "]"));
        Iterator<Map.Entry<String, List<SmooksResourceConfiguration>>> configurations = this.resourceConfigTable.entrySet().iterator();
        int i = 0;
        while (configurations.hasNext()) {
            Map.Entry<String, List<SmooksResourceConfiguration>> entry = configurations.next();
            List<SmooksResourceConfiguration> resources = entry.getValue();
            logger.debug((Object)(i + ") " + entry.getKey()));
            for (int ii = 0; ii < resources.size(); ++ii) {
                logger.debug((Object)("\t(" + ii + ") " + resources.get(ii)));
            }
        }
        logger.debug((Object)"==================================================================================================");
    }

    private void buildSmooksResourceConfigurationTable(List resourceConfigsList) {
        for (SmooksResourceConfiguration config : resourceConfigsList) {
            this.addResourceConfiguration(config);
        }
    }

    private void addResourceConfiguration(SmooksResourceConfiguration config) {
        Vector<SmooksResourceConfiguration> selectorUnits;
        String target = config.getSelector();
        if (config.isSelectorContextual()) {
            target = config.getTargetElement();
        }
        if ((selectorUnits = (Vector<SmooksResourceConfiguration>)this.resourceConfigTable.get(target)) == null) {
            selectorUnits = new Vector<SmooksResourceConfiguration>();
            this.resourceConfigTable.put(target, selectorUnits);
        }
        selectorUnits.addElement(config);
    }

    private void expandSmooksResourceConfigurationTable() {
        class ExpansionSmooksResourceConfigurationStrategy
        implements SmooksResourceConfigurationStrategy {
            ExpansionSmooksResourceConfigurationStrategy() {
            }

            public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
                if (resourceConfig.isXmlDef()) {
                    String[] elements = ContentDeliveryConfigImpl.this.getDTDElements(resourceConfig.getSelector().substring(SmooksResourceConfiguration.XML_DEF_PREFIX.length()));
                    for (int i = 0; i < elements.length; ++i) {
                        ContentDeliveryConfigImpl.this.addObject(elements[i], resourceConfig, ContentDeliveryConfigImpl.this.resourceConfigTable);
                    }
                }
            }
        }
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(new ExpansionSmooksResourceConfigurationStrategy());
        tableIterator.iterate();
    }

    private void sortSmooksResourceConfigurations(Hashtable<String, List<SmooksResourceConfiguration>> table) {
        if (!table.isEmpty()) {
            for (Map.Entry<String, List<SmooksResourceConfiguration>> entry : table.entrySet()) {
                List<SmooksResourceConfiguration> markupElSmooksResourceConfigurations = entry.getValue();
                SmooksResourceConfiguration[] resourceConfigs = markupElSmooksResourceConfigurations.toArray(new SmooksResourceConfiguration[markupElSmooksResourceConfigurations.size()]);
                SmooksResourceConfigurationSortComparator sortComparator = new SmooksResourceConfigurationSortComparator(this.profileSet);
                Arrays.sort(resourceConfigs, sortComparator);
                entry.setValue(new Vector<SmooksResourceConfiguration>(Arrays.asList(resourceConfigs)));
            }
        }
    }

    private void extractContentDeliveryUnits() {
        ContentDeliveryExtractionStrategy cduStrategy = new ContentDeliveryExtractionStrategy(this.applicationContext);
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(cduStrategy);
        tableIterator.iterate();
        cduStrategy.processExpansionConfigurations();
    }

    private String[] getDTDElements(String string) {
        String tmpString = string.toLowerCase();
        if (tmpString.startsWith(ELCSPEC_PREFIX)) {
            if ((tmpString = tmpString.substring(ELCSPEC_PREFIX.length())).equals("empty")) {
                return this.dtd.getEmptyElements();
            }
            if (tmpString.equals("not-empty")) {
                return this.dtd.getNonEmptyElements();
            }
            if (tmpString.equals("any")) {
                return this.dtd.getAnyElements();
            }
            if (tmpString.equals("not-any")) {
                return this.dtd.getNonAnyElements();
            }
            if (tmpString.equals("mixed")) {
                return this.dtd.getMixedElements();
            }
            if (tmpString.equals("not-mixed")) {
                return this.dtd.getNonMixedElements();
            }
            if (tmpString.equals("pcdata")) {
                return this.dtd.getPCDataElements();
            }
            if (tmpString.equals("not-pcdata")) {
                return this.dtd.getNonPCDataElements();
            }
        }
        throw new IllegalStateException("Unsupported DTD spec definition [" + string + "]");
    }

    private void addObject(String element, Object object, Hashtable table) {
        Vector<Object> markupElCDRs = (Vector<Object>)table.get(element);
        if (markupElCDRs == null) {
            markupElCDRs = new Vector<Object>();
            table.put(element, markupElCDRs);
        }
        if (!markupElCDRs.contains(object)) {
            markupElCDRs.add(object);
        }
    }

    @Override
    public ContentDeliveryUnitConfigMapTable getProcessingUnits() {
        return this.processingUnitTable;
    }

    public List getSmooksResourceConfigurations(String selector) {
        return this.resourceConfigTable.get(selector.toLowerCase());
    }

    public Map getSmooksResourceConfigurations() {
        return this.resourceConfigTable;
    }

    @Override
    public List getObjects(String selector) {
        Vector<Object> objects = (Vector<Object>)this.objectsTable.get(selector = selector.toLowerCase());
        if (objects == null) {
            List<SmooksResourceConfiguration> unitDefs = this.resourceConfigTable.get(selector);
            if (unitDefs != null && unitDefs.size() > 0) {
                objects = new Vector<Object>(unitDefs.size());
                for (int i = 0; i < unitDefs.size(); ++i) {
                    SmooksResourceConfiguration resConfig = unitDefs.get(i);
                    objects.add(this.applicationContext.getStore().getObject(resConfig));
                }
            } else {
                objects = EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    @Override
    public ContentDeliveryUnitConfigMapTable getAssemblyUnits() {
        return this.assemblyUnitTable;
    }

    @Override
    public ContentDeliveryUnitConfigMapTable getSerailizationUnits() {
        return this.serializationUnitTable;
    }

    @Override
    public DTDStore.DTDObjectContainer getDTD() {
        return this.dtd;
    }

    private static interface SmooksResourceConfigurationStrategy {
        public void applyStrategy(String var1, SmooksResourceConfiguration var2);
    }

    private class SmooksResourceConfigurationTableIterator {
        private SmooksResourceConfigurationStrategy strategy;

        private SmooksResourceConfigurationTableIterator(SmooksResourceConfigurationStrategy strategy) {
            this.strategy = strategy;
        }

        private void iterate() {
            if (!ContentDeliveryConfigImpl.this.resourceConfigTable.isEmpty()) {
                Hashtable tableClone = (Hashtable)ContentDeliveryConfigImpl.this.resourceConfigTable.clone();
                for (Map.Entry entry : tableClone.entrySet()) {
                    String elementName = (String)entry.getKey();
                    List resourceConfigList = (List)entry.getValue();
                    for (int i = 0; i < resourceConfigList.size(); ++i) {
                        SmooksResourceConfiguration resourceConfig = (SmooksResourceConfiguration)resourceConfigList.get(i);
                        this.strategy.applyStrategy(elementName, resourceConfig);
                    }
                }
            }
        }
    }

    private final class ContentDeliveryExtractionStrategy
    implements SmooksResourceConfigurationStrategy {
        private SmooksResourceConfigurationStore store;
        private List<SmooksResourceConfiguration> expansionConfigs = new ArrayList<SmooksResourceConfiguration>();

        public ContentDeliveryExtractionStrategy(ApplicationContext applicationContext) {
            this.store = applicationContext.getStore();
        }

        public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
            String restype;
            ContentDeliveryUnitCreator creator;
            if (resourceConfig.isJavaContentDeliveryUnit()) {
                try {
                    creator = this.store.getContentDeliveryUnitCreator("class");
                    if (this.addCDU(elementName, resourceConfig, creator)) {
                        return;
                    }
                }
                catch (UnsupportedContentDeliveryUnitTypeException e) {
                    throw new IllegalStateException("No ContentDeliveryUnitCreator configured (IoC) for type 'class' (Java).");
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            if ((creator = this.tryCreateCreator(restype = resourceConfig.getResourceType())) != null && !(creator instanceof JavaContentDeliveryUnitCreator)) {
                try {
                    this.addCDU(elementName, resourceConfig, creator);
                }
                catch (InstantiationException e) {
                    logger.warn((Object)"ContentDeliveryUnit creation failure.", (Throwable)e);
                }
            }
        }

        private ContentDeliveryUnitCreator tryCreateCreator(String restype) {
            ContentDeliveryUnitCreator creator;
            try {
                if (restype == null || restype.trim().equals("")) {
                    logger.warn((Object)"Request to attempt ContentDeliveryUnitCreator creation based on a null/empty resource type.");
                    return null;
                }
                creator = this.store.getContentDeliveryUnitCreator(restype);
            }
            catch (UnsupportedContentDeliveryUnitTypeException e) {
                return null;
            }
            return creator;
        }

        private boolean addCDU(String elementName, SmooksResourceConfiguration resourceConfig, ContentDeliveryUnitCreator creator) throws InstantiationException {
            List<SmooksResourceConfiguration> additionalConfigs;
            ContentDeliveryUnit contentDeliveryUnit;
            try {
                contentDeliveryUnit = creator.create(resourceConfig);
            }
            catch (Throwable thrown) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("ContentDeliveryUnitCreator [" + creator.getClass().getName() + "] unable to create resource processing instance for resource [" + resourceConfig + "]. " + thrown.getMessage()));
                } else {
                    logger.warn((Object)("ContentDeliveryUnitCreator [" + creator.getClass().getName() + "] unable to create resource processing instance for resource [" + resourceConfig + "]."), thrown);
                }
                return false;
            }
            if (contentDeliveryUnit instanceof DOMElementVisitor) {
                Phase phaseAnnotation = contentDeliveryUnit.getClass().getAnnotation(Phase.class);
                String visitPhase = resourceConfig.getStringParameter("VisitPhase", VisitPhase.PROCESSING.toString());
                if (phaseAnnotation != null && phaseAnnotation.value() == VisitPhase.ASSEMBLY) {
                    ContentDeliveryConfigImpl.this.assemblyUnitTable.addMapping(elementName, resourceConfig, contentDeliveryUnit);
                } else if (visitPhase.equalsIgnoreCase(VisitPhase.ASSEMBLY.toString())) {
                    ContentDeliveryConfigImpl.this.assemblyUnitTable.addMapping(elementName, resourceConfig, contentDeliveryUnit);
                } else {
                    ContentDeliveryConfigImpl.this.processingUnitTable.addMapping(elementName, resourceConfig, contentDeliveryUnit);
                }
            } else if (contentDeliveryUnit instanceof SerializationUnit) {
                ContentDeliveryConfigImpl.this.serializationUnitTable.addMapping(elementName, resourceConfig, contentDeliveryUnit);
            } else {
                return false;
            }
            if (contentDeliveryUnit instanceof ExpandableContentDeliveryUnit && (additionalConfigs = ((ExpandableContentDeliveryUnit)contentDeliveryUnit).getExpansionConfigurations()) != null && !additionalConfigs.isEmpty()) {
                this.expansionConfigs.addAll(additionalConfigs);
            }
            return true;
        }

        public void processExpansionConfigurations() {
            for (SmooksResourceConfiguration config : this.expansionConfigs) {
                String targetElement = config.getTargetElement();
                this.applyStrategy(targetElement, config);
                ContentDeliveryConfigImpl.this.addResourceConfiguration(config);
            }
        }
    }
}

