/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.serialize.AbstractSerializationUnit;
import org.milyn.xml.DomUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ContextObjectSerializationUnit
extends AbstractSerializationUnit {
    private static Log logger = LogFactory.getLog(ContextObjectSerializationUnit.class);

    public ContextObjectSerializationUnit(SmooksResourceConfiguration resourceConfig) {
        super(resourceConfig);
    }

    public void writeElementStart(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        String key = DomUtils.getAttributeValue(element, "key");
        if (key != null) {
            Object object = executionContext.getAttribute(key);
            if (object != null) {
                writer.write(object.toString());
            } else {
                logger.debug((Object)("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. No Object instance found on context at '" + key + "'."));
            }
        } else {
            logger.warn((Object)("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. 'key' attribute not specified."));
        }
    }

    public void writeElementEnd(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementText(Text text, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public boolean writeChildElements() {
        return false;
    }

    public static Element createElement(Document ownerDocument, String key) {
        Element resultElement = ownerDocument.createElement("context-object");
        Comment comment = ownerDocument.createComment(" The actual message payload is set on the associated Smooks ExecutionContext under the key '" + key + "'.  Alternatively, you can use Smooks to serialize the message. ");
        resultElement.setAttribute("key", key);
        resultElement.appendChild(comment);
        return resultElement;
    }
}

