/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.registry.AbstractService;
import org.w3c.dom.Element;

public class PublishService
extends AbstractService {
    private TreeSet operations = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.operations = new TreeSet();
        this.operations.add("get_authtoken");
        this.operations.add("get_registeredinfo");
        this.operations.add("discard_authtoken");
        this.operations.add("save_business");
        this.operations.add("save_service");
        this.operations.add("save_binding");
        this.operations.add("save_tmodel");
        this.operations.add("delete_business");
        this.operations.add("delete_service");
        this.operations.add("delete_binding");
        this.operations.add("delete_tmodel");
        this.operations.add("add_publisherassertions");
        this.operations.add("set_publisherassertions");
        this.operations.add("get_publisherassertions");
        this.operations.add("delete_publisherassertions");
        this.operations.add("get_assertionstatusreport");
    }

    public void validateRequest(String operation, String version, Element uddiReq) throws RegistryException {
        if (version == null) {
            throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + operation + " (The " + "'generic' attribute must be present)");
        }
        if (!version.equals("2.0")) {
            throw new UnsupportedException("Only UDDI v2 requests are currently supported. The generic attribute value received was: " + version);
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new FatalErrorException("The UDDI service operation could not be identified.");
        }
        if (!this.operations.contains(operation.toLowerCase())) {
            throw new UnsupportedException("The operation " + operation + " is not " + "supported by the UDDI version 2 Publish API.");
        }
    }
}

