/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.Security;
import xjava.security.Cipher;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.SymmetricCipher;

public final class SPEED
extends Cipher
implements SymmetricCipher {
    private static final boolean \u0157 = Debug.GLOBAL_DEBUG;
    private static final boolean \u0162 = Debug.GLOBAL_DEBUG_SLOW;
    private static final int \u0165 = \u0157 ? Debug.getLevel("SPEED") : 0;
    private static final int \u0153 = 32;
    private static final int \u015f = 6;
    private static final int \u0160 = 32;
    private int \u015c;
    private int \u015e;
    private int \u0156;
    private int \u0163;
    private int \u0155;
    private int \u0154;
    private int \u0151;
    private int \u0152;
    private int \u0150;
    private int \u0164;
    private int \u015b;
    private int \u0158;
    private int \u015d;
    private int[] \u0161;
    private int \u0159;
    private int[] \u015a;

    private static void I(String string) {
        Debug.log("SPEED: " + string);
    }

    public SPEED() {
        block7: {
            String string;
            block6: {
                super(false, false, "CryptixEDT");
                this.\u015c = 64;
                this.\u015e = 8;
                try {
                    string = Security.getAlgorithmProperty("SPEED", "rounds");
                    if (string != null) {
                        this.setRounds(Integer.parseInt(string));
                    }
                }
                catch (Exception exception) {
                    if (!\u0157 || \u0165 <= 0) break block6;
                    SPEED.I("Could not set number of rounds");
                }
            }
            try {
                string = Security.getAlgorithmProperty("SPEED", "blockSize");
                if (string != null) {
                    this.setBlockSize(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                if (!\u0157 || \u0165 <= 0) break block7;
                SPEED.I("Could not set block size");
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return this.\u015e;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.K(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.K(key);
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        boolean bl;
        int n5 = this.\u015e;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n6 = n3 / n5;
        n3 = n6 * n5;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            byArray = byArray3;
            n2 = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n6; ++i2) {
                this.blockEncrypt(byArray, n2, byArray2, n4);
                n2 += n5;
                n4 += n5;
            }
        } else {
            for (int i3 = 0; i3 < n6; ++i3) {
                this.blockDecrypt(byArray, n2, byArray2, n4);
                n2 += n5;
                n4 += n5;
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("rounds")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("rounds.SPEED");
            this.setRounds((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("blockSize")) throw new NoSuchParameterException(string + ".SPEED");
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("blockSize.SPEED");
            this.setBlockSize((Integer)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("rounds")) {
            return new Integer(this.\u015c);
        }
        if (string.equalsIgnoreCase("blockSize")) {
            return new Integer(this.\u015e);
        }
        throw new NoSuchParameterException(string + ".SPEED");
    }

    public void setRounds(int n2) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (n2 < 32 || n2 % 4 != 0) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid number of rounds");
        }
        this.\u015c = n2;
    }

    public int getRounds() {
        return this.\u015c;
    }

    public void setBlockSize(int n2) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (n2 != 8 && n2 != 16 && n2 != 32) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid block size");
        }
        this.\u015e = n2;
    }

    private void K(Key key) throws InvalidKeyException {
        int n2;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        int n3 = byArray.length;
        if (n3 < 6 || n3 > 32) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.E(byArray.length);
        this.\u015a = new int[this.\u015d];
        this.\u0161 = new int[this.\u015c];
        for (n2 = 0; n2 < this.\u0159; ++n2) {
            this.\u015a[n2] = byArray[2 * n2] | byArray[2 * n2 + 1] << 8;
        }
        for (n2 = this.\u0159; n2 < this.\u015d; ++n2) {
            int n4 = this.\u0151 & this.\u0154 ^ this.\u0154 & this.\u0155 ^ this.\u0155 & this.\u0151;
            n4 = n4 << 5 | n4 >>> 11;
            n4 += this.\u0151 + this.\u015a[n2 % this.\u0159];
            this.\u0151 = this.\u0154;
            this.\u0154 = this.\u0155;
            this.\u0155 = this.\u015a[n2] = (n4 &= 0xFFFF);
        }
        if (\u0157 && \u0165 >= 5) {
            SPEED.I("kb_bits=" + this.\u015d + ", kb.length=" + this.\u015a.length + ", round_key.length=" + this.\u0161.length);
        }
        switch (this.\u0163) {
            case 256: {
                for (n2 = 0; n2 < this.\u015d / 2; ++n2) {
                    this.\u0161[n2] = this.\u015a[2 * n2] | this.\u015a[2 * n2 + 1] << 16;
                }
                break;
            }
            case 128: {
                for (n2 = 0; n2 < this.\u015d; ++n2) {
                    this.\u0161[n2] = this.\u015a[n2];
                }
                break;
            }
            case 64: {
                for (n2 = 0; n2 < this.\u015d; ++n2) {
                    this.\u0161[2 * n2] = this.\u015a[n2] & 0xFF;
                    this.\u0161[2 * n2 + 1] = this.\u015a[n2] >>> 8 & 0xFF;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.\u0163 + " illegal in key_schedule?");
            }
        }
    }

    private void E(int n2) {
        this.\u0156 = n2 * 8;
        this.\u0159 = n2 / 2;
        this.D(this.\u0156);
        this.\u0163 = this.\u015e * 8;
        this.\u0152 = this.\u0163 / 8;
        this.\u0150 = this.\u0152 / 2;
        switch (this.\u0163) {
            case 256: {
                this.\u0164 = -1;
                this.\u015b = 65535;
                this.\u0158 = 11;
                this.\u015d = 2 * this.\u015c;
                break;
            }
            case 128: {
                this.\u0164 = 65535;
                this.\u015b = 255;
                this.\u0158 = 4;
                this.\u015d = this.\u015c;
                break;
            }
            case 64: {
                this.\u0164 = 255;
                this.\u015b = 15;
                this.\u0158 = 1;
                this.\u015d = this.\u015c / 2;
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.\u0163 + " is bad data size (not 64/128/256)");
            }
        }
    }

    private void D(int n2) {
        switch (n2) {
            case 48: {
                this.\u0155 = 57211;
                this.\u0154 = 54825;
                this.\u0151 = 59867;
                return;
            }
            case 64: {
                this.\u0155 = 13871;
                this.\u0154 = 23808;
                this.\u0151 = 61967;
                return;
            }
            case 80: {
                this.\u0155 = 50129;
                this.\u0154 = 8146;
                this.\u0151 = 22683;
                return;
            }
            case 96: {
                this.\u0155 = 17170;
                this.\u0154 = 37355;
                this.\u0151 = 29070;
                return;
            }
            case 112: {
                this.\u0155 = 48938;
                this.\u0154 = 7805;
                this.\u0151 = 45655;
                return;
            }
            case 128: {
                this.\u0155 = 30630;
                this.\u0154 = 5716;
                this.\u0151 = 27434;
                return;
            }
            case 144: {
                this.\u0155 = 3483;
                this.\u0154 = 43475;
                this.\u0151 = 26255;
                return;
            }
            case 160: {
                this.\u0155 = 6590;
                this.\u0154 = 63573;
                this.\u0151 = 28056;
                return;
            }
            case 176: {
                this.\u0155 = 557;
                this.\u0154 = 58594;
                this.\u0151 = 53271;
                return;
            }
            case 192: {
                this.\u0155 = 59951;
                this.\u0154 = 30066;
                this.\u0151 = 50101;
                return;
            }
            case 208: {
                this.\u0155 = 4230;
                this.\u0154 = 18444;
                this.\u0151 = 15014;
                return;
            }
            case 224: {
                this.\u0155 = 40096;
                this.\u0154 = 39159;
                this.\u0151 = 53476;
                return;
            }
            case 240: {
                this.\u0155 = 9532;
                this.\u0154 = 51457;
                this.\u0151 = 22003;
                return;
            }
            case 256: {
                this.\u0155 = 39924;
                this.\u0154 = 63065;
                this.\u0151 = 55148;
                return;
            }
        }
        throw new CryptixException("SPEED: " + n2 + " is bad key length (not 48 .. 256 % 16)");
    }

    void I() {
        int n2;
        if (0 == this.\u0163) {
            SPEED.I("no data set yet");
            return;
        }
        SPEED.I("KEY SCHEDULE");
        SPEED.I(" data_bits " + this.\u0163);
        SPEED.I(" kb_bits " + this.\u015d);
        SPEED.I(" kb.length " + this.\u015a.length);
        SPEED.I(" f_wd_mask " + Hex.intToString(this.\u0164));
        SPEED.I(" h_wd_mask " + Hex.intToString(this.\u015b));
        SPEED.I(" v_shift " + this.\u0158);
        SPEED.I(" double byte buffer");
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.\u0159; ++n2) {
            stringBuffer.append(" ").append(Hex.intToString(this.\u015a[n2]));
        }
        SPEED.I(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        switch (this.\u0163) {
            case 256: {
                for (n2 = 0; n2 < this.\u015d / 2; ++n2) {
                    stringBuffer.append(" ").append(Hex.intToString(this.\u0161[n2]));
                }
                break;
            }
            case 128: {
                for (n2 = 0; n2 < this.\u015d; ++n2) {
                    stringBuffer.append(" ").append(Hex.shortToString(this.\u0161[n2]));
                }
                break;
            }
            case 64: {
                for (n2 = 0; n2 < this.\u015d * 2; ++n2) {
                    stringBuffer.append(" ").append(Hex.byteToString(this.\u0161[n2]));
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.\u0163 + " illegal in key_schedule?");
            }
        }
        SPEED.I(stringBuffer.toString());
    }

    private void A(byte[] byArray, int n2, int[] nArray) {
        switch (this.\u0163) {
            case 256: {
                for (int i2 = 0; i2 < 8; ++i2) {
                    nArray[i2] = byArray[n2 + 4 * i2] & 0xFF | byArray[n2 + 4 * i2 + 1] << 8 & 0xFF00 | byArray[n2 + 4 * i2 + 2] << 16 & 0xFF0000 | byArray[n2 + 4 * i2 + 3] << 24 & 0xFF000000;
                }
                break;
            }
            case 128: {
                for (int i3 = 0; i3 < 8; ++i3) {
                    nArray[i3] = byArray[n2 + 2 * i3] & 0xFF | byArray[n2 + 2 * i3 + 1] << 8 & 0xFF00;
                }
                break;
            }
            case 64: {
                for (int i4 = 0; i4 < 8; ++i4) {
                    nArray[i4] = byArray[n2 + i4] & 0xFF;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.\u0163 + " illegal in key_schedule?");
            }
        }
    }

    protected void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.A(byArray, n2, nArray);
        this.C(nArray, nArray2);
        this.A(nArray2, byArray2, n3);
    }

    private void A(int[] nArray, byte[] byArray, int n2) {
        switch (this.\u0163) {
            case 256: {
                for (int i2 = 0; i2 < 8; ++i2) {
                    byArray[4 * i2 + n2] = (byte)(nArray[i2] & 0xFF);
                    byArray[4 * i2 + 1 + n2] = (byte)(nArray[i2] >>> 8 & 0xFF);
                    byArray[4 * i2 + 2 + n2] = (byte)(nArray[i2] >>> 16 & 0xFF);
                    byArray[4 * i2 + 3 + n2] = (byte)(nArray[i2] >>> 24 & 0xFF);
                }
                break;
            }
            case 128: {
                for (int i3 = 0; i3 < 8; ++i3) {
                    byArray[2 * i3 + n2] = (byte)(nArray[i3] & 0xFF);
                    byArray[2 * i3 + 1 + n2] = (byte)(nArray[i3] >>> 8 & 0xFF);
                }
                break;
            }
            case 64: {
                for (int i4 = 0; i4 < 8; ++i4) {
                    byArray[i4 + n2] = (byte)(nArray[i4] & 0xFF);
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.\u0163 + " illegal in key_schedule?");
            }
        }
    }

    protected void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.A(byArray, n2, nArray);
        this.B(nArray, nArray2);
        this.A(nArray2, byArray2, n3);
    }

    private void C(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = nArray[3];
        int n11 = nArray[4];
        int n12 = nArray[5];
        int n13 = nArray[6];
        int n14 = nArray[7];
        int n15 = 0;
        int n16 = this.\u015c / 4;
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n10 ^ n12 & n8 ^ n11 & n9 ^ n8 & n7 ^ n7;
            n4 = ((n5 >>> this.\u0150) + n5 & this.\u015b) >>> this.\u0158;
            n3 = (n14 &= this.\u0164) >>> this.\u0150 - 1 | n14 << this.\u0152 - (this.\u0150 - 1);
            n2 = (n5 &= this.\u0164) >>> n4 | n5 << this.\u0152 - n4;
            n5 = n3 + n2 + this.\u0161[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.\u0164;
        }
        if (\u0162 && \u0165 >= 5) {
            SPEED.I("PASS 1: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n11 & n7 ^ n11 & n10 & n7 ^ n12 & n9 ^ n11 & n10 ^ n11 & n8 ^ n10 & n7 ^ n8;
            n4 = ((n5 >>> this.\u0150) + n5 & this.\u015b) >>> this.\u0158;
            n3 = (n14 &= this.\u0164) >>> this.\u0150 - 1 | n14 << this.\u0152 - (this.\u0150 - 1);
            n2 = (n5 &= this.\u0164) >>> n4 | n5 << this.\u0152 - n4;
            n5 = n3 + n2 + this.\u0161[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.\u0164;
        }
        if (\u0162 && \u0165 >= 5) {
            SPEED.I("PASS 2: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n12 & n11 & n7 ^ n13 & n11 ^ n12 & n9 ^ n10 & n7 ^ n8 & n7 ^ n10;
            n4 = ((n5 >>> this.\u0150) + n5 & this.\u015b) >>> this.\u0158;
            n3 = (n14 &= this.\u0164) >>> this.\u0150 - 1 | n14 << this.\u0152 - (this.\u0150 - 1);
            n2 = (n5 &= this.\u0164) >>> n4 | n5 << this.\u0152 - n4;
            n5 = n3 + n2 + this.\u0161[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.\u0164;
        }
        if (\u0162 && \u0165 >= 5) {
            SPEED.I("PASS 3: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n11 & n9 & n7 ^ n13 & n12 ^ n11 & n10 ^ n10 & n9 ^ n8 & n7 ^ n9;
            n4 = ((n5 >>> this.\u0150) + n5 & this.\u015b) >>> this.\u0158;
            n3 = (n14 &= this.\u0164) >>> this.\u0150 - 1 | n14 << this.\u0152 - (this.\u0150 - 1);
            n2 = (n5 &= this.\u0164) >>> n4 | n5 << this.\u0152 - n4;
            n5 = n3 + n2 + this.\u0161[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.\u0164;
        }
        if (\u0162 && \u0165 >= 5) {
            SPEED.I("PASS 4: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        nArray2[0] = n7;
        nArray2[1] = n8;
        nArray2[2] = n9;
        nArray2[3] = n10;
        nArray2[4] = n11;
        nArray2[5] = n12;
        nArray2[6] = n13;
        nArray2[7] = n14;
    }

    private void B(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray[0] & 0xFFFFFFFF;
        int n8 = nArray[1] & 0xFFFFFFFF;
        int n9 = nArray[2] & 0xFFFFFFFF;
        int n10 = nArray[3] & 0xFFFFFFFF;
        int n11 = nArray[4] & 0xFFFFFFFF;
        int n12 = nArray[5] & 0xFFFFFFFF;
        int n13 = nArray[6] & 0xFFFFFFFF;
        int n14 = nArray[7] & 0xFFFFFFFF;
        int n15 = this.\u015c - 1;
        int n16 = this.\u015c / 4;
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n11 & n9 & n7 ^ n13 & n12 ^ n11 & n10 ^ n10 & n9 ^ n8 & n7 ^ n9;
            n3 = ((n4 >>> this.\u0150) + n4 & this.\u015b) >>> this.\u0158;
            n2 = (n4 &= this.\u0164) >>> n3 | n4 << this.\u0152 - n3;
            n5 -= n2 + this.\u0161[n15--];
            n14 = (n5 &= this.\u0164) << this.\u0150 - 1 | n5 >>> this.\u0152 - (this.\u0150 - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n12 & n11 & n7 ^ n13 & n11 ^ n12 & n9 ^ n10 & n7 ^ n8 & n7 ^ n10;
            n3 = ((n4 >>> this.\u0150) + n4 & this.\u015b) >>> this.\u0158;
            n2 = (n4 &= this.\u0164) >>> n3 | n4 << this.\u0152 - n3;
            n5 -= n2 + this.\u0161[n15--];
            n14 = (n5 &= this.\u0164) << this.\u0150 - 1 | n5 >>> this.\u0152 - (this.\u0150 - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n11 & n7 ^ n11 & n10 & n7 ^ n12 & n9 ^ n11 & n10 ^ n11 & n8 ^ n10 & n7 ^ n8;
            n3 = ((n4 >>> this.\u0150) + n4 & this.\u015b) >>> this.\u0158;
            n2 = (n4 &= this.\u0164) >>> n3 | n4 << this.\u0152 - n3;
            n5 -= n2 + this.\u0161[n15--];
            n14 = (n5 &= this.\u0164) << this.\u0150 - 1 | n5 >>> this.\u0152 - (this.\u0150 - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n10 ^ n12 & n8 ^ n11 & n9 ^ n8 & n7 ^ n7;
            n3 = ((n4 >>> this.\u0150) + n4 & this.\u015b) >>> this.\u0158;
            n2 = (n4 &= this.\u0164) >>> n3 | n4 << this.\u0152 - n3;
            n5 -= n2 + this.\u0161[n15--];
            n14 = (n5 &= this.\u0164) << this.\u0150 - 1 | n5 >>> this.\u0152 - (this.\u0150 - 1);
        }
        nArray2[0] = n7;
        nArray2[1] = n8;
        nArray2[2] = n9;
        nArray2[3] = n10;
        nArray2[4] = n11;
        nArray2[5] = n12;
        nArray2[6] = n13;
        nArray2[7] = n14;
    }

    public static final void main(String[] stringArray) {
        try {
            SPEED.self_test(new PrintWriter(System.err), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter, String[] stringArray) throws Exception {
        printWriter.println("Note: hex strings are printed in conventional order, not the order");
        printWriter.println("      in the SPEED paper.");
        printWriter.println();
        SPEED.A(printWriter, 64, "0000000000000000", "0000000000000000", "2E008019BC26856D");
        SPEED.A(printWriter, 128, "00000000000000000000000000000000", "00000000000000000000000000000000", "A44FBF29EDF6CBF8D7A2DFD57163B909");
        SPEED.A(printWriter, 128, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "6C13E4B9C3171571AB54D816915BC4E8");
        SPEED.A(printWriter, 48, "504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "90C5981EF6A3D21BC178CACDAD6BF39B2E51CDB70A6EE875A73BF5ED883E3692");
        SPEED.A(printWriter, 256, "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000", "6CD44D2B49BC6AA7E95FD1C4AF713A2C0AFA1701308D56298CDF27A02EB09BF5");
        SPEED.A(printWriter, 256, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "C8F3E864263FAF24222E38227BEBC022CF4A9A0ECE89FB81CA1B9BA3BA93D0C5");
        SPEED.A(printWriter, 256, "605F5E5D5C5B5A595857565554535251504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "3DE16CFA9A626847434E1574693FEC1B3FAA558A296B61D708B131CCBA311068");
    }

    private static void A(PrintWriter printWriter, int n2, String string, String string2, String string3) throws Exception {
        byte[] byArray = Hex.fromReversedString(string);
        byte[] byArray2 = Hex.fromReversedString(string2);
        byte[] byArray3 = Hex.fromReversedString(string3);
        SPEED sPEED = new SPEED();
        sPEED.setBlockSize(byArray2.length);
        sPEED.setRounds(n2);
        RawSecretKey rawSecretKey = new RawSecretKey("SPEED", byArray);
        sPEED.initEncrypt(rawSecretKey);
        byte[] byArray4 = sPEED.crypt(byArray2);
        printWriter.println("    key:" + Hex.toString(byArray));
        printWriter.println("  plain:" + Hex.toString(byArray2));
        String string4 = Hex.toString(byArray4);
        printWriter.println("    enc:" + string4);
        String string5 = Hex.toString(byArray3);
        if (string4.equals(string5)) {
            printWriter.print("encryption good; ");
        } else {
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED ENCRYPTION FAILED ********* ");
            sPEED.I();
        }
        sPEED.initDecrypt(rawSecretKey);
        byte[] byArray5 = sPEED.crypt(byArray4);
        string4 = Hex.toString(byArray5);
        string5 = Hex.toString(byArray2);
        if (string4.equals(string5)) {
            printWriter.println("decryption good");
        } else {
            printWriter.println();
            printWriter.println("    enc:" + Hex.toString(byArray4));
            printWriter.println("    dec:" + string4);
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED DECRYPTION FAILED ********* ");
            sPEED.I();
        }
    }
}

