/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String C = "RAW";
    private String B;
    private byte[] D;

    public RawKey(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.B = string;
        this.D = (byte[])byArray.clone();
    }

    public RawKey(String string, byte[] byArray, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.B = string;
        this.D = new byte[n3];
        System.arraycopy(byArray, n2, this.D, 0, n3);
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.D.length; n2 += 4) {
            n3 ^= this.D[n2];
        }
        n3 <<= 8;
        for (n2 = 1; n2 < this.D.length; n2 += 4) {
            n3 ^= this.D[n2];
        }
        n3 <<= 8;
        for (n2 = 2; n2 < this.D.length; n2 += 4) {
            n3 ^= this.D[n2];
        }
        n3 <<= 8;
        for (n2 = 3; n2 < this.D.length; n2 += 4) {
            n3 ^= this.D[n2];
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof RawKey) {
            return ArrayUtil.areEqual(this.D, ((RawKey)object).D);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.B;
    }

    public String getFormat() {
        return C;
    }

    public byte[] getEncoded() {
        return (byte[])this.D.clone();
    }
}

