/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mac;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMAC
extends MessageDigest
implements Parameterized,
Cloneable {
    private static final boolean F = Debug.GLOBAL_DEBUG;
    private static final int K = F ? Debug.getLevel("HMAC") : 0;
    private MessageDigest J;
    private int H;
    private int I;
    private byte[] G;

    private static void D(String string) {
        Debug.log("HMAC: " + string);
    }

    public HMAC(String string, int n2) {
        super("HMAC-" + string);
        try {
            this.J = MessageDigest.getInstance(string, "CryptixEDT");
        }
        catch (Exception exception) {
            try {
                this.J = MessageDigest.getInstance(string);
            }
            catch (Exception exception2) {
                throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception2);
            }
        }
        this.H = n2;
        this.I = this.J.digest().length;
        this.G = new byte[n2];
    }

    private HMAC(HMAC hMAC) throws CloneNotSupportedException {
        super(hMAC.getAlgorithm());
        this.J = (MessageDigest)hMAC.J.clone();
        this.H = hMAC.H;
        this.I = hMAC.I;
        byte[] byArray = hMAC.G;
        this.G = byArray == null ? null : (byte[])byArray.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        return new HMAC(this);
    }

    protected void engineReset() {
        this.J.reset();
        this.G = null;
    }

    protected void engineUpdate(byte by) {
        if (this.G == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.J.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.G == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.J.update(byArray, n2, n3);
    }

    protected byte[] engineDigest() {
        int n2;
        if (F && K >= 7) {
            HMAC.D("engineDigest()");
        }
        if (this.G == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        byte[] byArray = this.J.digest();
        byte[] byArray2 = new byte[this.H];
        for (n2 = 0; n2 < this.G.length; ++n2) {
            byArray2[n2] = (byte)(0x5C ^ this.G[n2]);
        }
        for (n2 = this.G.length; n2 < this.H; ++n2) {
            byArray2[n2] = 92;
        }
        this.J.update(byArray2);
        byte[] byArray3 = this.J.digest(byArray);
        if (F && K >= 7) {
            HMAC.D("... = <" + Hex.toString(byArray3) + ">");
        }
        return byArray3;
    }

    protected int engineGetDigestLength() {
        return this.I;
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        try {
            if (string.equalsIgnoreCase("key")) {
                this.A((byte[])object);
                return;
            }
            if (this.G != null) {
                throw new InvalidParameterException(this.getAlgorithm() + ": Can't set parameter after key has been initialised");
            }
            ((Parameterized)((Object)this.J)).setParameter(string, object);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        try {
            return ((Parameterized)((Object)this.J)).getParameter(string);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    private void A(byte[] byArray) {
        int n2;
        if (F && K >= 7) {
            HMAC.D("setKey(<" + Hex.toString(byArray) + ">)");
        }
        if (this.G != null) {
            this.J.reset();
        }
        this.G = byArray.length > this.H ? this.J.digest(byArray) : (byte[])byArray.clone();
        byte[] byArray2 = new byte[this.H];
        for (n2 = 0; n2 < this.G.length; ++n2) {
            byArray2[n2] = (byte)(0x36 ^ this.G[n2]);
        }
        for (n2 = this.G.length; n2 < this.H; ++n2) {
            byArray2[n2] = 54;
        }
        this.J.update(byArray2);
    }
}

