/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class FTPControlSocket {
    public static final String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.32 2006/10/11 08:51:44 hans Exp $";
    static final String D = "\r\n";
    public static final int CONTROL_PORT = 21;
    private static final String F = "---> ";
    private static final String H = "---> PASS";
    private static Logger C = Logger.getLogger(class$com$enterprisedt$net$ftp$FTPControlSocket == null ? (class$com$enterprisedt$net$ftp$FTPControlSocket = FTPControlSocket.class$("com.enterprisedt.net.ftp.FTPControlSocket")) : class$com$enterprisedt$net$ftp$FTPControlSocket);
    private boolean G = true;
    protected Socket controlSock = null;
    protected Writer writer = null;
    protected BufferedReader reader = null;
    private FTPMessageListener I = null;
    protected String forcedActiveIP;
    private int B = -1;
    private int E = -1;
    private int J = 0;
    private String A;
    protected InetAddress remoteAddr;
    protected boolean autoPassiveIPSubstitution = false;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$FTPControlSocket;

    protected FTPControlSocket(InetAddress inetAddress, int n2, int n3, String string, FTPMessageListener fTPMessageListener) throws IOException, FTPException {
        this(inetAddress, new Socket(inetAddress, n2), n3, string, fTPMessageListener);
    }

    protected FTPControlSocket(InetAddress inetAddress, Socket socket, int n2, String string, FTPMessageListener fTPMessageListener) throws IOException, FTPException {
        this.remoteAddr = inetAddress;
        this.controlSock = socket;
        this.I = fTPMessageListener;
        this.A = string;
        this.A(n2);
        this.initStreams();
        this.B();
    }

    protected void setAutoPassiveIPSubstitution(boolean bl) {
        this.autoPassiveIPSubstitution = bl;
    }

    private void B() throws IOException, FTPException {
        FTPReply fTPReply = this.D();
        String[] stringArray = new String[]{"220", "230"};
        this.validateReply(fTPReply, stringArray);
    }

    protected void initStreams() throws IOException {
        InputStream inputStream = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream, this.A));
        OutputStream outputStream = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(outputStream, this.A);
    }

    String C() {
        InetAddress inetAddress = this.controlSock.getInetAddress();
        return inetAddress.getHostName();
    }

    void A(boolean bl) {
        this.G = bl;
    }

    void A(int n2) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(n2);
    }

    void A(FTPMessageListener fTPMessageListener) {
        this.I = fTPMessageListener;
    }

    public void logout() throws IOException {
        IOException iOException = null;
        try {
            this.writer.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException iOException4) {
            iOException = iOException4;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    FTPDataSocket A(FTPConnectMode fTPConnectMode) throws IOException, FTPException {
        if (fTPConnectMode == FTPConnectMode.ACTIVE) {
            return this.A();
        }
        return this.createDataSocketPASV();
    }

    FTPDataSocket A() throws IOException, FTPException {
        FTPDataSocket fTPDataSocket = this.newActiveDataSocket(this.J);
        if (this.B >= 0 && this.E >= 0) {
            this.J = this.J < this.E ? ++this.J : this.B;
        }
        InetAddress inetAddress = this.controlSock.getLocalAddress();
        short s2 = (short)fTPDataSocket.getLocalPort();
        this.setDataPort(inetAddress, s2);
        return fTPDataSocket;
    }

    private short A(byte by) {
        return by < 0 ? (short)(by + 256) : (short)by;
    }

    protected byte[] toByteArray(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 >> 8), (byte)(s2 & 0xFF)};
        return byArray;
    }

    void A(String string) {
        this.forcedActiveIP = string;
    }

    public void setActivePortRange(int n2, int n3) {
        this.B = n2;
        this.E = n3;
        this.J = this.B;
    }

    private byte[] B(String string) throws FTPException {
        byte[] byArray = new byte[4];
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2 && n3 <= 4; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
            if (c2 != '.' && i2 + 1 != n2) continue;
            try {
                byArray[n3++] = (byte)Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
        }
        return byArray;
    }

    protected void setDataPort(InetAddress inetAddress, short s2) throws IOException, FTPException {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = this.toByteArray(s2);
        if (this.forcedActiveIP != null) {
            C.info("Forcing use of fixed IP for PORT command");
            byArray = this.B(this.forcedActiveIP);
        }
        String string = "PORT " + this.A(byArray[0]) + "," + this.A(byArray[1]) + "," + this.A(byArray[2]) + "," + this.A(byArray[3]) + "," + this.A(byArray2[0]) + "," + this.A(byArray2[1]);
        FTPReply fTPReply = this.sendCommand(string);
        this.validateReply(fTPReply, "200");
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        int n2;
        FTPReply fTPReply = this.sendCommand("PASV");
        this.validateReply(fTPReply, "227");
        String string = fTPReply.getReplyText();
        int n3 = string.indexOf(40);
        int n4 = string.indexOf(41);
        if (n3 < 0) {
            for (n3 = 0; n3 < string.length() && !Character.isDigit(string.charAt(n3)); ++n3) {
            }
            --n3;
        }
        if (n4 < 0) {
            for (n4 = string.length() - 1; n4 > 0 && !Character.isDigit(string.charAt(n4)); --n4) {
            }
            if (++n4 >= string.length()) {
                string = string + ")";
            }
        }
        String string2 = string.substring(n3 + 1, n4).trim();
        int[] nArray = new int[6];
        int n5 = string2.length();
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n5 && n6 <= 6; ++i2) {
            n2 = string2.charAt(i2);
            if (Character.isDigit((char)n2)) {
                stringBuffer.append((char)n2);
            } else if (n2 != 44 && n2 != 32) {
                throw new FTPException("Malformed PASV reply: " + string);
            }
            if (n2 != 44 && i2 + 1 != n5) continue;
            try {
                nArray[n6++] = Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Malformed PASV reply: " + string);
            }
        }
        String string3 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        n2 = (nArray[4] << 8) + nArray[5];
        String string4 = string3;
        if (this.autoPassiveIPSubstitution) {
            string4 = this.remoteAddr.getHostAddress();
            StringBuffer stringBuffer2 = new StringBuffer("Substituting server supplied IP (");
            stringBuffer2.append(string3).append(") with remote host IP (").append(string4).append(")");
            C.debug(stringBuffer2.toString());
        }
        return this.newPassiveDataSocket(string4, n2);
    }

    protected FTPDataSocket newPassiveDataSocket(String string, int n2) throws IOException {
        return new FTPPassiveDataSocket(new Socket(string, n2));
    }

    protected FTPDataSocket newActiveDataSocket(int n2) throws IOException {
        ServerSocket serverSocket = new ServerSocket(n2);
        serverSocket.setSoTimeout(this.controlSock.getSoTimeout());
        return new FTPActiveDataSocket(serverSocket);
    }

    public FTPReply sendCommand(String string) throws IOException {
        this.C(string);
        return this.D();
    }

    void C(String string) throws IOException {
        this.A(F + string, true);
        this.writer.write(string + D);
        this.writer.flush();
    }

    FTPReply D() throws IOException {
        String string = this.reader.readLine();
        while (string != null && string.length() == 0) {
            string = this.reader.readLine();
        }
        if (string == null) {
            throw new IOException("Unexpected null reply received");
        }
        this.A(string, false);
        if (string.length() < 3) {
            throw new IOException("Short reply received");
        }
        String string2 = string.substring(0, 3);
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() > 3) {
            stringBuffer.append(string.substring(4));
        }
        Vector<String> vector = null;
        if (string.charAt(3) == '-') {
            vector = new Vector<String>();
            boolean bl = false;
            while (!bl) {
                string = this.reader.readLine();
                if (string == null) {
                    throw new IOException("Unexpected null reply received");
                }
                if (string.length() == 0) continue;
                this.A(string, false);
                if (string.length() > 3 && string.substring(0, 3).equals(string2) && string.charAt(3) == ' ') {
                    stringBuffer.append(string.substring(3));
                    bl = true;
                    continue;
                }
                stringBuffer.append(" ").append(string);
                vector.addElement(string);
            }
        }
        if (vector != null) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return new FTPReply(string2, stringBuffer.toString(), (String[])objectArray);
        }
        return new FTPReply(string2, stringBuffer.toString());
    }

    FTPReply A(String string, String string2) throws FTPException {
        FTPReply fTPReply = new FTPReply(string);
        if (this.A(fTPReply, string2)) {
            return fTPReply;
        }
        throw new FTPException(fTPReply);
    }

    public FTPReply validateReply(String string, String[] stringArray) throws IOException, FTPException {
        FTPReply fTPReply = new FTPReply(string);
        return this.validateReply(fTPReply, stringArray);
    }

    public FTPReply validateReply(FTPReply fTPReply, String[] stringArray) throws FTPException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.A(fTPReply, stringArray[i2])) continue;
            return fTPReply;
        }
        throw new FTPException(fTPReply);
    }

    public FTPReply validateReply(FTPReply fTPReply, String string) throws FTPException {
        if (this.A(fTPReply, string)) {
            return fTPReply;
        }
        throw new FTPException(fTPReply);
    }

    private boolean A(FTPReply fTPReply, String string) {
        String string2 = fTPReply.getReplyCode();
        if (this.G) {
            return string2.equals(string);
        }
        return string2.charAt(0) == string.charAt(0);
    }

    void A(String string, boolean bl) {
        if (string.startsWith(H)) {
            string = "---> PASS ********";
        }
        C.debug(string);
        if (this.I != null) {
            if (bl) {
                this.I.logCommand(string);
            } else {
                this.I.logReply(string);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

